package software.amazon.awscdk.customresources;

/**
 * An AWS SDK call.
 * 
 * EXPERIMENTAL
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.20.2 (build faba0be)", date = "2019-11-11T17:18:01.658Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.customresources.$Module.class, fqn = "@aws-cdk/custom-resources.AwsSdkCall")
@software.amazon.jsii.Jsii.Proxy(AwsSdkCall.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface AwsSdkCall extends software.amazon.jsii.JsiiSerializable {

    /**
     * The service action to call.
     * 
     * EXPERIMENTAL
     * 
     * @see https://docs.aws.amazon.com/AWSJavaScriptSDK/latest/index.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    java.lang.String getAction();

    /**
     * The service to call.
     * 
     * EXPERIMENTAL
     * 
     * @see https://docs.aws.amazon.com/AWSJavaScriptSDK/latest/index.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    java.lang.String getService();

    /**
     * API version to use for the service.
     * 
     * Default: - use latest available API version
     * 
     * EXPERIMENTAL
     * 
     * @see https://docs.aws.amazon.com/sdk-for-javascript/v2/developer-guide/locking-api-versions.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default java.lang.String getApiVersion() {
        return null;
    }

    /**
     * The regex pattern to use to catch API errors.
     * 
     * The `code` property of the
     * `Error` object will be tested against this pattern. If there is a match an
     * error will not be thrown.
     * 
     * Default: - do not catch errors
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default java.lang.String getCatchErrorPattern() {
        return null;
    }

    /**
     * Restrict the data returned by the custom resource to a specific path in the API response.
     * 
     * Use this to limit the data returned by the custom
     * resource if working with API calls that could potentially result in custom
     * response objects exceeding the hard limit of 4096 bytes.
     * 
     * Example for ECS / updateService: 'service.deploymentConfiguration.maximumPercent'
     * 
     * Default: - return all data
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default java.lang.String getOutputPath() {
        return null;
    }

    /**
     * The parameters for the service action.
     * 
     * EXPERIMENTAL
     * 
     * @see https://docs.aws.amazon.com/AWSJavaScriptSDK/latest/index.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default java.lang.Object getParameters() {
        return null;
    }

    /**
     * The physical resource id of the custom resource for this call.
     * 
     * Either
     * `physicalResourceId` or `physicalResourceIdPath` must be specified for
     * onCreate or onUpdate calls.
     * 
     * Default: - no physical resource id
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default java.lang.String getPhysicalResourceId() {
        return null;
    }

    /**
     * The path to the data in the API call response to use as the physical resource id.
     * 
     * Either `physicalResourceId` or `physicalResourceIdPath`
     * must be specified for onCreate or onUpdate calls.
     * 
     * Default: - no path
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default java.lang.String getPhysicalResourceIdPath() {
        return null;
    }

    /**
     * The region to send service requests to. **Note: Cross-region operations are generally considered an anti-pattern.** **Consider first deploying a stack in that region.**.
     * 
     * Default: - the region where this custom resource is deployed
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default java.lang.String getRegion() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link AwsSdkCall}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link AwsSdkCall}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder {
        private java.lang.String action;
        private java.lang.String service;
        private java.lang.String apiVersion;
        private java.lang.String catchErrorPattern;
        private java.lang.String outputPath;
        private java.lang.Object parameters;
        private java.lang.String physicalResourceId;
        private java.lang.String physicalResourceIdPath;
        private java.lang.String region;

        /**
         * Sets the value of Action
         * @param action The service action to call. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder action(java.lang.String action) {
            this.action = action;
            return this;
        }

        /**
         * Sets the value of Service
         * @param service The service to call. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder service(java.lang.String service) {
            this.service = service;
            return this;
        }

        /**
         * Sets the value of ApiVersion
         * @param apiVersion API version to use for the service.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder apiVersion(java.lang.String apiVersion) {
            this.apiVersion = apiVersion;
            return this;
        }

        /**
         * Sets the value of CatchErrorPattern
         * @param catchErrorPattern The regex pattern to use to catch API errors.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder catchErrorPattern(java.lang.String catchErrorPattern) {
            this.catchErrorPattern = catchErrorPattern;
            return this;
        }

        /**
         * Sets the value of OutputPath
         * @param outputPath Restrict the data returned by the custom resource to a specific path in the API response.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder outputPath(java.lang.String outputPath) {
            this.outputPath = outputPath;
            return this;
        }

        /**
         * Sets the value of Parameters
         * @param parameters The parameters for the service action.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder parameters(java.lang.Object parameters) {
            this.parameters = parameters;
            return this;
        }

        /**
         * Sets the value of PhysicalResourceId
         * @param physicalResourceId The physical resource id of the custom resource for this call.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder physicalResourceId(java.lang.String physicalResourceId) {
            this.physicalResourceId = physicalResourceId;
            return this;
        }

        /**
         * Sets the value of PhysicalResourceIdPath
         * @param physicalResourceIdPath The path to the data in the API call response to use as the physical resource id.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder physicalResourceIdPath(java.lang.String physicalResourceIdPath) {
            this.physicalResourceIdPath = physicalResourceIdPath;
            return this;
        }

        /**
         * Sets the value of Region
         * @param region The region to send service requests to. **Note: Cross-region operations are generally considered an anti-pattern.** **Consider first deploying a stack in that region.**.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder region(java.lang.String region) {
            this.region = region;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link AwsSdkCall}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public AwsSdkCall build() {
            return new Jsii$Proxy(action, service, apiVersion, catchErrorPattern, outputPath, parameters, physicalResourceId, physicalResourceIdPath, region);
        }
    }

    /**
     * An implementation for {@link AwsSdkCall}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AwsSdkCall {
        private final java.lang.String action;
        private final java.lang.String service;
        private final java.lang.String apiVersion;
        private final java.lang.String catchErrorPattern;
        private final java.lang.String outputPath;
        private final java.lang.Object parameters;
        private final java.lang.String physicalResourceId;
        private final java.lang.String physicalResourceIdPath;
        private final java.lang.String region;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.action = this.jsiiGet("action", java.lang.String.class);
            this.service = this.jsiiGet("service", java.lang.String.class);
            this.apiVersion = this.jsiiGet("apiVersion", java.lang.String.class);
            this.catchErrorPattern = this.jsiiGet("catchErrorPattern", java.lang.String.class);
            this.outputPath = this.jsiiGet("outputPath", java.lang.String.class);
            this.parameters = this.jsiiGet("parameters", java.lang.Object.class);
            this.physicalResourceId = this.jsiiGet("physicalResourceId", java.lang.String.class);
            this.physicalResourceIdPath = this.jsiiGet("physicalResourceIdPath", java.lang.String.class);
            this.region = this.jsiiGet("region", java.lang.String.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final java.lang.String action, final java.lang.String service, final java.lang.String apiVersion, final java.lang.String catchErrorPattern, final java.lang.String outputPath, final java.lang.Object parameters, final java.lang.String physicalResourceId, final java.lang.String physicalResourceIdPath, final java.lang.String region) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.action = java.util.Objects.requireNonNull(action, "action is required");
            this.service = java.util.Objects.requireNonNull(service, "service is required");
            this.apiVersion = apiVersion;
            this.catchErrorPattern = catchErrorPattern;
            this.outputPath = outputPath;
            this.parameters = parameters;
            this.physicalResourceId = physicalResourceId;
            this.physicalResourceIdPath = physicalResourceIdPath;
            this.region = region;
        }

        @Override
        public java.lang.String getAction() {
            return this.action;
        }

        @Override
        public java.lang.String getService() {
            return this.service;
        }

        @Override
        public java.lang.String getApiVersion() {
            return this.apiVersion;
        }

        @Override
        public java.lang.String getCatchErrorPattern() {
            return this.catchErrorPattern;
        }

        @Override
        public java.lang.String getOutputPath() {
            return this.outputPath;
        }

        @Override
        public java.lang.Object getParameters() {
            return this.parameters;
        }

        @Override
        public java.lang.String getPhysicalResourceId() {
            return this.physicalResourceId;
        }

        @Override
        public java.lang.String getPhysicalResourceIdPath() {
            return this.physicalResourceIdPath;
        }

        @Override
        public java.lang.String getRegion() {
            return this.region;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("action", om.valueToTree(this.getAction()));
            data.set("service", om.valueToTree(this.getService()));
            if (this.getApiVersion() != null) {
                data.set("apiVersion", om.valueToTree(this.getApiVersion()));
            }
            if (this.getCatchErrorPattern() != null) {
                data.set("catchErrorPattern", om.valueToTree(this.getCatchErrorPattern()));
            }
            if (this.getOutputPath() != null) {
                data.set("outputPath", om.valueToTree(this.getOutputPath()));
            }
            if (this.getParameters() != null) {
                data.set("parameters", om.valueToTree(this.getParameters()));
            }
            if (this.getPhysicalResourceId() != null) {
                data.set("physicalResourceId", om.valueToTree(this.getPhysicalResourceId()));
            }
            if (this.getPhysicalResourceIdPath() != null) {
                data.set("physicalResourceIdPath", om.valueToTree(this.getPhysicalResourceIdPath()));
            }
            if (this.getRegion() != null) {
                data.set("region", om.valueToTree(this.getRegion()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/custom-resources.AwsSdkCall"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            AwsSdkCall.Jsii$Proxy that = (AwsSdkCall.Jsii$Proxy) o;

            if (!action.equals(that.action)) return false;
            if (!service.equals(that.service)) return false;
            if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) return false;
            if (this.catchErrorPattern != null ? !this.catchErrorPattern.equals(that.catchErrorPattern) : that.catchErrorPattern != null) return false;
            if (this.outputPath != null ? !this.outputPath.equals(that.outputPath) : that.outputPath != null) return false;
            if (this.parameters != null ? !this.parameters.equals(that.parameters) : that.parameters != null) return false;
            if (this.physicalResourceId != null ? !this.physicalResourceId.equals(that.physicalResourceId) : that.physicalResourceId != null) return false;
            if (this.physicalResourceIdPath != null ? !this.physicalResourceIdPath.equals(that.physicalResourceIdPath) : that.physicalResourceIdPath != null) return false;
            return this.region != null ? this.region.equals(that.region) : that.region == null;
        }

        @Override
        public int hashCode() {
            int result = this.action.hashCode();
            result = 31 * result + (this.service.hashCode());
            result = 31 * result + (this.apiVersion != null ? this.apiVersion.hashCode() : 0);
            result = 31 * result + (this.catchErrorPattern != null ? this.catchErrorPattern.hashCode() : 0);
            result = 31 * result + (this.outputPath != null ? this.outputPath.hashCode() : 0);
            result = 31 * result + (this.parameters != null ? this.parameters.hashCode() : 0);
            result = 31 * result + (this.physicalResourceId != null ? this.physicalResourceId.hashCode() : 0);
            result = 31 * result + (this.physicalResourceIdPath != null ? this.physicalResourceIdPath.hashCode() : 0);
            result = 31 * result + (this.region != null ? this.region.hashCode() : 0);
            return result;
        }
    }
}
