package software.amazon.awscdk.customresources;

/**
 * Initialization properties for the `Provider` construct.
 * 
 * EXPERIMENTAL
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.20.2 (build faba0be)", date = "2019-11-11T17:18:01.658Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.customresources.$Module.class, fqn = "@aws-cdk/custom-resources.ProviderProps")
@software.amazon.jsii.Jsii.Proxy(ProviderProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface ProviderProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The AWS Lambda function to invoke for all resource lifecycle operations (CREATE/UPDATE/DELETE).
     * 
     * This function is responsible to begin the requested resource operation
     * (CREATE/UPDATE/DELETE) and return any additional properties to add to the
     * event, which will later be passed to `isComplete`. The `PhysicalResourceId`
     * property must be included in the response.
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    software.amazon.awscdk.services.lambda.IFunction getOnEventHandler();

    /**
     * The AWS Lambda function to invoke in order to determine if the operation is complete.
     * 
     * This function will be called immediately after `onEvent` and then
     * periodically based on the configured query interval as long as it returns
     * `false`. If the function still returns `false` and the alloted timeout has
     * passed, the operation will fail.
     * 
     * Default: - provider is synchronous. This means that the `onEvent` handler
     * is expected to finish all lifecycle operations within the initial invocation.
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default software.amazon.awscdk.services.lambda.IFunction getIsCompleteHandler() {
        return null;
    }

    /**
     * Time between calls to the `isComplete` handler which determines if the resource has been stabilized.
     * 
     * The first `isComplete` will be called immediately after `handler` and then
     * every `queryInterval` seconds, and until `timeout` has been reached or until
     * `isComplete` returns `true`.
     * 
     * Default: Duration.seconds(5)
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default software.amazon.awscdk.core.Duration getQueryInterval() {
        return null;
    }

    /**
     * Total timeout for the entire operation.
     * 
     * The maximum timeout is 2 hours (yes, it can exceed the AWS Lambda 15 minutes)
     * 
     * Default: Duration.minutes(30)
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default software.amazon.awscdk.core.Duration getTotalTimeout() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link ProviderProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ProviderProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder {
        private software.amazon.awscdk.services.lambda.IFunction onEventHandler;
        private software.amazon.awscdk.services.lambda.IFunction isCompleteHandler;
        private software.amazon.awscdk.core.Duration queryInterval;
        private software.amazon.awscdk.core.Duration totalTimeout;

        /**
         * Sets the value of OnEventHandler
         * @param onEventHandler The AWS Lambda function to invoke for all resource lifecycle operations (CREATE/UPDATE/DELETE). This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder onEventHandler(software.amazon.awscdk.services.lambda.IFunction onEventHandler) {
            this.onEventHandler = onEventHandler;
            return this;
        }

        /**
         * Sets the value of IsCompleteHandler
         * @param isCompleteHandler The AWS Lambda function to invoke in order to determine if the operation is complete.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder isCompleteHandler(software.amazon.awscdk.services.lambda.IFunction isCompleteHandler) {
            this.isCompleteHandler = isCompleteHandler;
            return this;
        }

        /**
         * Sets the value of QueryInterval
         * @param queryInterval Time between calls to the `isComplete` handler which determines if the resource has been stabilized.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder queryInterval(software.amazon.awscdk.core.Duration queryInterval) {
            this.queryInterval = queryInterval;
            return this;
        }

        /**
         * Sets the value of TotalTimeout
         * @param totalTimeout Total timeout for the entire operation.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder totalTimeout(software.amazon.awscdk.core.Duration totalTimeout) {
            this.totalTimeout = totalTimeout;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ProviderProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public ProviderProps build() {
            return new Jsii$Proxy(onEventHandler, isCompleteHandler, queryInterval, totalTimeout);
        }
    }

    /**
     * An implementation for {@link ProviderProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ProviderProps {
        private final software.amazon.awscdk.services.lambda.IFunction onEventHandler;
        private final software.amazon.awscdk.services.lambda.IFunction isCompleteHandler;
        private final software.amazon.awscdk.core.Duration queryInterval;
        private final software.amazon.awscdk.core.Duration totalTimeout;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.onEventHandler = this.jsiiGet("onEventHandler", software.amazon.awscdk.services.lambda.IFunction.class);
            this.isCompleteHandler = this.jsiiGet("isCompleteHandler", software.amazon.awscdk.services.lambda.IFunction.class);
            this.queryInterval = this.jsiiGet("queryInterval", software.amazon.awscdk.core.Duration.class);
            this.totalTimeout = this.jsiiGet("totalTimeout", software.amazon.awscdk.core.Duration.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final software.amazon.awscdk.services.lambda.IFunction onEventHandler, final software.amazon.awscdk.services.lambda.IFunction isCompleteHandler, final software.amazon.awscdk.core.Duration queryInterval, final software.amazon.awscdk.core.Duration totalTimeout) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.onEventHandler = java.util.Objects.requireNonNull(onEventHandler, "onEventHandler is required");
            this.isCompleteHandler = isCompleteHandler;
            this.queryInterval = queryInterval;
            this.totalTimeout = totalTimeout;
        }

        @Override
        public software.amazon.awscdk.services.lambda.IFunction getOnEventHandler() {
            return this.onEventHandler;
        }

        @Override
        public software.amazon.awscdk.services.lambda.IFunction getIsCompleteHandler() {
            return this.isCompleteHandler;
        }

        @Override
        public software.amazon.awscdk.core.Duration getQueryInterval() {
            return this.queryInterval;
        }

        @Override
        public software.amazon.awscdk.core.Duration getTotalTimeout() {
            return this.totalTimeout;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("onEventHandler", om.valueToTree(this.getOnEventHandler()));
            if (this.getIsCompleteHandler() != null) {
                data.set("isCompleteHandler", om.valueToTree(this.getIsCompleteHandler()));
            }
            if (this.getQueryInterval() != null) {
                data.set("queryInterval", om.valueToTree(this.getQueryInterval()));
            }
            if (this.getTotalTimeout() != null) {
                data.set("totalTimeout", om.valueToTree(this.getTotalTimeout()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/custom-resources.ProviderProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ProviderProps.Jsii$Proxy that = (ProviderProps.Jsii$Proxy) o;

            if (!onEventHandler.equals(that.onEventHandler)) return false;
            if (this.isCompleteHandler != null ? !this.isCompleteHandler.equals(that.isCompleteHandler) : that.isCompleteHandler != null) return false;
            if (this.queryInterval != null ? !this.queryInterval.equals(that.queryInterval) : that.queryInterval != null) return false;
            return this.totalTimeout != null ? this.totalTimeout.equals(that.totalTimeout) : that.totalTimeout == null;
        }

        @Override
        public int hashCode() {
            int result = this.onEventHandler.hashCode();
            result = 31 * result + (this.isCompleteHandler != null ? this.isCompleteHandler.hashCode() : 0);
            result = 31 * result + (this.queryInterval != null ? this.queryInterval.hashCode() : 0);
            result = 31 * result + (this.totalTimeout != null ? this.totalTimeout.hashCode() : 0);
            return result;
        }
    }
}
