package software.amazon.awscdk.customresources;

/**
 * Properties for AwsCustomResource.
 * <p>
 * Note that at least onCreate, onUpdate or onDelete must be specified.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * AwsCustomResource awsCustom = AwsCustomResource.Builder.create(this, "aws-custom")
 *         .onCreate(AwsSdkCall.builder()
 *                 .service("...")
 *                 .action("...")
 *                 .parameters(Map.of(
 *                         "text", "..."))
 *                 .physicalResourceId(PhysicalResourceId.of("..."))
 *                 .build())
 *         .onUpdate(AwsSdkCall.builder()
 *                 .service("...")
 *                 .action("...")
 *                 .parameters(Map.of(
 *                         "text", "...",
 *                         "resourceId", new PhysicalResourceIdReference()))
 *                 .build())
 *         .policy(AwsCustomResourcePolicy.fromSdkCalls(SdkCallsPolicyOptions.builder()
 *                 .resources(AwsCustomResourcePolicy.ANY_RESOURCE)
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.62.0 (build 293ac17)", date = "2022-07-29T14:47:27.259Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.customresources.$Module.class, fqn = "@aws-cdk/custom-resources.AwsCustomResourceProps")
@software.amazon.jsii.Jsii.Proxy(AwsCustomResourceProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface AwsCustomResourceProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The policy that will be added to the execution role of the Lambda function implementing this custom resource provider.
     * <p>
     * The custom resource also implements <code>iam.IGrantable</code>, making it possible
     * to use the <code>grantXxx()</code> methods.
     * <p>
     * As this custom resource uses a singleton Lambda function, it's important
     * to note the that function's role will eventually accumulate the
     * permissions/grants from all resources.
     * <p>
     * @see <a href="Policy.fromSdkCalls">Policy.fromSdkCalls</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.customresources.AwsCustomResourcePolicy getPolicy();

    /**
     * A name for the singleton Lambda function implementing this custom resource.
     * <p>
     * The function name will remain the same after the first AwsCustomResource is created in a stack.
     * <p>
     * Default: - AWS CloudFormation generates a unique physical ID and uses that
     * ID for the function's name. For more information, see Name Type.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getFunctionName() {
        return null;
    }

    /**
     * Whether to install the latest AWS SDK v2. Allows to use the latest API calls documented at https://docs.aws.amazon.com/AWSJavaScriptSDK/latest/index.html.
     * <p>
     * The installation takes around 60 seconds.
     * <p>
     * Default: true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getInstallLatestAwsSdk() {
        return null;
    }

    /**
     * The number of days log events of the singleton Lambda function implementing this custom resource are kept in CloudWatch Logs.
     * <p>
     * Default: logs.RetentionDays.INFINITE
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.logs.RetentionDays getLogRetention() {
        return null;
    }

    /**
     * The AWS SDK call to make when the resource is created.
     * <p>
     * Default: - the call when the resource is updated
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.customresources.AwsSdkCall getOnCreate() {
        return null;
    }

    /**
     * The AWS SDK call to make when the resource is deleted.
     * <p>
     * Default: - no call
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.customresources.AwsSdkCall getOnDelete() {
        return null;
    }

    /**
     * The AWS SDK call to make when the resource is updated.
     * <p>
     * Default: - no call
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.customresources.AwsSdkCall getOnUpdate() {
        return null;
    }

    /**
     * Cloudformation Resource type.
     * <p>
     * Default: - Custom::AWS
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getResourceType() {
        return null;
    }

    /**
     * The execution role for the singleton Lambda function implementing this custom resource provider.
     * <p>
     * This role will apply to all <code>AwsCustomResource</code>
     * instances in the stack. The role must be assumable by the
     * <code>lambda.amazonaws.com</code> service principal.
     * <p>
     * Default: - a new role is created
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.IRole getRole() {
        return null;
    }

    /**
     * The timeout for the singleton Lambda function implementing this custom resource.
     * <p>
     * Default: Duration.minutes(2)
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.Duration getTimeout() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link AwsCustomResourceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link AwsCustomResourceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<AwsCustomResourceProps> {
        software.amazon.awscdk.customresources.AwsCustomResourcePolicy policy;
        java.lang.String functionName;
        java.lang.Boolean installLatestAwsSdk;
        software.amazon.awscdk.services.logs.RetentionDays logRetention;
        software.amazon.awscdk.customresources.AwsSdkCall onCreate;
        software.amazon.awscdk.customresources.AwsSdkCall onDelete;
        software.amazon.awscdk.customresources.AwsSdkCall onUpdate;
        java.lang.String resourceType;
        software.amazon.awscdk.services.iam.IRole role;
        software.amazon.awscdk.core.Duration timeout;

        /**
         * Sets the value of {@link AwsCustomResourceProps#getPolicy}
         * @param policy The policy that will be added to the execution role of the Lambda function implementing this custom resource provider. This parameter is required.
         *               The custom resource also implements <code>iam.IGrantable</code>, making it possible
         *               to use the <code>grantXxx()</code> methods.
         *               <p>
         *               As this custom resource uses a singleton Lambda function, it's important
         *               to note the that function's role will eventually accumulate the
         *               permissions/grants from all resources.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder policy(software.amazon.awscdk.customresources.AwsCustomResourcePolicy policy) {
            this.policy = policy;
            return this;
        }

        /**
         * Sets the value of {@link AwsCustomResourceProps#getFunctionName}
         * @param functionName A name for the singleton Lambda function implementing this custom resource.
         *                     The function name will remain the same after the first AwsCustomResource is created in a stack.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder functionName(java.lang.String functionName) {
            this.functionName = functionName;
            return this;
        }

        /**
         * Sets the value of {@link AwsCustomResourceProps#getInstallLatestAwsSdk}
         * @param installLatestAwsSdk Whether to install the latest AWS SDK v2. Allows to use the latest API calls documented at https://docs.aws.amazon.com/AWSJavaScriptSDK/latest/index.html.
         *                            The installation takes around 60 seconds.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder installLatestAwsSdk(java.lang.Boolean installLatestAwsSdk) {
            this.installLatestAwsSdk = installLatestAwsSdk;
            return this;
        }

        /**
         * Sets the value of {@link AwsCustomResourceProps#getLogRetention}
         * @param logRetention The number of days log events of the singleton Lambda function implementing this custom resource are kept in CloudWatch Logs.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logRetention(software.amazon.awscdk.services.logs.RetentionDays logRetention) {
            this.logRetention = logRetention;
            return this;
        }

        /**
         * Sets the value of {@link AwsCustomResourceProps#getOnCreate}
         * @param onCreate The AWS SDK call to make when the resource is created.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder onCreate(software.amazon.awscdk.customresources.AwsSdkCall onCreate) {
            this.onCreate = onCreate;
            return this;
        }

        /**
         * Sets the value of {@link AwsCustomResourceProps#getOnDelete}
         * @param onDelete The AWS SDK call to make when the resource is deleted.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder onDelete(software.amazon.awscdk.customresources.AwsSdkCall onDelete) {
            this.onDelete = onDelete;
            return this;
        }

        /**
         * Sets the value of {@link AwsCustomResourceProps#getOnUpdate}
         * @param onUpdate The AWS SDK call to make when the resource is updated.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder onUpdate(software.amazon.awscdk.customresources.AwsSdkCall onUpdate) {
            this.onUpdate = onUpdate;
            return this;
        }

        /**
         * Sets the value of {@link AwsCustomResourceProps#getResourceType}
         * @param resourceType Cloudformation Resource type.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resourceType(java.lang.String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        /**
         * Sets the value of {@link AwsCustomResourceProps#getRole}
         * @param role The execution role for the singleton Lambda function implementing this custom resource provider.
         *             This role will apply to all <code>AwsCustomResource</code>
         *             instances in the stack. The role must be assumable by the
         *             <code>lambda.amazonaws.com</code> service principal.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder role(software.amazon.awscdk.services.iam.IRole role) {
            this.role = role;
            return this;
        }

        /**
         * Sets the value of {@link AwsCustomResourceProps#getTimeout}
         * @param timeout The timeout for the singleton Lambda function implementing this custom resource.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder timeout(software.amazon.awscdk.core.Duration timeout) {
            this.timeout = timeout;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link AwsCustomResourceProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public AwsCustomResourceProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link AwsCustomResourceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AwsCustomResourceProps {
        private final software.amazon.awscdk.customresources.AwsCustomResourcePolicy policy;
        private final java.lang.String functionName;
        private final java.lang.Boolean installLatestAwsSdk;
        private final software.amazon.awscdk.services.logs.RetentionDays logRetention;
        private final software.amazon.awscdk.customresources.AwsSdkCall onCreate;
        private final software.amazon.awscdk.customresources.AwsSdkCall onDelete;
        private final software.amazon.awscdk.customresources.AwsSdkCall onUpdate;
        private final java.lang.String resourceType;
        private final software.amazon.awscdk.services.iam.IRole role;
        private final software.amazon.awscdk.core.Duration timeout;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.policy = software.amazon.jsii.Kernel.get(this, "policy", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.customresources.AwsCustomResourcePolicy.class));
            this.functionName = software.amazon.jsii.Kernel.get(this, "functionName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.installLatestAwsSdk = software.amazon.jsii.Kernel.get(this, "installLatestAwsSdk", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.logRetention = software.amazon.jsii.Kernel.get(this, "logRetention", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.RetentionDays.class));
            this.onCreate = software.amazon.jsii.Kernel.get(this, "onCreate", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.customresources.AwsSdkCall.class));
            this.onDelete = software.amazon.jsii.Kernel.get(this, "onDelete", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.customresources.AwsSdkCall.class));
            this.onUpdate = software.amazon.jsii.Kernel.get(this, "onUpdate", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.customresources.AwsSdkCall.class));
            this.resourceType = software.amazon.jsii.Kernel.get(this, "resourceType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.role = software.amazon.jsii.Kernel.get(this, "role", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
            this.timeout = software.amazon.jsii.Kernel.get(this, "timeout", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.Duration.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.policy = java.util.Objects.requireNonNull(builder.policy, "policy is required");
            this.functionName = builder.functionName;
            this.installLatestAwsSdk = builder.installLatestAwsSdk;
            this.logRetention = builder.logRetention;
            this.onCreate = builder.onCreate;
            this.onDelete = builder.onDelete;
            this.onUpdate = builder.onUpdate;
            this.resourceType = builder.resourceType;
            this.role = builder.role;
            this.timeout = builder.timeout;
        }

        @Override
        public final software.amazon.awscdk.customresources.AwsCustomResourcePolicy getPolicy() {
            return this.policy;
        }

        @Override
        public final java.lang.String getFunctionName() {
            return this.functionName;
        }

        @Override
        public final java.lang.Boolean getInstallLatestAwsSdk() {
            return this.installLatestAwsSdk;
        }

        @Override
        public final software.amazon.awscdk.services.logs.RetentionDays getLogRetention() {
            return this.logRetention;
        }

        @Override
        public final software.amazon.awscdk.customresources.AwsSdkCall getOnCreate() {
            return this.onCreate;
        }

        @Override
        public final software.amazon.awscdk.customresources.AwsSdkCall getOnDelete() {
            return this.onDelete;
        }

        @Override
        public final software.amazon.awscdk.customresources.AwsSdkCall getOnUpdate() {
            return this.onUpdate;
        }

        @Override
        public final java.lang.String getResourceType() {
            return this.resourceType;
        }

        @Override
        public final software.amazon.awscdk.services.iam.IRole getRole() {
            return this.role;
        }

        @Override
        public final software.amazon.awscdk.core.Duration getTimeout() {
            return this.timeout;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("policy", om.valueToTree(this.getPolicy()));
            if (this.getFunctionName() != null) {
                data.set("functionName", om.valueToTree(this.getFunctionName()));
            }
            if (this.getInstallLatestAwsSdk() != null) {
                data.set("installLatestAwsSdk", om.valueToTree(this.getInstallLatestAwsSdk()));
            }
            if (this.getLogRetention() != null) {
                data.set("logRetention", om.valueToTree(this.getLogRetention()));
            }
            if (this.getOnCreate() != null) {
                data.set("onCreate", om.valueToTree(this.getOnCreate()));
            }
            if (this.getOnDelete() != null) {
                data.set("onDelete", om.valueToTree(this.getOnDelete()));
            }
            if (this.getOnUpdate() != null) {
                data.set("onUpdate", om.valueToTree(this.getOnUpdate()));
            }
            if (this.getResourceType() != null) {
                data.set("resourceType", om.valueToTree(this.getResourceType()));
            }
            if (this.getRole() != null) {
                data.set("role", om.valueToTree(this.getRole()));
            }
            if (this.getTimeout() != null) {
                data.set("timeout", om.valueToTree(this.getTimeout()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/custom-resources.AwsCustomResourceProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            AwsCustomResourceProps.Jsii$Proxy that = (AwsCustomResourceProps.Jsii$Proxy) o;

            if (!policy.equals(that.policy)) return false;
            if (this.functionName != null ? !this.functionName.equals(that.functionName) : that.functionName != null) return false;
            if (this.installLatestAwsSdk != null ? !this.installLatestAwsSdk.equals(that.installLatestAwsSdk) : that.installLatestAwsSdk != null) return false;
            if (this.logRetention != null ? !this.logRetention.equals(that.logRetention) : that.logRetention != null) return false;
            if (this.onCreate != null ? !this.onCreate.equals(that.onCreate) : that.onCreate != null) return false;
            if (this.onDelete != null ? !this.onDelete.equals(that.onDelete) : that.onDelete != null) return false;
            if (this.onUpdate != null ? !this.onUpdate.equals(that.onUpdate) : that.onUpdate != null) return false;
            if (this.resourceType != null ? !this.resourceType.equals(that.resourceType) : that.resourceType != null) return false;
            if (this.role != null ? !this.role.equals(that.role) : that.role != null) return false;
            return this.timeout != null ? this.timeout.equals(that.timeout) : that.timeout == null;
        }

        @Override
        public final int hashCode() {
            int result = this.policy.hashCode();
            result = 31 * result + (this.functionName != null ? this.functionName.hashCode() : 0);
            result = 31 * result + (this.installLatestAwsSdk != null ? this.installLatestAwsSdk.hashCode() : 0);
            result = 31 * result + (this.logRetention != null ? this.logRetention.hashCode() : 0);
            result = 31 * result + (this.onCreate != null ? this.onCreate.hashCode() : 0);
            result = 31 * result + (this.onDelete != null ? this.onDelete.hashCode() : 0);
            result = 31 * result + (this.onUpdate != null ? this.onUpdate.hashCode() : 0);
            result = 31 * result + (this.resourceType != null ? this.resourceType.hashCode() : 0);
            result = 31 * result + (this.role != null ? this.role.hashCode() : 0);
            result = 31 * result + (this.timeout != null ? this.timeout.hashCode() : 0);
            return result;
        }
    }
}
