package software.amazon.awscdk.customresources;

/**
 * Initialization properties for the `Provider` construct.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.customresources.*;
 * import software.amazon.awscdk.services.lambda.*;
 * import software.amazon.awscdk.core.Stack;
 * Function myOnEventLambda;
 * Function myIsCompleteLambda;
 * Stack stack = new Stack();
 * Provider provider = Provider.Builder.create(stack, "myProvider")
 *         .onEventHandler(myOnEventLambda)
 *         .isCompleteHandler(myIsCompleteLambda)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.63.2 (build a8a8833)", date = "2022-08-17T17:31:16.834Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.customresources.$Module.class, fqn = "@aws-cdk/custom-resources.ProviderProps")
@software.amazon.jsii.Jsii.Proxy(ProviderProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ProviderProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The AWS Lambda function to invoke for all resource lifecycle operations (CREATE/UPDATE/DELETE).
     * <p>
     * This function is responsible to begin the requested resource operation
     * (CREATE/UPDATE/DELETE) and return any additional properties to add to the
     * event, which will later be passed to <code>isComplete</code>. The <code>PhysicalResourceId</code>
     * property must be included in the response.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.IFunction getOnEventHandler();

    /**
     * The AWS Lambda function to invoke in order to determine if the operation is complete.
     * <p>
     * This function will be called immediately after <code>onEvent</code> and then
     * periodically based on the configured query interval as long as it returns
     * <code>false</code>. If the function still returns <code>false</code> and the alloted timeout has
     * passed, the operation will fail.
     * <p>
     * Default: - provider is synchronous. This means that the `onEvent` handler
     * is expected to finish all lifecycle operations within the initial invocation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.lambda.IFunction getIsCompleteHandler() {
        return null;
    }

    /**
     * The number of days framework log events are kept in CloudWatch Logs.
     * <p>
     * When
     * updating this property, unsetting it doesn't remove the log retention policy.
     * To remove the retention policy, set the value to <code>INFINITE</code>.
     * <p>
     * Default: logs.RetentionDays.INFINITE
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.logs.RetentionDays getLogRetention() {
        return null;
    }

    /**
     * Provider Lambda name.
     * <p>
     * The provider lambda function name.
     * <p>
     * Default: -  CloudFormation default name from unique physical ID
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getProviderFunctionName() {
        return null;
    }

    /**
     * Time between calls to the `isComplete` handler which determines if the resource has been stabilized.
     * <p>
     * The first <code>isComplete</code> will be called immediately after <code>handler</code> and then
     * every <code>queryInterval</code> seconds, and until <code>timeout</code> has been reached or until
     * <code>isComplete</code> returns <code>true</code>.
     * <p>
     * Default: Duration.seconds(5)
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.Duration getQueryInterval() {
        return null;
    }

    /**
     * AWS Lambda execution role.
     * <p>
     * The role that will be assumed by the AWS Lambda.
     * Must be assumable by the 'lambda.amazonaws.com' service principal.
     * <p>
     * Default: - A default role will be created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.IRole getRole() {
        return null;
    }

    /**
     * Security groups to attach to the provider functions.
     * <p>
     * Only used if 'vpc' is supplied
     * <p>
     * Default: - If `vpc` is not supplied, no security groups are attached. Otherwise, a dedicated security
     * group is created for each function.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup> getSecurityGroups() {
        return null;
    }

    /**
     * Total timeout for the entire operation.
     * <p>
     * The maximum timeout is 2 hours (yes, it can exceed the AWS Lambda 15 minutes)
     * <p>
     * Default: Duration.minutes(30)
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.Duration getTotalTimeout() {
        return null;
    }

    /**
     * The vpc to provision the lambda functions in.
     * <p>
     * Default: - functions are not provisioned inside a vpc.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.IVpc getVpc() {
        return null;
    }

    /**
     * Which subnets from the VPC to place the lambda functions in.
     * <p>
     * Only used if 'vpc' is supplied. Note: internet access for Lambdas
     * requires a NAT gateway, so picking Public subnets is not allowed.
     * <p>
     * Default: - the Vpc default strategy if not specified
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.SubnetSelection getVpcSubnets() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link ProviderProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ProviderProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ProviderProps> {
        software.amazon.awscdk.services.lambda.IFunction onEventHandler;
        software.amazon.awscdk.services.lambda.IFunction isCompleteHandler;
        software.amazon.awscdk.services.logs.RetentionDays logRetention;
        java.lang.String providerFunctionName;
        software.amazon.awscdk.core.Duration queryInterval;
        software.amazon.awscdk.services.iam.IRole role;
        java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup> securityGroups;
        software.amazon.awscdk.core.Duration totalTimeout;
        software.amazon.awscdk.services.ec2.IVpc vpc;
        software.amazon.awscdk.services.ec2.SubnetSelection vpcSubnets;

        /**
         * Sets the value of {@link ProviderProps#getOnEventHandler}
         * @param onEventHandler The AWS Lambda function to invoke for all resource lifecycle operations (CREATE/UPDATE/DELETE). This parameter is required.
         *                       This function is responsible to begin the requested resource operation
         *                       (CREATE/UPDATE/DELETE) and return any additional properties to add to the
         *                       event, which will later be passed to <code>isComplete</code>. The <code>PhysicalResourceId</code>
         *                       property must be included in the response.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder onEventHandler(software.amazon.awscdk.services.lambda.IFunction onEventHandler) {
            this.onEventHandler = onEventHandler;
            return this;
        }

        /**
         * Sets the value of {@link ProviderProps#getIsCompleteHandler}
         * @param isCompleteHandler The AWS Lambda function to invoke in order to determine if the operation is complete.
         *                          This function will be called immediately after <code>onEvent</code> and then
         *                          periodically based on the configured query interval as long as it returns
         *                          <code>false</code>. If the function still returns <code>false</code> and the alloted timeout has
         *                          passed, the operation will fail.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder isCompleteHandler(software.amazon.awscdk.services.lambda.IFunction isCompleteHandler) {
            this.isCompleteHandler = isCompleteHandler;
            return this;
        }

        /**
         * Sets the value of {@link ProviderProps#getLogRetention}
         * @param logRetention The number of days framework log events are kept in CloudWatch Logs.
         *                     When
         *                     updating this property, unsetting it doesn't remove the log retention policy.
         *                     To remove the retention policy, set the value to <code>INFINITE</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logRetention(software.amazon.awscdk.services.logs.RetentionDays logRetention) {
            this.logRetention = logRetention;
            return this;
        }

        /**
         * Sets the value of {@link ProviderProps#getProviderFunctionName}
         * @param providerFunctionName Provider Lambda name.
         *                             The provider lambda function name.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder providerFunctionName(java.lang.String providerFunctionName) {
            this.providerFunctionName = providerFunctionName;
            return this;
        }

        /**
         * Sets the value of {@link ProviderProps#getQueryInterval}
         * @param queryInterval Time between calls to the `isComplete` handler which determines if the resource has been stabilized.
         *                      The first <code>isComplete</code> will be called immediately after <code>handler</code> and then
         *                      every <code>queryInterval</code> seconds, and until <code>timeout</code> has been reached or until
         *                      <code>isComplete</code> returns <code>true</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder queryInterval(software.amazon.awscdk.core.Duration queryInterval) {
            this.queryInterval = queryInterval;
            return this;
        }

        /**
         * Sets the value of {@link ProviderProps#getRole}
         * @param role AWS Lambda execution role.
         *             The role that will be assumed by the AWS Lambda.
         *             Must be assumable by the 'lambda.amazonaws.com' service principal.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder role(software.amazon.awscdk.services.iam.IRole role) {
            this.role = role;
            return this;
        }

        /**
         * Sets the value of {@link ProviderProps#getSecurityGroups}
         * @param securityGroups Security groups to attach to the provider functions.
         *                       Only used if 'vpc' is supplied
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder securityGroups(java.util.List<? extends software.amazon.awscdk.services.ec2.ISecurityGroup> securityGroups) {
            this.securityGroups = (java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup>)securityGroups;
            return this;
        }

        /**
         * Sets the value of {@link ProviderProps#getTotalTimeout}
         * @param totalTimeout Total timeout for the entire operation.
         *                     The maximum timeout is 2 hours (yes, it can exceed the AWS Lambda 15 minutes)
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder totalTimeout(software.amazon.awscdk.core.Duration totalTimeout) {
            this.totalTimeout = totalTimeout;
            return this;
        }

        /**
         * Sets the value of {@link ProviderProps#getVpc}
         * @param vpc The vpc to provision the lambda functions in.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpc(software.amazon.awscdk.services.ec2.IVpc vpc) {
            this.vpc = vpc;
            return this;
        }

        /**
         * Sets the value of {@link ProviderProps#getVpcSubnets}
         * @param vpcSubnets Which subnets from the VPC to place the lambda functions in.
         *                   Only used if 'vpc' is supplied. Note: internet access for Lambdas
         *                   requires a NAT gateway, so picking Public subnets is not allowed.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcSubnets(software.amazon.awscdk.services.ec2.SubnetSelection vpcSubnets) {
            this.vpcSubnets = vpcSubnets;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ProviderProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ProviderProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ProviderProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ProviderProps {
        private final software.amazon.awscdk.services.lambda.IFunction onEventHandler;
        private final software.amazon.awscdk.services.lambda.IFunction isCompleteHandler;
        private final software.amazon.awscdk.services.logs.RetentionDays logRetention;
        private final java.lang.String providerFunctionName;
        private final software.amazon.awscdk.core.Duration queryInterval;
        private final software.amazon.awscdk.services.iam.IRole role;
        private final java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup> securityGroups;
        private final software.amazon.awscdk.core.Duration totalTimeout;
        private final software.amazon.awscdk.services.ec2.IVpc vpc;
        private final software.amazon.awscdk.services.ec2.SubnetSelection vpcSubnets;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.onEventHandler = software.amazon.jsii.Kernel.get(this, "onEventHandler", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.IFunction.class));
            this.isCompleteHandler = software.amazon.jsii.Kernel.get(this, "isCompleteHandler", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.IFunction.class));
            this.logRetention = software.amazon.jsii.Kernel.get(this, "logRetention", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.RetentionDays.class));
            this.providerFunctionName = software.amazon.jsii.Kernel.get(this, "providerFunctionName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.queryInterval = software.amazon.jsii.Kernel.get(this, "queryInterval", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.Duration.class));
            this.role = software.amazon.jsii.Kernel.get(this, "role", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
            this.securityGroups = software.amazon.jsii.Kernel.get(this, "securityGroups", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.ISecurityGroup.class)));
            this.totalTimeout = software.amazon.jsii.Kernel.get(this, "totalTimeout", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.Duration.class));
            this.vpc = software.amazon.jsii.Kernel.get(this, "vpc", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.IVpc.class));
            this.vpcSubnets = software.amazon.jsii.Kernel.get(this, "vpcSubnets", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.SubnetSelection.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.onEventHandler = java.util.Objects.requireNonNull(builder.onEventHandler, "onEventHandler is required");
            this.isCompleteHandler = builder.isCompleteHandler;
            this.logRetention = builder.logRetention;
            this.providerFunctionName = builder.providerFunctionName;
            this.queryInterval = builder.queryInterval;
            this.role = builder.role;
            this.securityGroups = (java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup>)builder.securityGroups;
            this.totalTimeout = builder.totalTimeout;
            this.vpc = builder.vpc;
            this.vpcSubnets = builder.vpcSubnets;
        }

        @Override
        public final software.amazon.awscdk.services.lambda.IFunction getOnEventHandler() {
            return this.onEventHandler;
        }

        @Override
        public final software.amazon.awscdk.services.lambda.IFunction getIsCompleteHandler() {
            return this.isCompleteHandler;
        }

        @Override
        public final software.amazon.awscdk.services.logs.RetentionDays getLogRetention() {
            return this.logRetention;
        }

        @Override
        public final java.lang.String getProviderFunctionName() {
            return this.providerFunctionName;
        }

        @Override
        public final software.amazon.awscdk.core.Duration getQueryInterval() {
            return this.queryInterval;
        }

        @Override
        public final software.amazon.awscdk.services.iam.IRole getRole() {
            return this.role;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup> getSecurityGroups() {
            return this.securityGroups;
        }

        @Override
        public final software.amazon.awscdk.core.Duration getTotalTimeout() {
            return this.totalTimeout;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.IVpc getVpc() {
            return this.vpc;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.SubnetSelection getVpcSubnets() {
            return this.vpcSubnets;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("onEventHandler", om.valueToTree(this.getOnEventHandler()));
            if (this.getIsCompleteHandler() != null) {
                data.set("isCompleteHandler", om.valueToTree(this.getIsCompleteHandler()));
            }
            if (this.getLogRetention() != null) {
                data.set("logRetention", om.valueToTree(this.getLogRetention()));
            }
            if (this.getProviderFunctionName() != null) {
                data.set("providerFunctionName", om.valueToTree(this.getProviderFunctionName()));
            }
            if (this.getQueryInterval() != null) {
                data.set("queryInterval", om.valueToTree(this.getQueryInterval()));
            }
            if (this.getRole() != null) {
                data.set("role", om.valueToTree(this.getRole()));
            }
            if (this.getSecurityGroups() != null) {
                data.set("securityGroups", om.valueToTree(this.getSecurityGroups()));
            }
            if (this.getTotalTimeout() != null) {
                data.set("totalTimeout", om.valueToTree(this.getTotalTimeout()));
            }
            if (this.getVpc() != null) {
                data.set("vpc", om.valueToTree(this.getVpc()));
            }
            if (this.getVpcSubnets() != null) {
                data.set("vpcSubnets", om.valueToTree(this.getVpcSubnets()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/custom-resources.ProviderProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ProviderProps.Jsii$Proxy that = (ProviderProps.Jsii$Proxy) o;

            if (!onEventHandler.equals(that.onEventHandler)) return false;
            if (this.isCompleteHandler != null ? !this.isCompleteHandler.equals(that.isCompleteHandler) : that.isCompleteHandler != null) return false;
            if (this.logRetention != null ? !this.logRetention.equals(that.logRetention) : that.logRetention != null) return false;
            if (this.providerFunctionName != null ? !this.providerFunctionName.equals(that.providerFunctionName) : that.providerFunctionName != null) return false;
            if (this.queryInterval != null ? !this.queryInterval.equals(that.queryInterval) : that.queryInterval != null) return false;
            if (this.role != null ? !this.role.equals(that.role) : that.role != null) return false;
            if (this.securityGroups != null ? !this.securityGroups.equals(that.securityGroups) : that.securityGroups != null) return false;
            if (this.totalTimeout != null ? !this.totalTimeout.equals(that.totalTimeout) : that.totalTimeout != null) return false;
            if (this.vpc != null ? !this.vpc.equals(that.vpc) : that.vpc != null) return false;
            return this.vpcSubnets != null ? this.vpcSubnets.equals(that.vpcSubnets) : that.vpcSubnets == null;
        }

        @Override
        public final int hashCode() {
            int result = this.onEventHandler.hashCode();
            result = 31 * result + (this.isCompleteHandler != null ? this.isCompleteHandler.hashCode() : 0);
            result = 31 * result + (this.logRetention != null ? this.logRetention.hashCode() : 0);
            result = 31 * result + (this.providerFunctionName != null ? this.providerFunctionName.hashCode() : 0);
            result = 31 * result + (this.queryInterval != null ? this.queryInterval.hashCode() : 0);
            result = 31 * result + (this.role != null ? this.role.hashCode() : 0);
            result = 31 * result + (this.securityGroups != null ? this.securityGroups.hashCode() : 0);
            result = 31 * result + (this.totalTimeout != null ? this.totalTimeout.hashCode() : 0);
            result = 31 * result + (this.vpc != null ? this.vpc.hashCode() : 0);
            result = 31 * result + (this.vpcSubnets != null ? this.vpcSubnets.hashCode() : 0);
            return result;
        }
    }
}
