package software.amazon.awscdk.customresources;

/**
 * Properties for AwsCustomResource.
 * <p>
 * Note that at least onCreate, onUpdate or onDelete must be specified.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.1.0 (build df55f5e)", date = "2020-03-24T17:01:55.515Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.customresources.$Module.class, fqn = "@aws-cdk/custom-resources.AwsCustomResourceProps")
@software.amazon.jsii.Jsii.Proxy(AwsCustomResourceProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface AwsCustomResourceProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The policy to apply to the resource.
     * <p>
     * The custom resource also implements <code>iam.IGrantable</code>, making it possible
     * to use the <code>grantXxx()</code> methods.
     * <p>
     * As this custom resource uses a singleton Lambda function, it's important
     * to note the that function's role will eventually accumulate the
     * permissions/grants from all resources.
     * <p>
     * @see Policy.fromSdkCalls
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.customresources.AwsCustomResourcePolicy getPolicy();

    /**
     * The number of days log events of the Lambda function implementing this custom resource are kept in CloudWatch Logs.
     * <p>
     * Default: logs.RetentionDays.INFINITE
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.logs.RetentionDays getLogRetention() {
        return null;
    }

    /**
     * The AWS SDK call to make when the resource is created.
     * <p>
     * Default: - the call when the resource is updated
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.customresources.AwsSdkCall getOnCreate() {
        return null;
    }

    /**
     * The AWS SDK call to make when the resource is deleted.
     * <p>
     * Default: - no call
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.customresources.AwsSdkCall getOnDelete() {
        return null;
    }

    /**
     * The AWS SDK call to make when the resource is updated.
     * <p>
     * Default: - no call
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.customresources.AwsSdkCall getOnUpdate() {
        return null;
    }

    /**
     * Cloudformation Resource type.
     * <p>
     * Default: - Custom::AWS
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getResourceType() {
        return null;
    }

    /**
     * The execution role for the Lambda function implementing this custom resource provider.
     * <p>
     * This role will apply to all <code>AwsCustomResource</code>
     * instances in the stack. The role must be assumable by the
     * <code>lambda.amazonaws.com</code> service principal.
     * <p>
     * Default: - a new role is created
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.IRole getRole() {
        return null;
    }

    /**
     * The timeout for the Lambda function implementing this custom resource.
     * <p>
     * Default: Duration.minutes(2)
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.Duration getTimeout() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link AwsCustomResourceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link AwsCustomResourceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder {
        private software.amazon.awscdk.customresources.AwsCustomResourcePolicy policy;
        private software.amazon.awscdk.services.logs.RetentionDays logRetention;
        private software.amazon.awscdk.customresources.AwsSdkCall onCreate;
        private software.amazon.awscdk.customresources.AwsSdkCall onDelete;
        private software.amazon.awscdk.customresources.AwsSdkCall onUpdate;
        private java.lang.String resourceType;
        private software.amazon.awscdk.services.iam.IRole role;
        private software.amazon.awscdk.core.Duration timeout;

        /**
         * Sets the value of {@link AwsCustomResourceProps#getPolicy}
         * @param policy The policy to apply to the resource. This parameter is required.
         *               The custom resource also implements <code>iam.IGrantable</code>, making it possible
         *               to use the <code>grantXxx()</code> methods.
         *               <p>
         *               As this custom resource uses a singleton Lambda function, it's important
         *               to note the that function's role will eventually accumulate the
         *               permissions/grants from all resources.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder policy(software.amazon.awscdk.customresources.AwsCustomResourcePolicy policy) {
            this.policy = policy;
            return this;
        }

        /**
         * Sets the value of {@link AwsCustomResourceProps#getLogRetention}
         * @param logRetention The number of days log events of the Lambda function implementing this custom resource are kept in CloudWatch Logs.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logRetention(software.amazon.awscdk.services.logs.RetentionDays logRetention) {
            this.logRetention = logRetention;
            return this;
        }

        /**
         * Sets the value of {@link AwsCustomResourceProps#getOnCreate}
         * @param onCreate The AWS SDK call to make when the resource is created.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder onCreate(software.amazon.awscdk.customresources.AwsSdkCall onCreate) {
            this.onCreate = onCreate;
            return this;
        }

        /**
         * Sets the value of {@link AwsCustomResourceProps#getOnDelete}
         * @param onDelete The AWS SDK call to make when the resource is deleted.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder onDelete(software.amazon.awscdk.customresources.AwsSdkCall onDelete) {
            this.onDelete = onDelete;
            return this;
        }

        /**
         * Sets the value of {@link AwsCustomResourceProps#getOnUpdate}
         * @param onUpdate The AWS SDK call to make when the resource is updated.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder onUpdate(software.amazon.awscdk.customresources.AwsSdkCall onUpdate) {
            this.onUpdate = onUpdate;
            return this;
        }

        /**
         * Sets the value of {@link AwsCustomResourceProps#getResourceType}
         * @param resourceType Cloudformation Resource type.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resourceType(java.lang.String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        /**
         * Sets the value of {@link AwsCustomResourceProps#getRole}
         * @param role The execution role for the Lambda function implementing this custom resource provider.
         *             This role will apply to all <code>AwsCustomResource</code>
         *             instances in the stack. The role must be assumable by the
         *             <code>lambda.amazonaws.com</code> service principal.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder role(software.amazon.awscdk.services.iam.IRole role) {
            this.role = role;
            return this;
        }

        /**
         * Sets the value of {@link AwsCustomResourceProps#getTimeout}
         * @param timeout The timeout for the Lambda function implementing this custom resource.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder timeout(software.amazon.awscdk.core.Duration timeout) {
            this.timeout = timeout;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link AwsCustomResourceProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public AwsCustomResourceProps build() {
            return new Jsii$Proxy(policy, logRetention, onCreate, onDelete, onUpdate, resourceType, role, timeout);
        }
    }

    /**
     * An implementation for {@link AwsCustomResourceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AwsCustomResourceProps {
        private final software.amazon.awscdk.customresources.AwsCustomResourcePolicy policy;
        private final software.amazon.awscdk.services.logs.RetentionDays logRetention;
        private final software.amazon.awscdk.customresources.AwsSdkCall onCreate;
        private final software.amazon.awscdk.customresources.AwsSdkCall onDelete;
        private final software.amazon.awscdk.customresources.AwsSdkCall onUpdate;
        private final java.lang.String resourceType;
        private final software.amazon.awscdk.services.iam.IRole role;
        private final software.amazon.awscdk.core.Duration timeout;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.policy = this.jsiiGet("policy", software.amazon.awscdk.customresources.AwsCustomResourcePolicy.class);
            this.logRetention = this.jsiiGet("logRetention", software.amazon.awscdk.services.logs.RetentionDays.class);
            this.onCreate = this.jsiiGet("onCreate", software.amazon.awscdk.customresources.AwsSdkCall.class);
            this.onDelete = this.jsiiGet("onDelete", software.amazon.awscdk.customresources.AwsSdkCall.class);
            this.onUpdate = this.jsiiGet("onUpdate", software.amazon.awscdk.customresources.AwsSdkCall.class);
            this.resourceType = this.jsiiGet("resourceType", java.lang.String.class);
            this.role = this.jsiiGet("role", software.amazon.awscdk.services.iam.IRole.class);
            this.timeout = this.jsiiGet("timeout", software.amazon.awscdk.core.Duration.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final software.amazon.awscdk.customresources.AwsCustomResourcePolicy policy, final software.amazon.awscdk.services.logs.RetentionDays logRetention, final software.amazon.awscdk.customresources.AwsSdkCall onCreate, final software.amazon.awscdk.customresources.AwsSdkCall onDelete, final software.amazon.awscdk.customresources.AwsSdkCall onUpdate, final java.lang.String resourceType, final software.amazon.awscdk.services.iam.IRole role, final software.amazon.awscdk.core.Duration timeout) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.policy = java.util.Objects.requireNonNull(policy, "policy is required");
            this.logRetention = logRetention;
            this.onCreate = onCreate;
            this.onDelete = onDelete;
            this.onUpdate = onUpdate;
            this.resourceType = resourceType;
            this.role = role;
            this.timeout = timeout;
        }

        @Override
        public software.amazon.awscdk.customresources.AwsCustomResourcePolicy getPolicy() {
            return this.policy;
        }

        @Override
        public software.amazon.awscdk.services.logs.RetentionDays getLogRetention() {
            return this.logRetention;
        }

        @Override
        public software.amazon.awscdk.customresources.AwsSdkCall getOnCreate() {
            return this.onCreate;
        }

        @Override
        public software.amazon.awscdk.customresources.AwsSdkCall getOnDelete() {
            return this.onDelete;
        }

        @Override
        public software.amazon.awscdk.customresources.AwsSdkCall getOnUpdate() {
            return this.onUpdate;
        }

        @Override
        public java.lang.String getResourceType() {
            return this.resourceType;
        }

        @Override
        public software.amazon.awscdk.services.iam.IRole getRole() {
            return this.role;
        }

        @Override
        public software.amazon.awscdk.core.Duration getTimeout() {
            return this.timeout;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("policy", om.valueToTree(this.getPolicy()));
            if (this.getLogRetention() != null) {
                data.set("logRetention", om.valueToTree(this.getLogRetention()));
            }
            if (this.getOnCreate() != null) {
                data.set("onCreate", om.valueToTree(this.getOnCreate()));
            }
            if (this.getOnDelete() != null) {
                data.set("onDelete", om.valueToTree(this.getOnDelete()));
            }
            if (this.getOnUpdate() != null) {
                data.set("onUpdate", om.valueToTree(this.getOnUpdate()));
            }
            if (this.getResourceType() != null) {
                data.set("resourceType", om.valueToTree(this.getResourceType()));
            }
            if (this.getRole() != null) {
                data.set("role", om.valueToTree(this.getRole()));
            }
            if (this.getTimeout() != null) {
                data.set("timeout", om.valueToTree(this.getTimeout()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/custom-resources.AwsCustomResourceProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            AwsCustomResourceProps.Jsii$Proxy that = (AwsCustomResourceProps.Jsii$Proxy) o;

            if (!policy.equals(that.policy)) return false;
            if (this.logRetention != null ? !this.logRetention.equals(that.logRetention) : that.logRetention != null) return false;
            if (this.onCreate != null ? !this.onCreate.equals(that.onCreate) : that.onCreate != null) return false;
            if (this.onDelete != null ? !this.onDelete.equals(that.onDelete) : that.onDelete != null) return false;
            if (this.onUpdate != null ? !this.onUpdate.equals(that.onUpdate) : that.onUpdate != null) return false;
            if (this.resourceType != null ? !this.resourceType.equals(that.resourceType) : that.resourceType != null) return false;
            if (this.role != null ? !this.role.equals(that.role) : that.role != null) return false;
            return this.timeout != null ? this.timeout.equals(that.timeout) : that.timeout == null;
        }

        @Override
        public int hashCode() {
            int result = this.policy.hashCode();
            result = 31 * result + (this.logRetention != null ? this.logRetention.hashCode() : 0);
            result = 31 * result + (this.onCreate != null ? this.onCreate.hashCode() : 0);
            result = 31 * result + (this.onDelete != null ? this.onDelete.hashCode() : 0);
            result = 31 * result + (this.onUpdate != null ? this.onUpdate.hashCode() : 0);
            result = 31 * result + (this.resourceType != null ? this.resourceType.hashCode() : 0);
            result = 31 * result + (this.role != null ? this.role.hashCode() : 0);
            result = 31 * result + (this.timeout != null ? this.timeout.hashCode() : 0);
            return result;
        }
    }
}
