package software.amazon.awscdk.customresources;

/**
 * Options for the auto-generation of policies based on the configured SDK calls.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.6.0 (build 248e75b)", date = "2020-06-09T15:22:54.533Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.customresources.$Module.class, fqn = "@aws-cdk/custom-resources.SdkCallsPolicyOptions")
@software.amazon.jsii.Jsii.Proxy(SdkCallsPolicyOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface SdkCallsPolicyOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * The resources that the calls will have access to.
     * <p>
     * It is best to use specific resource ARN's when possible. However, you can also use <code>AwsCustomResourcePolicy.ANY_RESOURCE</code>
     * to allow access to all resources. For example, when <code>onCreate</code> is used to create a resource which you don't
     * know the physical name of in advance.
     * <p>
     * Note that will apply to ALL SDK calls.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getResources();

    /**
     * @return a {@link Builder} of {@link SdkCallsPolicyOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link SdkCallsPolicyOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<SdkCallsPolicyOptions> {
        private java.util.List<java.lang.String> resources;

        /**
         * Sets the value of {@link SdkCallsPolicyOptions#getResources}
         * @param resources The resources that the calls will have access to. This parameter is required.
         *                  It is best to use specific resource ARN's when possible. However, you can also use <code>AwsCustomResourcePolicy.ANY_RESOURCE</code>
         *                  to allow access to all resources. For example, when <code>onCreate</code> is used to create a resource which you don't
         *                  know the physical name of in advance.
         *                  <p>
         *                  Note that will apply to ALL SDK calls.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resources(java.util.List<java.lang.String> resources) {
            this.resources = resources;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link SdkCallsPolicyOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public SdkCallsPolicyOptions build() {
            return new Jsii$Proxy(resources);
        }
    }

    /**
     * An implementation for {@link SdkCallsPolicyOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SdkCallsPolicyOptions {
        private final java.util.List<java.lang.String> resources;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.resources = this.jsiiGet("resources", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final java.util.List<java.lang.String> resources) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.resources = java.util.Objects.requireNonNull(resources, "resources is required");
        }

        @Override
        public java.util.List<java.lang.String> getResources() {
            return this.resources;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("resources", om.valueToTree(this.getResources()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/custom-resources.SdkCallsPolicyOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            SdkCallsPolicyOptions.Jsii$Proxy that = (SdkCallsPolicyOptions.Jsii$Proxy) o;

            return this.resources.equals(that.resources);
        }

        @Override
        public int hashCode() {
            int result = this.resources.hashCode();
            return result;
        }
    }
}
