package software.amazon.awscdk.customresources;

/**
 * Initialization properties for the `Provider` construct.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.12.0 (build 5ddc9f2)", date = "2020-09-22T23:51:42.642Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.customresources.$Module.class, fqn = "@aws-cdk/custom-resources.ProviderProps")
@software.amazon.jsii.Jsii.Proxy(ProviderProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ProviderProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The AWS Lambda function to invoke for all resource lifecycle operations (CREATE/UPDATE/DELETE).
     * <p>
     * This function is responsible to begin the requested resource operation
     * (CREATE/UPDATE/DELETE) and return any additional properties to add to the
     * event, which will later be passed to <code>isComplete</code>. The <code>PhysicalResourceId</code>
     * property must be included in the response.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.IFunction getOnEventHandler();

    /**
     * The AWS Lambda function to invoke in order to determine if the operation is complete.
     * <p>
     * This function will be called immediately after <code>onEvent</code> and then
     * periodically based on the configured query interval as long as it returns
     * <code>false</code>. If the function still returns <code>false</code> and the alloted timeout has
     * passed, the operation will fail.
     * <p>
     * Default: - provider is synchronous. This means that the `onEvent` handler
     * is expected to finish all lifecycle operations within the initial invocation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.lambda.IFunction getIsCompleteHandler() {
        return null;
    }

    /**
     * The number of days framework log events are kept in CloudWatch Logs.
     * <p>
     * When
     * updating this property, unsetting it doesn't remove the log retention policy.
     * To remove the retention policy, set the value to <code>INFINITE</code>.
     * <p>
     * Default: logs.RetentionDays.INFINITE
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.logs.RetentionDays getLogRetention() {
        return null;
    }

    /**
     * Time between calls to the `isComplete` handler which determines if the resource has been stabilized.
     * <p>
     * The first <code>isComplete</code> will be called immediately after <code>handler</code> and then
     * every <code>queryInterval</code> seconds, and until <code>timeout</code> has been reached or until
     * <code>isComplete</code> returns <code>true</code>.
     * <p>
     * Default: Duration.seconds(5)
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.Duration getQueryInterval() {
        return null;
    }

    /**
     * Total timeout for the entire operation.
     * <p>
     * The maximum timeout is 2 hours (yes, it can exceed the AWS Lambda 15 minutes)
     * <p>
     * Default: Duration.minutes(30)
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.Duration getTotalTimeout() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link ProviderProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ProviderProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ProviderProps> {
        private software.amazon.awscdk.services.lambda.IFunction onEventHandler;
        private software.amazon.awscdk.services.lambda.IFunction isCompleteHandler;
        private software.amazon.awscdk.services.logs.RetentionDays logRetention;
        private software.amazon.awscdk.core.Duration queryInterval;
        private software.amazon.awscdk.core.Duration totalTimeout;

        /**
         * Sets the value of {@link ProviderProps#getOnEventHandler}
         * @param onEventHandler The AWS Lambda function to invoke for all resource lifecycle operations (CREATE/UPDATE/DELETE). This parameter is required.
         *                       This function is responsible to begin the requested resource operation
         *                       (CREATE/UPDATE/DELETE) and return any additional properties to add to the
         *                       event, which will later be passed to <code>isComplete</code>. The <code>PhysicalResourceId</code>
         *                       property must be included in the response.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder onEventHandler(software.amazon.awscdk.services.lambda.IFunction onEventHandler) {
            this.onEventHandler = onEventHandler;
            return this;
        }

        /**
         * Sets the value of {@link ProviderProps#getIsCompleteHandler}
         * @param isCompleteHandler The AWS Lambda function to invoke in order to determine if the operation is complete.
         *                          This function will be called immediately after <code>onEvent</code> and then
         *                          periodically based on the configured query interval as long as it returns
         *                          <code>false</code>. If the function still returns <code>false</code> and the alloted timeout has
         *                          passed, the operation will fail.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder isCompleteHandler(software.amazon.awscdk.services.lambda.IFunction isCompleteHandler) {
            this.isCompleteHandler = isCompleteHandler;
            return this;
        }

        /**
         * Sets the value of {@link ProviderProps#getLogRetention}
         * @param logRetention The number of days framework log events are kept in CloudWatch Logs.
         *                     When
         *                     updating this property, unsetting it doesn't remove the log retention policy.
         *                     To remove the retention policy, set the value to <code>INFINITE</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logRetention(software.amazon.awscdk.services.logs.RetentionDays logRetention) {
            this.logRetention = logRetention;
            return this;
        }

        /**
         * Sets the value of {@link ProviderProps#getQueryInterval}
         * @param queryInterval Time between calls to the `isComplete` handler which determines if the resource has been stabilized.
         *                      The first <code>isComplete</code> will be called immediately after <code>handler</code> and then
         *                      every <code>queryInterval</code> seconds, and until <code>timeout</code> has been reached or until
         *                      <code>isComplete</code> returns <code>true</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder queryInterval(software.amazon.awscdk.core.Duration queryInterval) {
            this.queryInterval = queryInterval;
            return this;
        }

        /**
         * Sets the value of {@link ProviderProps#getTotalTimeout}
         * @param totalTimeout Total timeout for the entire operation.
         *                     The maximum timeout is 2 hours (yes, it can exceed the AWS Lambda 15 minutes)
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder totalTimeout(software.amazon.awscdk.core.Duration totalTimeout) {
            this.totalTimeout = totalTimeout;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ProviderProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ProviderProps build() {
            return new Jsii$Proxy(onEventHandler, isCompleteHandler, logRetention, queryInterval, totalTimeout);
        }
    }

    /**
     * An implementation for {@link ProviderProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ProviderProps {
        private final software.amazon.awscdk.services.lambda.IFunction onEventHandler;
        private final software.amazon.awscdk.services.lambda.IFunction isCompleteHandler;
        private final software.amazon.awscdk.services.logs.RetentionDays logRetention;
        private final software.amazon.awscdk.core.Duration queryInterval;
        private final software.amazon.awscdk.core.Duration totalTimeout;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.onEventHandler = this.jsiiGet("onEventHandler", software.amazon.awscdk.services.lambda.IFunction.class);
            this.isCompleteHandler = this.jsiiGet("isCompleteHandler", software.amazon.awscdk.services.lambda.IFunction.class);
            this.logRetention = this.jsiiGet("logRetention", software.amazon.awscdk.services.logs.RetentionDays.class);
            this.queryInterval = this.jsiiGet("queryInterval", software.amazon.awscdk.core.Duration.class);
            this.totalTimeout = this.jsiiGet("totalTimeout", software.amazon.awscdk.core.Duration.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final software.amazon.awscdk.services.lambda.IFunction onEventHandler, final software.amazon.awscdk.services.lambda.IFunction isCompleteHandler, final software.amazon.awscdk.services.logs.RetentionDays logRetention, final software.amazon.awscdk.core.Duration queryInterval, final software.amazon.awscdk.core.Duration totalTimeout) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.onEventHandler = java.util.Objects.requireNonNull(onEventHandler, "onEventHandler is required");
            this.isCompleteHandler = isCompleteHandler;
            this.logRetention = logRetention;
            this.queryInterval = queryInterval;
            this.totalTimeout = totalTimeout;
        }

        @Override
        public software.amazon.awscdk.services.lambda.IFunction getOnEventHandler() {
            return this.onEventHandler;
        }

        @Override
        public software.amazon.awscdk.services.lambda.IFunction getIsCompleteHandler() {
            return this.isCompleteHandler;
        }

        @Override
        public software.amazon.awscdk.services.logs.RetentionDays getLogRetention() {
            return this.logRetention;
        }

        @Override
        public software.amazon.awscdk.core.Duration getQueryInterval() {
            return this.queryInterval;
        }

        @Override
        public software.amazon.awscdk.core.Duration getTotalTimeout() {
            return this.totalTimeout;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("onEventHandler", om.valueToTree(this.getOnEventHandler()));
            if (this.getIsCompleteHandler() != null) {
                data.set("isCompleteHandler", om.valueToTree(this.getIsCompleteHandler()));
            }
            if (this.getLogRetention() != null) {
                data.set("logRetention", om.valueToTree(this.getLogRetention()));
            }
            if (this.getQueryInterval() != null) {
                data.set("queryInterval", om.valueToTree(this.getQueryInterval()));
            }
            if (this.getTotalTimeout() != null) {
                data.set("totalTimeout", om.valueToTree(this.getTotalTimeout()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/custom-resources.ProviderProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ProviderProps.Jsii$Proxy that = (ProviderProps.Jsii$Proxy) o;

            if (!onEventHandler.equals(that.onEventHandler)) return false;
            if (this.isCompleteHandler != null ? !this.isCompleteHandler.equals(that.isCompleteHandler) : that.isCompleteHandler != null) return false;
            if (this.logRetention != null ? !this.logRetention.equals(that.logRetention) : that.logRetention != null) return false;
            if (this.queryInterval != null ? !this.queryInterval.equals(that.queryInterval) : that.queryInterval != null) return false;
            return this.totalTimeout != null ? this.totalTimeout.equals(that.totalTimeout) : that.totalTimeout == null;
        }

        @Override
        public int hashCode() {
            int result = this.onEventHandler.hashCode();
            result = 31 * result + (this.isCompleteHandler != null ? this.isCompleteHandler.hashCode() : 0);
            result = 31 * result + (this.logRetention != null ? this.logRetention.hashCode() : 0);
            result = 31 * result + (this.queryInterval != null ? this.queryInterval.hashCode() : 0);
            result = 31 * result + (this.totalTimeout != null ? this.totalTimeout.hashCode() : 0);
            return result;
        }
    }
}
