package software.amazon.awscdk.customresources;

/**
 * An AWS SDK call.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.15.0 (build 585166b)", date = "2021-01-03T09:45:49.392Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.customresources.$Module.class, fqn = "@aws-cdk/custom-resources.AwsSdkCall")
@software.amazon.jsii.Jsii.Proxy(AwsSdkCall.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface AwsSdkCall extends software.amazon.jsii.JsiiSerializable {

    /**
     * The service action to call.
     * <p>
     * @see https://docs.aws.amazon.com/AWSJavaScriptSDK/latest/index.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getAction();

    /**
     * The service to call.
     * <p>
     * @see https://docs.aws.amazon.com/AWSJavaScriptSDK/latest/index.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getService();

    /**
     * API version to use for the service.
     * <p>
     * Default: - use latest available API version
     * <p>
     * @see https://docs.aws.amazon.com/sdk-for-javascript/v2/developer-guide/locking-api-versions.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getApiVersion() {
        return null;
    }

    /**
     * The regex pattern to use to catch API errors.
     * <p>
     * The <code>code</code> property of the
     * <code>Error</code> object will be tested against this pattern. If there is a match an
     * error will not be thrown.
     * <p>
     * Default: - do not catch errors
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getIgnoreErrorCodesMatching() {
        return null;
    }

    /**
     * Restrict the data returned by the custom resource to a specific path in the API response.
     * <p>
     * Use this to limit the data returned by the custom
     * resource if working with API calls that could potentially result in custom
     * response objects exceeding the hard limit of 4096 bytes.
     * <p>
     * Example for ECS / updateService: 'service.deploymentConfiguration.maximumPercent'
     * <p>
     * Default: - return all data
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getOutputPath() {
        return null;
    }

    /**
     * The parameters for the service action.
     * <p>
     * Default: - no parameters
     * <p>
     * @see https://docs.aws.amazon.com/AWSJavaScriptSDK/latest/index.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getParameters() {
        return null;
    }

    /**
     * The physical resource id of the custom resource for this call.
     * <p>
     * Mandatory for onCreate or onUpdate calls.
     * <p>
     * Default: - no physical resource id
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.customresources.PhysicalResourceId getPhysicalResourceId() {
        return null;
    }

    /**
     * The region to send service requests to.
     * <p>
     * <strong>Note: Cross-region operations are generally considered an anti-pattern.</strong>
     * <strong>Consider first deploying a stack in that region.</strong>
     * <p>
     * Default: - the region where this custom resource is deployed
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getRegion() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link AwsSdkCall}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link AwsSdkCall}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<AwsSdkCall> {
        private java.lang.String action;
        private java.lang.String service;
        private java.lang.String apiVersion;
        private java.lang.String ignoreErrorCodesMatching;
        private java.lang.String outputPath;
        private java.lang.Object parameters;
        private software.amazon.awscdk.customresources.PhysicalResourceId physicalResourceId;
        private java.lang.String region;

        /**
         * Sets the value of {@link AwsSdkCall#getAction}
         * @param action The service action to call. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder action(java.lang.String action) {
            this.action = action;
            return this;
        }

        /**
         * Sets the value of {@link AwsSdkCall#getService}
         * @param service The service to call. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder service(java.lang.String service) {
            this.service = service;
            return this;
        }

        /**
         * Sets the value of {@link AwsSdkCall#getApiVersion}
         * @param apiVersion API version to use for the service.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder apiVersion(java.lang.String apiVersion) {
            this.apiVersion = apiVersion;
            return this;
        }

        /**
         * Sets the value of {@link AwsSdkCall#getIgnoreErrorCodesMatching}
         * @param ignoreErrorCodesMatching The regex pattern to use to catch API errors.
         *                                 The <code>code</code> property of the
         *                                 <code>Error</code> object will be tested against this pattern. If there is a match an
         *                                 error will not be thrown.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ignoreErrorCodesMatching(java.lang.String ignoreErrorCodesMatching) {
            this.ignoreErrorCodesMatching = ignoreErrorCodesMatching;
            return this;
        }

        /**
         * Sets the value of {@link AwsSdkCall#getOutputPath}
         * @param outputPath Restrict the data returned by the custom resource to a specific path in the API response.
         *                   Use this to limit the data returned by the custom
         *                   resource if working with API calls that could potentially result in custom
         *                   response objects exceeding the hard limit of 4096 bytes.
         *                   <p>
         *                   Example for ECS / updateService: 'service.deploymentConfiguration.maximumPercent'
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder outputPath(java.lang.String outputPath) {
            this.outputPath = outputPath;
            return this;
        }

        /**
         * Sets the value of {@link AwsSdkCall#getParameters}
         * @param parameters The parameters for the service action.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder parameters(java.lang.Object parameters) {
            this.parameters = parameters;
            return this;
        }

        /**
         * Sets the value of {@link AwsSdkCall#getPhysicalResourceId}
         * @param physicalResourceId The physical resource id of the custom resource for this call.
         *                           Mandatory for onCreate or onUpdate calls.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder physicalResourceId(software.amazon.awscdk.customresources.PhysicalResourceId physicalResourceId) {
            this.physicalResourceId = physicalResourceId;
            return this;
        }

        /**
         * Sets the value of {@link AwsSdkCall#getRegion}
         * @param region The region to send service requests to.
         *               <strong>Note: Cross-region operations are generally considered an anti-pattern.</strong>
         *               <strong>Consider first deploying a stack in that region.</strong>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder region(java.lang.String region) {
            this.region = region;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link AwsSdkCall}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public AwsSdkCall build() {
            return new Jsii$Proxy(action, service, apiVersion, ignoreErrorCodesMatching, outputPath, parameters, physicalResourceId, region);
        }
    }

    /**
     * An implementation for {@link AwsSdkCall}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AwsSdkCall {
        private final java.lang.String action;
        private final java.lang.String service;
        private final java.lang.String apiVersion;
        private final java.lang.String ignoreErrorCodesMatching;
        private final java.lang.String outputPath;
        private final java.lang.Object parameters;
        private final software.amazon.awscdk.customresources.PhysicalResourceId physicalResourceId;
        private final java.lang.String region;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.action = software.amazon.jsii.Kernel.get(this, "action", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.service = software.amazon.jsii.Kernel.get(this, "service", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.apiVersion = software.amazon.jsii.Kernel.get(this, "apiVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.ignoreErrorCodesMatching = software.amazon.jsii.Kernel.get(this, "ignoreErrorCodesMatching", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.outputPath = software.amazon.jsii.Kernel.get(this, "outputPath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.parameters = software.amazon.jsii.Kernel.get(this, "parameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.physicalResourceId = software.amazon.jsii.Kernel.get(this, "physicalResourceId", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.customresources.PhysicalResourceId.class));
            this.region = software.amazon.jsii.Kernel.get(this, "region", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final java.lang.String action, final java.lang.String service, final java.lang.String apiVersion, final java.lang.String ignoreErrorCodesMatching, final java.lang.String outputPath, final java.lang.Object parameters, final software.amazon.awscdk.customresources.PhysicalResourceId physicalResourceId, final java.lang.String region) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.action = java.util.Objects.requireNonNull(action, "action is required");
            this.service = java.util.Objects.requireNonNull(service, "service is required");
            this.apiVersion = apiVersion;
            this.ignoreErrorCodesMatching = ignoreErrorCodesMatching;
            this.outputPath = outputPath;
            this.parameters = parameters;
            this.physicalResourceId = physicalResourceId;
            this.region = region;
        }

        @Override
        public final java.lang.String getAction() {
            return this.action;
        }

        @Override
        public final java.lang.String getService() {
            return this.service;
        }

        @Override
        public final java.lang.String getApiVersion() {
            return this.apiVersion;
        }

        @Override
        public final java.lang.String getIgnoreErrorCodesMatching() {
            return this.ignoreErrorCodesMatching;
        }

        @Override
        public final java.lang.String getOutputPath() {
            return this.outputPath;
        }

        @Override
        public final java.lang.Object getParameters() {
            return this.parameters;
        }

        @Override
        public final software.amazon.awscdk.customresources.PhysicalResourceId getPhysicalResourceId() {
            return this.physicalResourceId;
        }

        @Override
        public final java.lang.String getRegion() {
            return this.region;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("action", om.valueToTree(this.getAction()));
            data.set("service", om.valueToTree(this.getService()));
            if (this.getApiVersion() != null) {
                data.set("apiVersion", om.valueToTree(this.getApiVersion()));
            }
            if (this.getIgnoreErrorCodesMatching() != null) {
                data.set("ignoreErrorCodesMatching", om.valueToTree(this.getIgnoreErrorCodesMatching()));
            }
            if (this.getOutputPath() != null) {
                data.set("outputPath", om.valueToTree(this.getOutputPath()));
            }
            if (this.getParameters() != null) {
                data.set("parameters", om.valueToTree(this.getParameters()));
            }
            if (this.getPhysicalResourceId() != null) {
                data.set("physicalResourceId", om.valueToTree(this.getPhysicalResourceId()));
            }
            if (this.getRegion() != null) {
                data.set("region", om.valueToTree(this.getRegion()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/custom-resources.AwsSdkCall"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            AwsSdkCall.Jsii$Proxy that = (AwsSdkCall.Jsii$Proxy) o;

            if (!action.equals(that.action)) return false;
            if (!service.equals(that.service)) return false;
            if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) return false;
            if (this.ignoreErrorCodesMatching != null ? !this.ignoreErrorCodesMatching.equals(that.ignoreErrorCodesMatching) : that.ignoreErrorCodesMatching != null) return false;
            if (this.outputPath != null ? !this.outputPath.equals(that.outputPath) : that.outputPath != null) return false;
            if (this.parameters != null ? !this.parameters.equals(that.parameters) : that.parameters != null) return false;
            if (this.physicalResourceId != null ? !this.physicalResourceId.equals(that.physicalResourceId) : that.physicalResourceId != null) return false;
            return this.region != null ? this.region.equals(that.region) : that.region == null;
        }

        @Override
        public final int hashCode() {
            int result = this.action.hashCode();
            result = 31 * result + (this.service.hashCode());
            result = 31 * result + (this.apiVersion != null ? this.apiVersion.hashCode() : 0);
            result = 31 * result + (this.ignoreErrorCodesMatching != null ? this.ignoreErrorCodesMatching.hashCode() : 0);
            result = 31 * result + (this.outputPath != null ? this.outputPath.hashCode() : 0);
            result = 31 * result + (this.parameters != null ? this.parameters.hashCode() : 0);
            result = 31 * result + (this.physicalResourceId != null ? this.physicalResourceId.hashCode() : 0);
            result = 31 * result + (this.region != null ? this.region.hashCode() : 0);
            return result;
        }
    }
}
