package software.amazon.awscdk.cxapi;

/**
 * Models an AWS execution environment, for use within the CDK toolkit.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.7.8 (build 100f5ad)", date = "2018-11-06T21:11:20.661Z")
public interface Environment extends software.amazon.jsii.JsiiSerializable {
    /**
     * The 12-digit AWS account ID for the account this environment deploys into
     */
    java.lang.String getAccount();
    /**
     * The 12-digit AWS account ID for the account this environment deploys into
     */
    void setAccount(final java.lang.String value);
    /**
     * The arbitrary name of this environment (user-set, or at least user-meaningful)
     */
    java.lang.String getName();
    /**
     * The arbitrary name of this environment (user-set, or at least user-meaningful)
     */
    void setName(final java.lang.String value);
    /**
     * The AWS region name where this environment deploys into
     */
    java.lang.String getRegion();
    /**
     * The AWS region name where this environment deploys into
     */
    void setRegion(final java.lang.String value);

    /**
     * @return a {@link Builder} of {@link Environment}
     */
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link Environment}
     */
    final class Builder {
        private java.lang.String _account;
        private java.lang.String _name;
        private java.lang.String _region;

        /**
         * Sets the value of Account
         * @param value The 12-digit AWS account ID for the account this environment deploys into
         * @return {@code this}
         */
        public Builder withAccount(final java.lang.String value) {
            this._account = java.util.Objects.requireNonNull(value, "account is required");
            return this;
        }
        /**
         * Sets the value of Name
         * @param value The arbitrary name of this environment (user-set, or at least user-meaningful)
         * @return {@code this}
         */
        public Builder withName(final java.lang.String value) {
            this._name = java.util.Objects.requireNonNull(value, "name is required");
            return this;
        }
        /**
         * Sets the value of Region
         * @param value The AWS region name where this environment deploys into
         * @return {@code this}
         */
        public Builder withRegion(final java.lang.String value) {
            this._region = java.util.Objects.requireNonNull(value, "region is required");
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link Environment}
         * @throws NullPointerException if any required attribute was not provided
         */
        public Environment build() {
            return new Environment() {
                private java.lang.String $account = java.util.Objects.requireNonNull(_account, "account is required");
                private java.lang.String $name = java.util.Objects.requireNonNull(_name, "name is required");
                private java.lang.String $region = java.util.Objects.requireNonNull(_region, "region is required");

                @Override
                public java.lang.String getAccount() {
                    return this.$account;
                }

                @Override
                public void setAccount(final java.lang.String value) {
                    this.$account = java.util.Objects.requireNonNull(value, "account is required");
                }

                @Override
                public java.lang.String getName() {
                    return this.$name;
                }

                @Override
                public void setName(final java.lang.String value) {
                    this.$name = java.util.Objects.requireNonNull(value, "name is required");
                }

                @Override
                public java.lang.String getRegion() {
                    return this.$region;
                }

                @Override
                public void setRegion(final java.lang.String value) {
                    this.$region = java.util.Objects.requireNonNull(value, "region is required");
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.cxapi.Environment {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * The 12-digit AWS account ID for the account this environment deploys into
         */
        @Override
        public java.lang.String getAccount() {
            return this.jsiiGet("account", java.lang.String.class);
        }

        /**
         * The 12-digit AWS account ID for the account this environment deploys into
         */
        @Override
        public void setAccount(final java.lang.String value) {
            this.jsiiSet("account", java.util.Objects.requireNonNull(value, "account is required"));
        }

        /**
         * The arbitrary name of this environment (user-set, or at least user-meaningful)
         */
        @Override
        public java.lang.String getName() {
            return this.jsiiGet("name", java.lang.String.class);
        }

        /**
         * The arbitrary name of this environment (user-set, or at least user-meaningful)
         */
        @Override
        public void setName(final java.lang.String value) {
            this.jsiiSet("name", java.util.Objects.requireNonNull(value, "name is required"));
        }

        /**
         * The AWS region name where this environment deploys into
         */
        @Override
        public java.lang.String getRegion() {
            return this.jsiiGet("region", java.lang.String.class);
        }

        /**
         * The AWS region name where this environment deploys into
         */
        @Override
        public void setRegion(final java.lang.String value) {
            this.jsiiSet("region", java.util.Objects.requireNonNull(value, "region is required"));
        }
    }
}
