package software.amazon.awscdk.cxapi;

/**
 * Query input for looking up a VPC
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.7.14 (build 91853ce)", date = "2019-02-04T14:47:29.337Z")
public interface VpcContextQuery extends software.amazon.jsii.JsiiSerializable {
    /**
     * Filters to apply to the VPC
     * 
     * Filter parameters are the same as passed to DescribeVpcs.
     * @see https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeVpcs.html
     */
    java.util.Map<java.lang.String, java.lang.String> getFilter();
    /**
     * Filters to apply to the VPC
     * 
     * Filter parameters are the same as passed to DescribeVpcs.
     * @see https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeVpcs.html
     */
    void setFilter(final java.util.Map<java.lang.String, java.lang.String> value);
    /**
     * Query account
     */
    java.lang.String getAccount();
    /**
     * Query account
     */
    void setAccount(final java.lang.String value);
    /**
     * Query region
     */
    java.lang.String getRegion();
    /**
     * Query region
     */
    void setRegion(final java.lang.String value);

    /**
     * @return a {@link Builder} of {@link VpcContextQuery}
     */
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link VpcContextQuery}
     */
    final class Builder {
        private java.util.Map<java.lang.String, java.lang.String> _filter;
        @javax.annotation.Nullable
        private java.lang.String _account;
        @javax.annotation.Nullable
        private java.lang.String _region;

        /**
         * Sets the value of Filter
         * @param value Filters to apply to the VPC

Filter parameters are the same as passed to DescribeVpcs.
         * @return {@code this}
         */
        public Builder withFilter(final java.util.Map<java.lang.String, java.lang.String> value) {
            this._filter = java.util.Objects.requireNonNull(value, "filter is required");
            return this;
        }
        /**
         * Sets the value of Account
         * @param value Query account
         * @return {@code this}
         */
        public Builder withAccount(@javax.annotation.Nullable final java.lang.String value) {
            this._account = value;
            return this;
        }
        /**
         * Sets the value of Region
         * @param value Query region
         * @return {@code this}
         */
        public Builder withRegion(@javax.annotation.Nullable final java.lang.String value) {
            this._region = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link VpcContextQuery}
         * @throws NullPointerException if any required attribute was not provided
         */
        public VpcContextQuery build() {
            return new VpcContextQuery() {
                private java.util.Map<java.lang.String, java.lang.String> $filter = java.util.Objects.requireNonNull(_filter, "filter is required");
                @javax.annotation.Nullable
                private java.lang.String $account = _account;
                @javax.annotation.Nullable
                private java.lang.String $region = _region;

                @Override
                public java.util.Map<java.lang.String, java.lang.String> getFilter() {
                    return this.$filter;
                }

                @Override
                public void setFilter(final java.util.Map<java.lang.String, java.lang.String> value) {
                    this.$filter = java.util.Objects.requireNonNull(value, "filter is required");
                }

                @Override
                public java.lang.String getAccount() {
                    return this.$account;
                }

                @Override
                public void setAccount(@javax.annotation.Nullable final java.lang.String value) {
                    this.$account = value;
                }

                @Override
                public java.lang.String getRegion() {
                    return this.$region;
                }

                @Override
                public void setRegion(@javax.annotation.Nullable final java.lang.String value) {
                    this.$region = value;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.cxapi.VpcContextQuery {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * Filters to apply to the VPC
         * 
         * Filter parameters are the same as passed to DescribeVpcs.
         * @see https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeVpcs.html
         */
        @Override
        public java.util.Map<java.lang.String, java.lang.String> getFilter() {
            return this.jsiiGet("filter", java.util.Map.class);
        }

        /**
         * Filters to apply to the VPC
         * 
         * Filter parameters are the same as passed to DescribeVpcs.
         * @see https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeVpcs.html
         */
        @Override
        public void setFilter(final java.util.Map<java.lang.String, java.lang.String> value) {
            this.jsiiSet("filter", java.util.Objects.requireNonNull(value, "filter is required"));
        }

        /**
         * Query account
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.String getAccount() {
            return this.jsiiGet("account", java.lang.String.class);
        }

        /**
         * Query account
         */
        @Override
        public void setAccount(@javax.annotation.Nullable final java.lang.String value) {
            this.jsiiSet("account", value);
        }

        /**
         * Query region
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.String getRegion() {
            return this.jsiiGet("region", java.lang.String.class);
        }

        /**
         * Query region
         */
        @Override
        public void setRegion(@javax.annotation.Nullable final java.lang.String value) {
            this.jsiiSet("region", value);
        }
    }
}
