package software.amazon.awscdk.cxapi;

@javax.annotation.Generated(value = "jsii-pacmak/0.8.2 (build e9eb3c9)", date = "2019-03-28T21:30:07.023Z")
public interface FileAssetMetadataEntry extends software.amazon.jsii.JsiiSerializable {
    /**
     * Logical identifier for the asset
     */
    java.lang.String getId();
    /**
     * Requested packaging style
     */
    java.lang.String getPackaging();
    /**
     * Path on disk to the asset
     */
    java.lang.String getPath();
    /**
     * Name of parameter where S3 bucket should be passed in
     */
    java.lang.String getS3BucketParameter();
    /**
     * Name of parameter where S3 key should be passed in
     */
    java.lang.String getS3KeyParameter();

    /**
     * @return a {@link Builder} of {@link FileAssetMetadataEntry}
     */
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link FileAssetMetadataEntry}
     */
    final class Builder {
        private java.lang.String _id;
        private java.lang.String _packaging;
        private java.lang.String _path;
        private java.lang.String _s3BucketParameter;
        private java.lang.String _s3KeyParameter;

        /**
         * Sets the value of Id
         * @param value Logical identifier for the asset
         * @return {@code this}
         */
        public Builder withId(final java.lang.String value) {
            this._id = java.util.Objects.requireNonNull(value, "id is required");
            return this;
        }
        /**
         * Sets the value of Packaging
         * @param value Requested packaging style
         * @return {@code this}
         */
        public Builder withPackaging(final java.lang.String value) {
            this._packaging = java.util.Objects.requireNonNull(value, "packaging is required");
            return this;
        }
        /**
         * Sets the value of Path
         * @param value Path on disk to the asset
         * @return {@code this}
         */
        public Builder withPath(final java.lang.String value) {
            this._path = java.util.Objects.requireNonNull(value, "path is required");
            return this;
        }
        /**
         * Sets the value of S3BucketParameter
         * @param value Name of parameter where S3 bucket should be passed in
         * @return {@code this}
         */
        public Builder withS3BucketParameter(final java.lang.String value) {
            this._s3BucketParameter = java.util.Objects.requireNonNull(value, "s3BucketParameter is required");
            return this;
        }
        /**
         * Sets the value of S3KeyParameter
         * @param value Name of parameter where S3 key should be passed in
         * @return {@code this}
         */
        public Builder withS3KeyParameter(final java.lang.String value) {
            this._s3KeyParameter = java.util.Objects.requireNonNull(value, "s3KeyParameter is required");
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link FileAssetMetadataEntry}
         * @throws NullPointerException if any required attribute was not provided
         */
        public FileAssetMetadataEntry build() {
            return new FileAssetMetadataEntry() {
                private final java.lang.String $id = java.util.Objects.requireNonNull(_id, "id is required");
                private final java.lang.String $packaging = java.util.Objects.requireNonNull(_packaging, "packaging is required");
                private final java.lang.String $path = java.util.Objects.requireNonNull(_path, "path is required");
                private final java.lang.String $s3BucketParameter = java.util.Objects.requireNonNull(_s3BucketParameter, "s3BucketParameter is required");
                private final java.lang.String $s3KeyParameter = java.util.Objects.requireNonNull(_s3KeyParameter, "s3KeyParameter is required");

                @Override
                public java.lang.String getId() {
                    return this.$id;
                }

                @Override
                public java.lang.String getPackaging() {
                    return this.$packaging;
                }

                @Override
                public java.lang.String getPath() {
                    return this.$path;
                }

                @Override
                public java.lang.String getS3BucketParameter() {
                    return this.$s3BucketParameter;
                }

                @Override
                public java.lang.String getS3KeyParameter() {
                    return this.$s3KeyParameter;
                }

                public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                    com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                    com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                    obj.set("id", om.valueToTree(this.getId()));
                    obj.set("packaging", om.valueToTree(this.getPackaging()));
                    obj.set("path", om.valueToTree(this.getPath()));
                    obj.set("s3BucketParameter", om.valueToTree(this.getS3BucketParameter()));
                    obj.set("s3KeyParameter", om.valueToTree(this.getS3KeyParameter()));
                    return obj;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.cxapi.FileAssetMetadataEntry {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * Logical identifier for the asset
         */
        @Override
        public java.lang.String getId() {
            return this.jsiiGet("id", java.lang.String.class);
        }

        /**
         * Requested packaging style
         */
        @Override
        public java.lang.String getPackaging() {
            return this.jsiiGet("packaging", java.lang.String.class);
        }

        /**
         * Path on disk to the asset
         */
        @Override
        public java.lang.String getPath() {
            return this.jsiiGet("path", java.lang.String.class);
        }

        /**
         * Name of parameter where S3 bucket should be passed in
         */
        @Override
        public java.lang.String getS3BucketParameter() {
            return this.jsiiGet("s3BucketParameter", java.lang.String.class);
        }

        /**
         * Name of parameter where S3 key should be passed in
         */
        @Override
        public java.lang.String getS3KeyParameter() {
            return this.jsiiGet("s3KeyParameter", java.lang.String.class);
        }
    }
}
