package software.amazon.awscdk.cxapi;

@javax.annotation.Generated(value = "jsii-pacmak/0.8.2 (build e9eb3c9)", date = "2019-04-04T14:59:57.906Z")
public interface ContainerImageAssetMetadataEntry extends software.amazon.jsii.JsiiSerializable {
    /**
     * Logical identifier for the asset
     */
    java.lang.String getId();
    /**
     * ECR Repository name and tag (separated by ":") where this asset is stored.
     */
    java.lang.String getImageNameParameter();
    /**
     * Type of asset
     */
    java.lang.String getPackaging();
    /**
     * Path on disk to the asset
     */
    java.lang.String getPath();
    /**
     * ECR repository name, if omitted a default name based on the asset's
     * ID is used instead. Specify this property if you need to statically
     * address the image, e.g. from a Kubernetes Pod.
     * Note, this is only the repository name, without the registry and
     * the tag parts.
     * 
     * * @default automatically derived from the asset's ID.
     */
    java.lang.String getRepositoryName();

    /**
     * @return a {@link Builder} of {@link ContainerImageAssetMetadataEntry}
     */
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link ContainerImageAssetMetadataEntry}
     */
    final class Builder {
        private java.lang.String _id;
        private java.lang.String _imageNameParameter;
        private java.lang.String _packaging;
        private java.lang.String _path;
        @javax.annotation.Nullable
        private java.lang.String _repositoryName;

        /**
         * Sets the value of Id
         * @param value Logical identifier for the asset
         * @return {@code this}
         */
        public Builder withId(final java.lang.String value) {
            this._id = java.util.Objects.requireNonNull(value, "id is required");
            return this;
        }
        /**
         * Sets the value of ImageNameParameter
         * @param value ECR Repository name and tag (separated by ":") where this asset is stored.
         * @return {@code this}
         */
        public Builder withImageNameParameter(final java.lang.String value) {
            this._imageNameParameter = java.util.Objects.requireNonNull(value, "imageNameParameter is required");
            return this;
        }
        /**
         * Sets the value of Packaging
         * @param value Type of asset
         * @return {@code this}
         */
        public Builder withPackaging(final java.lang.String value) {
            this._packaging = java.util.Objects.requireNonNull(value, "packaging is required");
            return this;
        }
        /**
         * Sets the value of Path
         * @param value Path on disk to the asset
         * @return {@code this}
         */
        public Builder withPath(final java.lang.String value) {
            this._path = java.util.Objects.requireNonNull(value, "path is required");
            return this;
        }
        /**
         * Sets the value of RepositoryName
         * @param value ECR repository name, if omitted a default name based on the asset's
ID is used instead. Specify this property if you need to statically
address the image, e.g. from a Kubernetes Pod.
Note, this is only the repository name, without the registry and
the tag parts.

* @default automatically derived from the asset's ID.
         * @return {@code this}
         */
        public Builder withRepositoryName(@javax.annotation.Nullable final java.lang.String value) {
            this._repositoryName = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ContainerImageAssetMetadataEntry}
         * @throws NullPointerException if any required attribute was not provided
         */
        public ContainerImageAssetMetadataEntry build() {
            return new ContainerImageAssetMetadataEntry() {
                private final java.lang.String $id = java.util.Objects.requireNonNull(_id, "id is required");
                private final java.lang.String $imageNameParameter = java.util.Objects.requireNonNull(_imageNameParameter, "imageNameParameter is required");
                private final java.lang.String $packaging = java.util.Objects.requireNonNull(_packaging, "packaging is required");
                private final java.lang.String $path = java.util.Objects.requireNonNull(_path, "path is required");
                @javax.annotation.Nullable
                private final java.lang.String $repositoryName = _repositoryName;

                @Override
                public java.lang.String getId() {
                    return this.$id;
                }

                @Override
                public java.lang.String getImageNameParameter() {
                    return this.$imageNameParameter;
                }

                @Override
                public java.lang.String getPackaging() {
                    return this.$packaging;
                }

                @Override
                public java.lang.String getPath() {
                    return this.$path;
                }

                @Override
                public java.lang.String getRepositoryName() {
                    return this.$repositoryName;
                }

                public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                    com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                    com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                    obj.set("id", om.valueToTree(this.getId()));
                    obj.set("imageNameParameter", om.valueToTree(this.getImageNameParameter()));
                    obj.set("packaging", om.valueToTree(this.getPackaging()));
                    obj.set("path", om.valueToTree(this.getPath()));
                    obj.set("repositoryName", om.valueToTree(this.getRepositoryName()));
                    return obj;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.cxapi.ContainerImageAssetMetadataEntry {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * Logical identifier for the asset
         */
        @Override
        public java.lang.String getId() {
            return this.jsiiGet("id", java.lang.String.class);
        }

        /**
         * ECR Repository name and tag (separated by ":") where this asset is stored.
         */
        @Override
        public java.lang.String getImageNameParameter() {
            return this.jsiiGet("imageNameParameter", java.lang.String.class);
        }

        /**
         * Type of asset
         */
        @Override
        public java.lang.String getPackaging() {
            return this.jsiiGet("packaging", java.lang.String.class);
        }

        /**
         * Path on disk to the asset
         */
        @Override
        public java.lang.String getPath() {
            return this.jsiiGet("path", java.lang.String.class);
        }

        /**
         * ECR repository name, if omitted a default name based on the asset's
         * ID is used instead. Specify this property if you need to statically
         * address the image, e.g. from a Kubernetes Pod.
         * Note, this is only the repository name, without the registry and
         * the tag parts.
         * 
         * * @default automatically derived from the asset's ID.
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.String getRepositoryName() {
            return this.jsiiGet("repositoryName", java.lang.String.class);
        }
    }
}
