package software.amazon.awscdk.cxapi;

/**
 * Query to hosted zone context provider
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.8.2 (build e9eb3c9)", date = "2019-04-04T14:59:57.908Z")
public interface HostedZoneContextQuery extends software.amazon.jsii.JsiiSerializable {
    /**
     * The domain name e.g. example.com to lookup
     */
    java.lang.String getDomainName();
    /**
     * Query account
     */
    java.lang.String getAccount();
    /**
     * True if the zone you want to find is a private hosted zone
     */
    java.lang.Boolean getPrivateZone();
    /**
     * Query region
     */
    java.lang.String getRegion();
    /**
     * The VPC ID to that the private zone must be associated with
     * 
     * If you provide VPC ID and privateZone is false, this will return no results
     * and raise an error.
     */
    java.lang.String getVpcId();

    /**
     * @return a {@link Builder} of {@link HostedZoneContextQuery}
     */
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link HostedZoneContextQuery}
     */
    final class Builder {
        private java.lang.String _domainName;
        @javax.annotation.Nullable
        private java.lang.String _account;
        @javax.annotation.Nullable
        private java.lang.Boolean _privateZone;
        @javax.annotation.Nullable
        private java.lang.String _region;
        @javax.annotation.Nullable
        private java.lang.String _vpcId;

        /**
         * Sets the value of DomainName
         * @param value The domain name e.g. example.com to lookup
         * @return {@code this}
         */
        public Builder withDomainName(final java.lang.String value) {
            this._domainName = java.util.Objects.requireNonNull(value, "domainName is required");
            return this;
        }
        /**
         * Sets the value of Account
         * @param value Query account
         * @return {@code this}
         */
        public Builder withAccount(@javax.annotation.Nullable final java.lang.String value) {
            this._account = value;
            return this;
        }
        /**
         * Sets the value of PrivateZone
         * @param value True if the zone you want to find is a private hosted zone
         * @return {@code this}
         */
        public Builder withPrivateZone(@javax.annotation.Nullable final java.lang.Boolean value) {
            this._privateZone = value;
            return this;
        }
        /**
         * Sets the value of Region
         * @param value Query region
         * @return {@code this}
         */
        public Builder withRegion(@javax.annotation.Nullable final java.lang.String value) {
            this._region = value;
            return this;
        }
        /**
         * Sets the value of VpcId
         * @param value The VPC ID to that the private zone must be associated with

If you provide VPC ID and privateZone is false, this will return no results
and raise an error.
         * @return {@code this}
         */
        public Builder withVpcId(@javax.annotation.Nullable final java.lang.String value) {
            this._vpcId = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link HostedZoneContextQuery}
         * @throws NullPointerException if any required attribute was not provided
         */
        public HostedZoneContextQuery build() {
            return new HostedZoneContextQuery() {
                private final java.lang.String $domainName = java.util.Objects.requireNonNull(_domainName, "domainName is required");
                @javax.annotation.Nullable
                private final java.lang.String $account = _account;
                @javax.annotation.Nullable
                private final java.lang.Boolean $privateZone = _privateZone;
                @javax.annotation.Nullable
                private final java.lang.String $region = _region;
                @javax.annotation.Nullable
                private final java.lang.String $vpcId = _vpcId;

                @Override
                public java.lang.String getDomainName() {
                    return this.$domainName;
                }

                @Override
                public java.lang.String getAccount() {
                    return this.$account;
                }

                @Override
                public java.lang.Boolean getPrivateZone() {
                    return this.$privateZone;
                }

                @Override
                public java.lang.String getRegion() {
                    return this.$region;
                }

                @Override
                public java.lang.String getVpcId() {
                    return this.$vpcId;
                }

                public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                    com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                    com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                    obj.set("domainName", om.valueToTree(this.getDomainName()));
                    obj.set("account", om.valueToTree(this.getAccount()));
                    obj.set("privateZone", om.valueToTree(this.getPrivateZone()));
                    obj.set("region", om.valueToTree(this.getRegion()));
                    obj.set("vpcId", om.valueToTree(this.getVpcId()));
                    return obj;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.cxapi.HostedZoneContextQuery {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * The domain name e.g. example.com to lookup
         */
        @Override
        public java.lang.String getDomainName() {
            return this.jsiiGet("domainName", java.lang.String.class);
        }

        /**
         * Query account
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.String getAccount() {
            return this.jsiiGet("account", java.lang.String.class);
        }

        /**
         * True if the zone you want to find is a private hosted zone
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.Boolean getPrivateZone() {
            return this.jsiiGet("privateZone", java.lang.Boolean.class);
        }

        /**
         * Query region
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.String getRegion() {
            return this.jsiiGet("region", java.lang.String.class);
        }

        /**
         * The VPC ID to that the private zone must be associated with
         * 
         * If you provide VPC ID and privateZone is false, this will return no results
         * and raise an error.
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.String getVpcId() {
            return this.jsiiGet("vpcId", java.lang.String.class);
        }
    }
}
