package software.amazon.awscdk.cxapi;

/**
 * Properties of a discovered VPC.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.10.3 (build 6bbf743)", date = "2019-05-02T10:06:46.838Z")
public interface VpcContextResponse extends software.amazon.jsii.JsiiSerializable {
    /**
     * AZs.
     */
    java.util.List<java.lang.String> getAvailabilityZones();
    /**
     * VPC id.
     */
    java.lang.String getVpcId();
    /**
     * IDs of all isolated subnets.
     * 
     * Element count: #(availabilityZones) · #(isolatedGroups)
     */
    java.util.List<java.lang.String> getIsolatedSubnetIds();
    /**
     * Name of isolated subnet groups.
     * 
     * Element count: #(isolatedGroups)
     */
    java.util.List<java.lang.String> getIsolatedSubnetNames();
    /**
     * IDs of all private subnets.
     * 
     * Element count: #(availabilityZones) · #(privateGroups)
     */
    java.util.List<java.lang.String> getPrivateSubnetIds();
    /**
     * Name of private subnet groups.
     * 
     * Element count: #(privateGroups)
     */
    java.util.List<java.lang.String> getPrivateSubnetNames();
    /**
     * IDs of all public subnets.
     * 
     * Element count: #(availabilityZones) · #(publicGroups)
     */
    java.util.List<java.lang.String> getPublicSubnetIds();
    /**
     * Name of public subnet groups.
     * 
     * Element count: #(publicGroups)
     */
    java.util.List<java.lang.String> getPublicSubnetNames();
    /**
     * The VPN gateway ID.
     */
    java.lang.String getVpnGatewayId();

    /**
     * @return a {@link Builder} of {@link VpcContextResponse}
     */
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link VpcContextResponse}
     */
    final class Builder {
        private java.util.List<java.lang.String> _availabilityZones;
        private java.lang.String _vpcId;
        @javax.annotation.Nullable
        private java.util.List<java.lang.String> _isolatedSubnetIds;
        @javax.annotation.Nullable
        private java.util.List<java.lang.String> _isolatedSubnetNames;
        @javax.annotation.Nullable
        private java.util.List<java.lang.String> _privateSubnetIds;
        @javax.annotation.Nullable
        private java.util.List<java.lang.String> _privateSubnetNames;
        @javax.annotation.Nullable
        private java.util.List<java.lang.String> _publicSubnetIds;
        @javax.annotation.Nullable
        private java.util.List<java.lang.String> _publicSubnetNames;
        @javax.annotation.Nullable
        private java.lang.String _vpnGatewayId;

        /**
         * Sets the value of AvailabilityZones
         * @param value AZs.
         * @return {@code this}
         */
        public Builder withAvailabilityZones(final java.util.List<java.lang.String> value) {
            this._availabilityZones = java.util.Objects.requireNonNull(value, "availabilityZones is required");
            return this;
        }
        /**
         * Sets the value of VpcId
         * @param value VPC id.
         * @return {@code this}
         */
        public Builder withVpcId(final java.lang.String value) {
            this._vpcId = java.util.Objects.requireNonNull(value, "vpcId is required");
            return this;
        }
        /**
         * Sets the value of IsolatedSubnetIds
         * @param value IDs of all isolated subnets.
         * @return {@code this}
         */
        public Builder withIsolatedSubnetIds(@javax.annotation.Nullable final java.util.List<java.lang.String> value) {
            this._isolatedSubnetIds = value;
            return this;
        }
        /**
         * Sets the value of IsolatedSubnetNames
         * @param value Name of isolated subnet groups.
         * @return {@code this}
         */
        public Builder withIsolatedSubnetNames(@javax.annotation.Nullable final java.util.List<java.lang.String> value) {
            this._isolatedSubnetNames = value;
            return this;
        }
        /**
         * Sets the value of PrivateSubnetIds
         * @param value IDs of all private subnets.
         * @return {@code this}
         */
        public Builder withPrivateSubnetIds(@javax.annotation.Nullable final java.util.List<java.lang.String> value) {
            this._privateSubnetIds = value;
            return this;
        }
        /**
         * Sets the value of PrivateSubnetNames
         * @param value Name of private subnet groups.
         * @return {@code this}
         */
        public Builder withPrivateSubnetNames(@javax.annotation.Nullable final java.util.List<java.lang.String> value) {
            this._privateSubnetNames = value;
            return this;
        }
        /**
         * Sets the value of PublicSubnetIds
         * @param value IDs of all public subnets.
         * @return {@code this}
         */
        public Builder withPublicSubnetIds(@javax.annotation.Nullable final java.util.List<java.lang.String> value) {
            this._publicSubnetIds = value;
            return this;
        }
        /**
         * Sets the value of PublicSubnetNames
         * @param value Name of public subnet groups.
         * @return {@code this}
         */
        public Builder withPublicSubnetNames(@javax.annotation.Nullable final java.util.List<java.lang.String> value) {
            this._publicSubnetNames = value;
            return this;
        }
        /**
         * Sets the value of VpnGatewayId
         * @param value The VPN gateway ID.
         * @return {@code this}
         */
        public Builder withVpnGatewayId(@javax.annotation.Nullable final java.lang.String value) {
            this._vpnGatewayId = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link VpcContextResponse}
         * @throws NullPointerException if any required attribute was not provided
         */
        public VpcContextResponse build() {
            return new VpcContextResponse() {
                private final java.util.List<java.lang.String> $availabilityZones = java.util.Objects.requireNonNull(_availabilityZones, "availabilityZones is required");
                private final java.lang.String $vpcId = java.util.Objects.requireNonNull(_vpcId, "vpcId is required");
                @javax.annotation.Nullable
                private final java.util.List<java.lang.String> $isolatedSubnetIds = _isolatedSubnetIds;
                @javax.annotation.Nullable
                private final java.util.List<java.lang.String> $isolatedSubnetNames = _isolatedSubnetNames;
                @javax.annotation.Nullable
                private final java.util.List<java.lang.String> $privateSubnetIds = _privateSubnetIds;
                @javax.annotation.Nullable
                private final java.util.List<java.lang.String> $privateSubnetNames = _privateSubnetNames;
                @javax.annotation.Nullable
                private final java.util.List<java.lang.String> $publicSubnetIds = _publicSubnetIds;
                @javax.annotation.Nullable
                private final java.util.List<java.lang.String> $publicSubnetNames = _publicSubnetNames;
                @javax.annotation.Nullable
                private final java.lang.String $vpnGatewayId = _vpnGatewayId;

                @Override
                public java.util.List<java.lang.String> getAvailabilityZones() {
                    return this.$availabilityZones;
                }

                @Override
                public java.lang.String getVpcId() {
                    return this.$vpcId;
                }

                @Override
                public java.util.List<java.lang.String> getIsolatedSubnetIds() {
                    return this.$isolatedSubnetIds;
                }

                @Override
                public java.util.List<java.lang.String> getIsolatedSubnetNames() {
                    return this.$isolatedSubnetNames;
                }

                @Override
                public java.util.List<java.lang.String> getPrivateSubnetIds() {
                    return this.$privateSubnetIds;
                }

                @Override
                public java.util.List<java.lang.String> getPrivateSubnetNames() {
                    return this.$privateSubnetNames;
                }

                @Override
                public java.util.List<java.lang.String> getPublicSubnetIds() {
                    return this.$publicSubnetIds;
                }

                @Override
                public java.util.List<java.lang.String> getPublicSubnetNames() {
                    return this.$publicSubnetNames;
                }

                @Override
                public java.lang.String getVpnGatewayId() {
                    return this.$vpnGatewayId;
                }

                public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                    com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                    com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                    obj.set("availabilityZones", om.valueToTree(this.getAvailabilityZones()));
                    obj.set("vpcId", om.valueToTree(this.getVpcId()));
                    obj.set("isolatedSubnetIds", om.valueToTree(this.getIsolatedSubnetIds()));
                    obj.set("isolatedSubnetNames", om.valueToTree(this.getIsolatedSubnetNames()));
                    obj.set("privateSubnetIds", om.valueToTree(this.getPrivateSubnetIds()));
                    obj.set("privateSubnetNames", om.valueToTree(this.getPrivateSubnetNames()));
                    obj.set("publicSubnetIds", om.valueToTree(this.getPublicSubnetIds()));
                    obj.set("publicSubnetNames", om.valueToTree(this.getPublicSubnetNames()));
                    obj.set("vpnGatewayId", om.valueToTree(this.getVpnGatewayId()));
                    return obj;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.cxapi.VpcContextResponse {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * AZs.
         */
        @Override
        public java.util.List<java.lang.String> getAvailabilityZones() {
            return this.jsiiGet("availabilityZones", java.util.List.class);
        }

        /**
         * VPC id.
         */
        @Override
        public java.lang.String getVpcId() {
            return this.jsiiGet("vpcId", java.lang.String.class);
        }

        /**
         * IDs of all isolated subnets.
         * 
         * Element count: #(availabilityZones) · #(isolatedGroups)
         */
        @Override
        @javax.annotation.Nullable
        public java.util.List<java.lang.String> getIsolatedSubnetIds() {
            return this.jsiiGet("isolatedSubnetIds", java.util.List.class);
        }

        /**
         * Name of isolated subnet groups.
         * 
         * Element count: #(isolatedGroups)
         */
        @Override
        @javax.annotation.Nullable
        public java.util.List<java.lang.String> getIsolatedSubnetNames() {
            return this.jsiiGet("isolatedSubnetNames", java.util.List.class);
        }

        /**
         * IDs of all private subnets.
         * 
         * Element count: #(availabilityZones) · #(privateGroups)
         */
        @Override
        @javax.annotation.Nullable
        public java.util.List<java.lang.String> getPrivateSubnetIds() {
            return this.jsiiGet("privateSubnetIds", java.util.List.class);
        }

        /**
         * Name of private subnet groups.
         * 
         * Element count: #(privateGroups)
         */
        @Override
        @javax.annotation.Nullable
        public java.util.List<java.lang.String> getPrivateSubnetNames() {
            return this.jsiiGet("privateSubnetNames", java.util.List.class);
        }

        /**
         * IDs of all public subnets.
         * 
         * Element count: #(availabilityZones) · #(publicGroups)
         */
        @Override
        @javax.annotation.Nullable
        public java.util.List<java.lang.String> getPublicSubnetIds() {
            return this.jsiiGet("publicSubnetIds", java.util.List.class);
        }

        /**
         * Name of public subnet groups.
         * 
         * Element count: #(publicGroups)
         */
        @Override
        @javax.annotation.Nullable
        public java.util.List<java.lang.String> getPublicSubnetNames() {
            return this.jsiiGet("publicSubnetNames", java.util.List.class);
        }

        /**
         * The VPN gateway ID.
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.String getVpnGatewayId() {
            return this.jsiiGet("vpnGatewayId", java.lang.String.class);
        }
    }
}
