/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.cxapi;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import software.amazon.awscdk.cxapi.Environment;
import software.amazon.awscdk.cxapi.MetadataEntry;
import software.amazon.awscdk.cxapi.MissingContext;
import software.amazon.jsii.JsiiObjectMapper;
import software.amazon.jsii.JsiiSerializable;

public interface SynthesizedStack
extends JsiiSerializable {
    public Environment getEnvironment();

    public Map<String, List<MetadataEntry>> getMetadata();

    public String getName();

    public Object getTemplate();

    public Boolean getAutoDeploy();

    public List<String> getDependsOn();

    public Map<String, MissingContext> getMissing();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Environment _environment;
        private Map<String, List<MetadataEntry>> _metadata;
        private String _name;
        private Object _template;
        @Nullable
        private Boolean _autoDeploy;
        @Nullable
        private List<String> _dependsOn;
        @Nullable
        private Map<String, MissingContext> _missing;

        public Builder withEnvironment(Environment value) {
            this._environment = Objects.requireNonNull(value, "environment is required");
            return this;
        }

        public Builder withMetadata(Map<String, List<MetadataEntry>> value) {
            this._metadata = Objects.requireNonNull(value, "metadata is required");
            return this;
        }

        public Builder withName(String value) {
            this._name = Objects.requireNonNull(value, "name is required");
            return this;
        }

        public Builder withTemplate(Object value) {
            this._template = Objects.requireNonNull(value, "template is required");
            return this;
        }

        public Builder withAutoDeploy(@Nullable Boolean value) {
            this._autoDeploy = value;
            return this;
        }

        public Builder withDependsOn(@Nullable List<String> value) {
            this._dependsOn = value;
            return this;
        }

        public Builder withMissing(@Nullable Map<String, MissingContext> value) {
            this._missing = value;
            return this;
        }

        public SynthesizedStack build() {
            return new SynthesizedStack(){
                private final Environment $environment;
                private final Map<String, List<MetadataEntry>> $metadata;
                private final String $name;
                private final Object $template;
                @Nullable
                private final Boolean $autoDeploy;
                @Nullable
                private final List<String> $dependsOn;
                @Nullable
                private final Map<String, MissingContext> $missing;
                {
                    this.$environment = Objects.requireNonNull(_environment, "environment is required");
                    this.$metadata = Objects.requireNonNull(_metadata, "metadata is required");
                    this.$name = Objects.requireNonNull(_name, "name is required");
                    this.$template = Objects.requireNonNull(_template, "template is required");
                    this.$autoDeploy = _autoDeploy;
                    this.$dependsOn = _dependsOn;
                    this.$missing = _missing;
                }

                @Override
                public Environment getEnvironment() {
                    return this.$environment;
                }

                @Override
                public Map<String, List<MetadataEntry>> getMetadata() {
                    return this.$metadata;
                }

                @Override
                public String getName() {
                    return this.$name;
                }

                @Override
                public Object getTemplate() {
                    return this.$template;
                }

                @Override
                public Boolean getAutoDeploy() {
                    return this.$autoDeploy;
                }

                @Override
                public List<String> getDependsOn() {
                    return this.$dependsOn;
                }

                @Override
                public Map<String, MissingContext> getMissing() {
                    return this.$missing;
                }

                public JsonNode $jsii$toJson() {
                    ObjectMapper om = JsiiObjectMapper.INSTANCE;
                    ObjectNode obj = JsonNodeFactory.instance.objectNode();
                    obj.set("environment", om.valueToTree((Object)this.getEnvironment()));
                    obj.set("metadata", om.valueToTree(this.getMetadata()));
                    obj.set("name", om.valueToTree((Object)this.getName()));
                    obj.set("template", om.valueToTree(this.getTemplate()));
                    obj.set("autoDeploy", om.valueToTree((Object)this.getAutoDeploy()));
                    obj.set("dependsOn", om.valueToTree(this.getDependsOn()));
                    obj.set("missing", om.valueToTree(this.getMissing()));
                    return obj;
                }
            };
        }
    }
}

