/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.cxapi;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import software.amazon.awscdk.cxapi.ArtifactType;
import software.amazon.jsii.JsiiObjectMapper;
import software.amazon.jsii.JsiiSerializable;

public interface Artifact
extends JsiiSerializable {
    public String getEnvironment();

    public ArtifactType getType();

    public Boolean getAutoDeploy();

    public List<String> getDependencies();

    public Map<String, Object> getMetadata();

    public Map<String, Object> getMissing();

    public Map<String, Object> getProperties();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String _environment;
        private ArtifactType _type;
        @Nullable
        private Boolean _autoDeploy;
        @Nullable
        private List<String> _dependencies;
        @Nullable
        private Map<String, Object> _metadata;
        @Nullable
        private Map<String, Object> _missing;
        @Nullable
        private Map<String, Object> _properties;

        public Builder withEnvironment(String value) {
            this._environment = Objects.requireNonNull(value, "environment is required");
            return this;
        }

        public Builder withType(ArtifactType value) {
            this._type = Objects.requireNonNull(value, "type is required");
            return this;
        }

        public Builder withAutoDeploy(@Nullable Boolean value) {
            this._autoDeploy = value;
            return this;
        }

        public Builder withDependencies(@Nullable List<String> value) {
            this._dependencies = value;
            return this;
        }

        public Builder withMetadata(@Nullable Map<String, Object> value) {
            this._metadata = value;
            return this;
        }

        public Builder withMissing(@Nullable Map<String, Object> value) {
            this._missing = value;
            return this;
        }

        public Builder withProperties(@Nullable Map<String, Object> value) {
            this._properties = value;
            return this;
        }

        public Artifact build() {
            return new Artifact(){
                private final String $environment;
                private final ArtifactType $type;
                @Nullable
                private final Boolean $autoDeploy;
                @Nullable
                private final List<String> $dependencies;
                @Nullable
                private final Map<String, Object> $metadata;
                @Nullable
                private final Map<String, Object> $missing;
                @Nullable
                private final Map<String, Object> $properties;
                {
                    this.$environment = Objects.requireNonNull(_environment, "environment is required");
                    this.$type = Objects.requireNonNull(_type, "type is required");
                    this.$autoDeploy = _autoDeploy;
                    this.$dependencies = _dependencies;
                    this.$metadata = _metadata;
                    this.$missing = _missing;
                    this.$properties = _properties;
                }

                @Override
                public String getEnvironment() {
                    return this.$environment;
                }

                @Override
                public ArtifactType getType() {
                    return this.$type;
                }

                @Override
                public Boolean getAutoDeploy() {
                    return this.$autoDeploy;
                }

                @Override
                public List<String> getDependencies() {
                    return this.$dependencies;
                }

                @Override
                public Map<String, Object> getMetadata() {
                    return this.$metadata;
                }

                @Override
                public Map<String, Object> getMissing() {
                    return this.$missing;
                }

                @Override
                public Map<String, Object> getProperties() {
                    return this.$properties;
                }

                public JsonNode $jsii$toJson() {
                    ObjectMapper om = JsiiObjectMapper.INSTANCE;
                    ObjectNode obj = JsonNodeFactory.instance.objectNode();
                    obj.set("environment", om.valueToTree((Object)this.getEnvironment()));
                    obj.set("type", om.valueToTree((Object)this.getType()));
                    obj.set("autoDeploy", om.valueToTree((Object)this.getAutoDeploy()));
                    obj.set("dependencies", om.valueToTree(this.getDependencies()));
                    obj.set("metadata", om.valueToTree(this.getMetadata()));
                    obj.set("missing", om.valueToTree(this.getMissing()));
                    obj.set("properties", om.valueToTree(this.getProperties()));
                    return obj;
                }
            };
        }
    }
}

