/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.cxapi;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import software.amazon.awscdk.cxapi.ArtifactManifest;
import software.amazon.awscdk.cxapi.MissingContext;
import software.amazon.awscdk.cxapi.RuntimeInfo;
import software.amazon.jsii.JsiiObjectMapper;
import software.amazon.jsii.JsiiSerializable;

public interface AssemblyManifest
extends JsiiSerializable {
    public String getVersion();

    public Map<String, ArtifactManifest> getArtifacts();

    public List<MissingContext> getMissing();

    public RuntimeInfo getRuntime();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String _version;
        @Nullable
        private Map<String, ArtifactManifest> _artifacts;
        @Nullable
        private List<MissingContext> _missing;
        @Nullable
        private RuntimeInfo _runtime;

        public Builder withVersion(String value) {
            this._version = Objects.requireNonNull(value, "version is required");
            return this;
        }

        public Builder withArtifacts(@Nullable Map<String, ArtifactManifest> value) {
            this._artifacts = value;
            return this;
        }

        public Builder withMissing(@Nullable List<MissingContext> value) {
            this._missing = value;
            return this;
        }

        public Builder withRuntime(@Nullable RuntimeInfo value) {
            this._runtime = value;
            return this;
        }

        public AssemblyManifest build() {
            return new AssemblyManifest(){
                private final String $version;
                @Nullable
                private final Map<String, ArtifactManifest> $artifacts;
                @Nullable
                private final List<MissingContext> $missing;
                @Nullable
                private final RuntimeInfo $runtime;
                {
                    this.$version = Objects.requireNonNull(_version, "version is required");
                    this.$artifacts = _artifacts;
                    this.$missing = _missing;
                    this.$runtime = _runtime;
                }

                @Override
                public String getVersion() {
                    return this.$version;
                }

                @Override
                public Map<String, ArtifactManifest> getArtifacts() {
                    return this.$artifacts;
                }

                @Override
                public List<MissingContext> getMissing() {
                    return this.$missing;
                }

                @Override
                public RuntimeInfo getRuntime() {
                    return this.$runtime;
                }

                public JsonNode $jsii$toJson() {
                    ObjectMapper om = JsiiObjectMapper.INSTANCE;
                    ObjectNode obj = JsonNodeFactory.instance.objectNode();
                    obj.set("version", om.valueToTree((Object)this.getVersion()));
                    if (this.getArtifacts() != null) {
                        obj.set("artifacts", om.valueToTree(this.getArtifacts()));
                    }
                    if (this.getMissing() != null) {
                        obj.set("missing", om.valueToTree(this.getMissing()));
                    }
                    if (this.getRuntime() != null) {
                        obj.set("runtime", om.valueToTree((Object)this.getRuntime()));
                    }
                    return obj;
                }
            };
        }
    }
}

