package software.amazon.awscdk.cxapi;

/**
 * A manifest for a single artifact within the cloud assembly.
 * 
 * EXPERIMENTAL
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.13.3 (build 3624e0f)", date = "2019-07-04T19:18:29.059Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface ArtifactManifest extends software.amazon.jsii.JsiiSerializable {
    /**
     * The environment into which this artifact is deployed.
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    java.lang.String getEnvironment();
    /**
     * The type of artifact.
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    software.amazon.awscdk.cxapi.ArtifactType getType();
    /**
     * IDs of artifacts that must be deployed before this artifact.
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    java.util.List<java.lang.String> getDependencies();
    /**
     * Associated metadata.
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    java.util.Map<java.lang.String, java.util.List<software.amazon.awscdk.cxapi.MetadataEntry>> getMetadata();
    /**
     * The set of properties for this artifact (depends on type).
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    java.util.Map<java.lang.String, java.lang.Object> getProperties();

    /**
     * @return a {@link Builder} of {@link ArtifactManifest}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link ArtifactManifest}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    final class Builder {
        private java.lang.String _environment;
        private software.amazon.awscdk.cxapi.ArtifactType _type;
        @javax.annotation.Nullable
        private java.util.List<java.lang.String> _dependencies;
        @javax.annotation.Nullable
        private java.util.Map<java.lang.String, java.util.List<software.amazon.awscdk.cxapi.MetadataEntry>> _metadata;
        @javax.annotation.Nullable
        private java.util.Map<java.lang.String, java.lang.Object> _properties;

        /**
         * Sets the value of Environment
         * @param value The environment into which this artifact is deployed.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder withEnvironment(final java.lang.String value) {
            this._environment = java.util.Objects.requireNonNull(value, "environment is required");
            return this;
        }
        /**
         * Sets the value of Type
         * @param value The type of artifact.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder withType(final software.amazon.awscdk.cxapi.ArtifactType value) {
            this._type = java.util.Objects.requireNonNull(value, "type is required");
            return this;
        }
        /**
         * Sets the value of Dependencies
         * @param value IDs of artifacts that must be deployed before this artifact.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder withDependencies(@javax.annotation.Nullable final java.util.List<java.lang.String> value) {
            this._dependencies = value;
            return this;
        }
        /**
         * Sets the value of Metadata
         * @param value Associated metadata.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder withMetadata(@javax.annotation.Nullable final java.util.Map<java.lang.String, java.util.List<software.amazon.awscdk.cxapi.MetadataEntry>> value) {
            this._metadata = value;
            return this;
        }
        /**
         * Sets the value of Properties
         * @param value The set of properties for this artifact (depends on type).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder withProperties(@javax.annotation.Nullable final java.util.Map<java.lang.String, java.lang.Object> value) {
            this._properties = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ArtifactManifest}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public ArtifactManifest build() {
            return new ArtifactManifest() {
                private final java.lang.String $environment = java.util.Objects.requireNonNull(_environment, "environment is required");
                private final software.amazon.awscdk.cxapi.ArtifactType $type = java.util.Objects.requireNonNull(_type, "type is required");
                @javax.annotation.Nullable
                private final java.util.List<java.lang.String> $dependencies = _dependencies;
                @javax.annotation.Nullable
                private final java.util.Map<java.lang.String, java.util.List<software.amazon.awscdk.cxapi.MetadataEntry>> $metadata = _metadata;
                @javax.annotation.Nullable
                private final java.util.Map<java.lang.String, java.lang.Object> $properties = _properties;

                @Override
                public java.lang.String getEnvironment() {
                    return this.$environment;
                }

                @Override
                public software.amazon.awscdk.cxapi.ArtifactType getType() {
                    return this.$type;
                }

                @Override
                public java.util.List<java.lang.String> getDependencies() {
                    return this.$dependencies;
                }

                @Override
                public java.util.Map<java.lang.String, java.util.List<software.amazon.awscdk.cxapi.MetadataEntry>> getMetadata() {
                    return this.$metadata;
                }

                @Override
                public java.util.Map<java.lang.String, java.lang.Object> getProperties() {
                    return this.$properties;
                }

                public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                    com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                    com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                    obj.set("environment", om.valueToTree(this.getEnvironment()));
                    obj.set("type", om.valueToTree(this.getType()));
                    if (this.getDependencies() != null) {
                        obj.set("dependencies", om.valueToTree(this.getDependencies()));
                    }
                    if (this.getMetadata() != null) {
                        obj.set("metadata", om.valueToTree(this.getMetadata()));
                    }
                    if (this.getProperties() != null) {
                        obj.set("properties", om.valueToTree(this.getProperties()));
                    }
                    return obj;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.cxapi.ArtifactManifest {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * The environment into which this artifact is deployed.
         * 
         * EXPERIMENTAL
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public java.lang.String getEnvironment() {
            return this.jsiiGet("environment", java.lang.String.class);
        }

        /**
         * The type of artifact.
         * 
         * EXPERIMENTAL
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public software.amazon.awscdk.cxapi.ArtifactType getType() {
            return this.jsiiGet("type", software.amazon.awscdk.cxapi.ArtifactType.class);
        }

        /**
         * IDs of artifacts that must be deployed before this artifact.
         * 
         * EXPERIMENTAL
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @javax.annotation.Nullable
        public java.util.List<java.lang.String> getDependencies() {
            return this.jsiiGet("dependencies", java.util.List.class);
        }

        /**
         * Associated metadata.
         * 
         * EXPERIMENTAL
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @javax.annotation.Nullable
        public java.util.Map<java.lang.String, java.util.List<software.amazon.awscdk.cxapi.MetadataEntry>> getMetadata() {
            return this.jsiiGet("metadata", java.util.Map.class);
        }

        /**
         * The set of properties for this artifact (depends on type).
         * 
         * EXPERIMENTAL
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @javax.annotation.Nullable
        public java.util.Map<java.lang.String, java.lang.Object> getProperties() {
            return this.jsiiGet("properties", java.util.Map.class);
        }
    }
}
