package software.amazon.awscdk.cxapi;
/**
 * Models an AWS execution environment, for use within the CDK toolkit.
 */
public interface Environment extends software.amazon.jsii.JsiiSerializable {
    /**
     * The arbitrary name of this environment (user-set, or at least user-meaningful) 
     */
    java.lang.String getName();
    /**
     * The arbitrary name of this environment (user-set, or at least user-meaningful) 
     */
    void setName(final java.lang.String value);
    /**
     * The 12-digit AWS account ID for the account this environment deploys into 
     */
    java.lang.String getAccount();
    /**
     * The 12-digit AWS account ID for the account this environment deploys into 
     */
    void setAccount(final java.lang.String value);
    /**
     * The AWS region name where this environment deploys into 
     */
    java.lang.String getRegion();
    /**
     * The AWS region name where this environment deploys into 
     */
    void setRegion(final java.lang.String value);

    // ==================================================================
    // Builder
    // ==================================================================

    static Builder builder() {
        return new Builder();
    }
    /**
     * A fluent step builder class for {@link Environment}.
     * The {@link Build#build()} method will be available once all required properties are fulfilled.
     */
    final class Builder {
        /**
         * The arbitrary name of this environment (user-set, or at least user-meaningful) 
         */
        public AccountStep withName(final java.lang.String value) {
            return new FullBuilder().withName(value);
        }

        public interface AccountStep {
            /**
             * The 12-digit AWS account ID for the account this environment deploys into 
             */
            RegionStep withAccount(final java.lang.String value);
        }

        public interface RegionStep {
            /**
             * The AWS region name where this environment deploys into 
             */
            Build withRegion(final java.lang.String value);
        }

        public interface Build {
            /**
             * @return a new {@link Environment} object, initialized with the values set on this builder.
             */
            Environment build();
        }

        final class FullBuilder implements AccountStep, RegionStep, Build {

            private Jsii$Pojo instance = new Jsii$Pojo();

            /**
             * The arbitrary name of this environment (user-set, or at least user-meaningful) 
             */
            public AccountStep withName(final java.lang.String value) {
                java.util.Objects.requireNonNull(value, "Environment#name is required");
                this.instance._name = value;
                return this;
            }
            /**
             * The 12-digit AWS account ID for the account this environment deploys into 
             */
            public RegionStep withAccount(final java.lang.String value) {
                java.util.Objects.requireNonNull(value, "Environment#account is required");
                this.instance._account = value;
                return this;
            }
            /**
             * The AWS region name where this environment deploys into 
             */
            public Build withRegion(final java.lang.String value) {
                java.util.Objects.requireNonNull(value, "Environment#region is required");
                this.instance._region = value;
                return this;
            }
            public Environment build() {
                Environment result = this.instance;
                this.instance = new Jsii$Pojo();
                return result;
            }
        }
    }

    /**
     * A PoJo (plain-old-java-object) class that implements {@link Environment}.
     */
    final class Jsii$Pojo implements Environment {

        /**
         * Constructor used by builders.
         */
        protected Jsii$Pojo() { }


        protected java.lang.String _name;

        public java.lang.String getName() {
            return this._name;
        }
        public void setName(final java.lang.String value) {
            this._name = value;
        }

        protected java.lang.String _account;

        public java.lang.String getAccount() {
            return this._account;
        }
        public void setAccount(final java.lang.String value) {
            this._account = value;
        }

        protected java.lang.String _region;

        public java.lang.String getRegion() {
            return this._region;
        }
        public void setRegion(final java.lang.String value) {
            this._region = value;
        }
    }

    /**
     * A proxy class which for javascript object literal which adhere to this interface.
     */
    class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.cxapi.Environment {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }
        /**
         * The arbitrary name of this environment (user-set, or at least user-meaningful) 
         */
        public java.lang.String getName() {
            return this.jsiiGet("name", java.lang.String.class);
        }
        /**
         * The arbitrary name of this environment (user-set, or at least user-meaningful) 
         */
        public void setName(final java.lang.String value) {
            this.jsiiSet("name", java.util.Objects.requireNonNull(value, "name is required"));
        }
        /**
         * The 12-digit AWS account ID for the account this environment deploys into 
         */
        public java.lang.String getAccount() {
            return this.jsiiGet("account", java.lang.String.class);
        }
        /**
         * The 12-digit AWS account ID for the account this environment deploys into 
         */
        public void setAccount(final java.lang.String value) {
            this.jsiiSet("account", java.util.Objects.requireNonNull(value, "account is required"));
        }
        /**
         * The AWS region name where this environment deploys into 
         */
        public java.lang.String getRegion() {
            return this.jsiiGet("region", java.lang.String.class);
        }
        /**
         * The AWS region name where this environment deploys into 
         */
        public void setRegion(final java.lang.String value) {
            this.jsiiSet("region", java.util.Objects.requireNonNull(value, "region is required"));
        }
    }
}
