package software.amazon.awscdk.cxapi;
/**
 * Information about the application's runtime components.
 */
public interface AppRuntime extends software.amazon.jsii.JsiiSerializable {
    /**
     * The list of libraries loaded in the application, associated with their versions.
     */
    java.util.Map<java.lang.String, java.lang.String> getLibraries();
    /**
     * The list of libraries loaded in the application, associated with their versions.
     */
    void setLibraries(final java.util.Map<java.lang.String, java.lang.String> value);

    // ==================================================================
    // Builder
    // ==================================================================

    static Builder builder() {
        return new Builder();
    }
    /**
     * A fluent step builder class for {@link AppRuntime}.
     * The {@link Build#build()} method will be available once all required properties are fulfilled.
     */
    final class Builder {
        /**
         * The list of libraries loaded in the application, associated with their versions.
         */
        public Build withLibraries(final java.util.Map<java.lang.String, java.lang.String> value) {
            return new FullBuilder().withLibraries(value);
        }

        public interface Build {
            /**
             * @return a new {@link AppRuntime} object, initialized with the values set on this builder.
             */
            AppRuntime build();
        }

        final class FullBuilder implements Build {

            private Jsii$Pojo instance = new Jsii$Pojo();

            /**
             * The list of libraries loaded in the application, associated with their versions.
             */
            public Build withLibraries(final java.util.Map<java.lang.String, java.lang.String> value) {
                java.util.Objects.requireNonNull(value, "AppRuntime#libraries is required");
                this.instance._libraries = value;
                return this;
            }
            public AppRuntime build() {
                AppRuntime result = this.instance;
                this.instance = new Jsii$Pojo();
                return result;
            }
        }
    }

    /**
     * A PoJo (plain-old-java-object) class that implements {@link AppRuntime}.
     */
    final class Jsii$Pojo implements AppRuntime {

        /**
         * Constructor used by builders.
         */
        protected Jsii$Pojo() { }


        protected java.util.Map<java.lang.String, java.lang.String> _libraries;

        public java.util.Map<java.lang.String, java.lang.String> getLibraries() {
            return this._libraries;
        }
        public void setLibraries(final java.util.Map<java.lang.String, java.lang.String> value) {
            this._libraries = value;
        }
    }

    /**
     * A proxy class which for javascript object literal which adhere to this interface.
     */
    class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.cxapi.AppRuntime {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }
        /**
         * The list of libraries loaded in the application, associated with their versions.
         */
        public java.util.Map<java.lang.String, java.lang.String> getLibraries() {
            return this.jsiiGet("libraries", java.util.Map.class);
        }
        /**
         * The list of libraries loaded in the application, associated with their versions.
         */
        public void setLibraries(final java.util.Map<java.lang.String, java.lang.String> value) {
            this.jsiiSet("libraries", java.util.Objects.requireNonNull(value, "libraries is required"));
        }
    }
}
