package software.amazon.awscdk.cxapi;
/**
 * An metadata entry in the construct.
 */
public interface MetadataEntry extends software.amazon.jsii.JsiiSerializable {
    /**
     * The type of the metadata entry.
     */
    java.lang.String getType();
    /**
     * The type of the metadata entry.
     */
    void setType(final java.lang.String value);
    /**
     * The data.
     */
    java.lang.Object getData();
    /**
     * The data.
     */
    void setData(final java.lang.Object value);
    /**
     * A stack trace for when the entry was created.
     */
    java.util.List<java.lang.String> getTrace();
    /**
     * A stack trace for when the entry was created.
     */
    void setTrace(final java.util.List<java.lang.String> value);

    // ==================================================================
    // Builder
    // ==================================================================

    static Builder builder() {
        return new Builder();
    }
    /**
     * A fluent step builder class for {@link MetadataEntry}.
     * The {@link Build#build()} method will be available once all required properties are fulfilled.
     */
    final class Builder {
        /**
         * The type of the metadata entry.
         */
        public TraceStep withType(final java.lang.String value) {
            return new FullBuilder().withType(value);
        }

        public interface TraceStep {
            /**
             * A stack trace for when the entry was created.
             */
            Build withTrace(final java.util.List<java.lang.String> value);
        }

        public interface Build {
            /**
             * @return a new {@link MetadataEntry} object, initialized with the values set on this builder.
             */
            MetadataEntry build();
            /**
             * The data.
             */
            Build withData(final java.lang.Object value);
        }

        final class FullBuilder implements TraceStep, Build {

            private Jsii$Pojo instance = new Jsii$Pojo();

            /**
             * The type of the metadata entry.
             */
            public TraceStep withType(final java.lang.String value) {
                java.util.Objects.requireNonNull(value, "MetadataEntry#type is required");
                this.instance._type = value;
                return this;
            }
            /**
             * The data.
             */
            public Build withData(final java.lang.Object value) {
                this.instance._data = value;
                return this;
            }
            /**
             * A stack trace for when the entry was created.
             */
            public Build withTrace(final java.util.List<java.lang.String> value) {
                java.util.Objects.requireNonNull(value, "MetadataEntry#trace is required");
                this.instance._trace = value;
                return this;
            }
            public MetadataEntry build() {
                MetadataEntry result = this.instance;
                this.instance = new Jsii$Pojo();
                return result;
            }
        }
    }

    /**
     * A PoJo (plain-old-java-object) class that implements {@link MetadataEntry}.
     */
    final class Jsii$Pojo implements MetadataEntry {

        /**
         * Constructor used by builders.
         */
        protected Jsii$Pojo() { }


        protected java.lang.String _type;

        public java.lang.String getType() {
            return this._type;
        }
        public void setType(final java.lang.String value) {
            this._type = value;
        }

        protected java.lang.Object _data;

        public java.lang.Object getData() {
            return this._data;
        }
        public void setData(final java.lang.Object value) {
            this._data = value;
        }

        protected java.util.List<java.lang.String> _trace;

        public java.util.List<java.lang.String> getTrace() {
            return this._trace;
        }
        public void setTrace(final java.util.List<java.lang.String> value) {
            this._trace = value;
        }
    }

    /**
     * A proxy class which for javascript object literal which adhere to this interface.
     */
    class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.cxapi.MetadataEntry {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }
        /**
         * The type of the metadata entry.
         */
        public java.lang.String getType() {
            return this.jsiiGet("type", java.lang.String.class);
        }
        /**
         * The type of the metadata entry.
         */
        public void setType(final java.lang.String value) {
            this.jsiiSet("type", java.util.Objects.requireNonNull(value, "type is required"));
        }
        /**
         * The data.
         */
        @javax.annotation.Nullable
        public java.lang.Object getData() {
            return this.jsiiGet("data", java.lang.Object.class);
        }
        /**
         * The data.
         */
        public void setData(@javax.annotation.Nullable final java.lang.Object value) {
            this.jsiiSet("data", value);
        }
        /**
         * A stack trace for when the entry was created.
         */
        public java.util.List<java.lang.String> getTrace() {
            return this.jsiiGet("trace", java.util.List.class);
        }
        /**
         * A stack trace for when the entry was created.
         */
        public void setTrace(final java.util.List<java.lang.String> value) {
            this.jsiiSet("trace", java.util.Objects.requireNonNull(value, "trace is required"));
        }
    }
}
