package software.amazon.awscdk.cxapi;
/**
 * Identifies and contains metadata about a stack
 */
public interface StackInfo extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.cxapi.StackId {
    software.amazon.awscdk.cxapi.Environment getEnvironment();
    void setEnvironment(final software.amazon.awscdk.cxapi.Environment value);

    // ==================================================================
    // Builder
    // ==================================================================

    static Builder builder() {
        return new Builder();
    }
    /**
     * A fluent step builder class for {@link StackInfo}.
     * The {@link Build#build()} method will be available once all required properties are fulfilled.
     */
    final class Builder {
        public Build withName(final java.lang.String value) {
            return new FullBuilder().withName(value);
        }

        public interface Build {
            /**
             * @return a new {@link StackInfo} object, initialized with the values set on this builder.
             */
            StackInfo build();
            /**
             * Sets the value for {@link StackInfo#getEnvironment}.
             */
            Build withEnvironment(final software.amazon.awscdk.cxapi.Environment value);
        }

        final class FullBuilder implements Build {

            private Jsii$Pojo instance = new Jsii$Pojo();

            public Build withEnvironment(final software.amazon.awscdk.cxapi.Environment value) {
                this.instance._environment = value;
                return this;
            }
            public Build withName(final java.lang.String value) {
                java.util.Objects.requireNonNull(value, "StackInfo#name is required");
                this.instance._name = value;
                return this;
            }
            public StackInfo build() {
                StackInfo result = this.instance;
                this.instance = new Jsii$Pojo();
                return result;
            }
        }
    }

    /**
     * A PoJo (plain-old-java-object) class that implements {@link StackInfo}.
     */
    final class Jsii$Pojo implements StackInfo {

        /**
         * Constructor used by builders.
         */
        protected Jsii$Pojo() { }


        protected software.amazon.awscdk.cxapi.Environment _environment;

        public software.amazon.awscdk.cxapi.Environment getEnvironment() {
            return this._environment;
        }
        public void setEnvironment(final software.amazon.awscdk.cxapi.Environment value) {
            this._environment = value;
        }

        protected java.lang.String _name;

        public java.lang.String getName() {
            return this._name;
        }
        public void setName(final java.lang.String value) {
            this._name = value;
        }
    }

    /**
     * A proxy class which for javascript object literal which adhere to this interface.
     */
    class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.cxapi.StackInfo {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }
        @javax.annotation.Nullable
        public software.amazon.awscdk.cxapi.Environment getEnvironment() {
            return this.jsiiGet("environment", software.amazon.awscdk.cxapi.Environment.class);
        }
        public void setEnvironment(@javax.annotation.Nullable final software.amazon.awscdk.cxapi.Environment value) {
            this.jsiiSet("environment", value);
        }
        public java.lang.String getName() {
            return this.jsiiGet("name", java.lang.String.class);
        }
        public void setName(final java.lang.String value) {
            this.jsiiSet("name", java.util.Objects.requireNonNull(value, "name is required"));
        }
    }
}
