package software.amazon.awscdk.cxapi;

/**
 * Query to hosted zone context provider.
 * 
 * EXPERIMENTAL
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.14.2 (build e881f16)", date = "2019-07-19T18:55:41.594Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface HostedZoneContextQuery extends software.amazon.jsii.JsiiSerializable {
    /**
     * The domain name e.g. example.com to lookup.
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    java.lang.String getDomainName();
    /**
     * Query account.
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    java.lang.String getAccount();
    /**
     * True if the zone you want to find is a private hosted zone.
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    java.lang.Boolean getPrivateZone();
    /**
     * Query region.
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    java.lang.String getRegion();
    /**
     * The VPC ID to that the private zone must be associated with.
     * 
     * If you provide VPC ID and privateZone is false, this will return no results
     * and raise an error.
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    java.lang.String getVpcId();

    /**
     * @return a {@link Builder} of {@link HostedZoneContextQuery}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link HostedZoneContextQuery}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    final class Builder {
        private java.lang.String _domainName;
        @javax.annotation.Nullable
        private java.lang.String _account;
        @javax.annotation.Nullable
        private java.lang.Boolean _privateZone;
        @javax.annotation.Nullable
        private java.lang.String _region;
        @javax.annotation.Nullable
        private java.lang.String _vpcId;

        /**
         * Sets the value of DomainName
         * @param value The domain name e.g. example.com to lookup.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder withDomainName(final java.lang.String value) {
            this._domainName = java.util.Objects.requireNonNull(value, "domainName is required");
            return this;
        }
        /**
         * Sets the value of Account
         * @param value Query account.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder withAccount(@javax.annotation.Nullable final java.lang.String value) {
            this._account = value;
            return this;
        }
        /**
         * Sets the value of PrivateZone
         * @param value True if the zone you want to find is a private hosted zone.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder withPrivateZone(@javax.annotation.Nullable final java.lang.Boolean value) {
            this._privateZone = value;
            return this;
        }
        /**
         * Sets the value of Region
         * @param value Query region.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder withRegion(@javax.annotation.Nullable final java.lang.String value) {
            this._region = value;
            return this;
        }
        /**
         * Sets the value of VpcId
         * @param value The VPC ID to that the private zone must be associated with.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder withVpcId(@javax.annotation.Nullable final java.lang.String value) {
            this._vpcId = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link HostedZoneContextQuery}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public HostedZoneContextQuery build() {
            return new HostedZoneContextQuery() {
                private final java.lang.String $domainName = java.util.Objects.requireNonNull(_domainName, "domainName is required");
                @javax.annotation.Nullable
                private final java.lang.String $account = _account;
                @javax.annotation.Nullable
                private final java.lang.Boolean $privateZone = _privateZone;
                @javax.annotation.Nullable
                private final java.lang.String $region = _region;
                @javax.annotation.Nullable
                private final java.lang.String $vpcId = _vpcId;

                @Override
                public java.lang.String getDomainName() {
                    return this.$domainName;
                }

                @Override
                public java.lang.String getAccount() {
                    return this.$account;
                }

                @Override
                public java.lang.Boolean getPrivateZone() {
                    return this.$privateZone;
                }

                @Override
                public java.lang.String getRegion() {
                    return this.$region;
                }

                @Override
                public java.lang.String getVpcId() {
                    return this.$vpcId;
                }

                public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                    com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                    com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                    obj.set("domainName", om.valueToTree(this.getDomainName()));
                    if (this.getAccount() != null) {
                        obj.set("account", om.valueToTree(this.getAccount()));
                    }
                    if (this.getPrivateZone() != null) {
                        obj.set("privateZone", om.valueToTree(this.getPrivateZone()));
                    }
                    if (this.getRegion() != null) {
                        obj.set("region", om.valueToTree(this.getRegion()));
                    }
                    if (this.getVpcId() != null) {
                        obj.set("vpcId", om.valueToTree(this.getVpcId()));
                    }
                    return obj;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.cxapi.HostedZoneContextQuery {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * The domain name e.g. example.com to lookup.
         * 
         * EXPERIMENTAL
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public java.lang.String getDomainName() {
            return this.jsiiGet("domainName", java.lang.String.class);
        }

        /**
         * Query account.
         * 
         * EXPERIMENTAL
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @javax.annotation.Nullable
        public java.lang.String getAccount() {
            return this.jsiiGet("account", java.lang.String.class);
        }

        /**
         * True if the zone you want to find is a private hosted zone.
         * 
         * EXPERIMENTAL
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @javax.annotation.Nullable
        public java.lang.Boolean getPrivateZone() {
            return this.jsiiGet("privateZone", java.lang.Boolean.class);
        }

        /**
         * Query region.
         * 
         * EXPERIMENTAL
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @javax.annotation.Nullable
        public java.lang.String getRegion() {
            return this.jsiiGet("region", java.lang.String.class);
        }

        /**
         * The VPC ID to that the private zone must be associated with.
         * 
         * If you provide VPC ID and privateZone is false, this will return no results
         * and raise an error.
         * 
         * EXPERIMENTAL
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @javax.annotation.Nullable
        public java.lang.String getVpcId() {
            return this.jsiiGet("vpcId", java.lang.String.class);
        }
    }
}
