package software.amazon.awscdk.cxapi;

/**
 * A manifest for a single artifact within the cloud assembly.
 * 
 * EXPERIMENTAL
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.17.0 (build 7d5d104)", date = "2019-09-30T08:21:02.963Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface ArtifactManifest extends software.amazon.jsii.JsiiSerializable {

    /**
     * The type of artifact.
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    software.amazon.awscdk.cxapi.ArtifactType getType();

    /**
     * IDs of artifacts that must be deployed before this artifact.
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    java.util.List<java.lang.String> getDependencies();

    /**
     * The environment into which this artifact is deployed.
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    java.lang.String getEnvironment();

    /**
     * Associated metadata.
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    java.util.Map<java.lang.String, java.util.List<software.amazon.awscdk.cxapi.MetadataEntry>> getMetadata();

    /**
     * The set of properties for this artifact (depends on type).
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    java.util.Map<java.lang.String, java.lang.Object> getProperties();

    /**
     * @return a {@link Builder} of {@link ArtifactManifest}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ArtifactManifest}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder {
        private software.amazon.awscdk.cxapi.ArtifactType type;
        private java.util.List<java.lang.String> dependencies;
        private java.lang.String environment;
        private java.util.Map<java.lang.String, java.util.List<software.amazon.awscdk.cxapi.MetadataEntry>> metadata;
        private java.util.Map<java.lang.String, java.lang.Object> properties;

        /**
         * Sets the value of Type
         * @param type The type of artifact. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder type(software.amazon.awscdk.cxapi.ArtifactType type) {
            this.type = type;
            return this;
        }

        /**
         * Sets the value of Dependencies
         * @param dependencies IDs of artifacts that must be deployed before this artifact.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder dependencies(java.util.List<java.lang.String> dependencies) {
            this.dependencies = dependencies;
            return this;
        }

        /**
         * Sets the value of Environment
         * @param environment The environment into which this artifact is deployed.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder environment(java.lang.String environment) {
            this.environment = environment;
            return this;
        }

        /**
         * Sets the value of Metadata
         * @param metadata Associated metadata.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder metadata(java.util.Map<java.lang.String, java.util.List<software.amazon.awscdk.cxapi.MetadataEntry>> metadata) {
            this.metadata = metadata;
            return this;
        }

        /**
         * Sets the value of Properties
         * @param properties The set of properties for this artifact (depends on type).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder properties(java.util.Map<java.lang.String, java.lang.Object> properties) {
            this.properties = properties;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ArtifactManifest}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public ArtifactManifest build() {
            return new Jsii$Proxy(type, dependencies, environment, metadata, properties);
        }
    }

    /**
     * An implementation for {@link ArtifactManifest}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ArtifactManifest {
        private final software.amazon.awscdk.cxapi.ArtifactType type;
        private final java.util.List<java.lang.String> dependencies;
        private final java.lang.String environment;
        private final java.util.Map<java.lang.String, java.util.List<software.amazon.awscdk.cxapi.MetadataEntry>> metadata;
        private final java.util.Map<java.lang.String, java.lang.Object> properties;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.setObjRef(objRef);
            this.type = this.jsiiGet("type", software.amazon.awscdk.cxapi.ArtifactType.class);
            this.dependencies = this.jsiiGet("dependencies", java.util.List.class);
            this.environment = this.jsiiGet("environment", java.lang.String.class);
            this.metadata = this.jsiiGet("metadata", java.util.Map.class);
            this.properties = this.jsiiGet("properties", java.util.Map.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(software.amazon.awscdk.cxapi.ArtifactType type, java.util.List<java.lang.String> dependencies, java.lang.String environment, java.util.Map<java.lang.String, java.util.List<software.amazon.awscdk.cxapi.MetadataEntry>> metadata, java.util.Map<java.lang.String, java.lang.Object> properties) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.type = java.util.Objects.requireNonNull(type, "type is required");
            this.dependencies = dependencies;
            this.environment = environment;
            this.metadata = metadata;
            this.properties = properties;
        }

        @Override
        public software.amazon.awscdk.cxapi.ArtifactType getType() {
            return this.type;
        }

        @Override
        public java.util.List<java.lang.String> getDependencies() {
            return this.dependencies;
        }

        @Override
        public java.lang.String getEnvironment() {
            return this.environment;
        }

        @Override
        public java.util.Map<java.lang.String, java.util.List<software.amazon.awscdk.cxapi.MetadataEntry>> getMetadata() {
            return this.metadata;
        }

        @Override
        public java.util.Map<java.lang.String, java.lang.Object> getProperties() {
            return this.properties;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("type", om.valueToTree(this.getType()));
            if (this.getDependencies() != null) {
                obj.set("dependencies", om.valueToTree(this.getDependencies()));
            }
            if (this.getEnvironment() != null) {
                obj.set("environment", om.valueToTree(this.getEnvironment()));
            }
            if (this.getMetadata() != null) {
                obj.set("metadata", om.valueToTree(this.getMetadata()));
            }
            if (this.getProperties() != null) {
                obj.set("properties", om.valueToTree(this.getProperties()));
            }
            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ArtifactManifest.Jsii$Proxy that = (ArtifactManifest.Jsii$Proxy) o;

            if (!type.equals(that.type)) return false;
            if (this.dependencies != null ? !this.dependencies.equals(that.dependencies) : that.dependencies != null) return false;
            if (this.environment != null ? !this.environment.equals(that.environment) : that.environment != null) return false;
            if (this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null) return false;
            return this.properties != null ? this.properties.equals(that.properties) : that.properties == null;
        }

        @Override
        public int hashCode() {
            int result = this.type.hashCode();
            result = 31 * result + (this.dependencies != null ? this.dependencies.hashCode() : 0);
            result = 31 * result + (this.environment != null ? this.environment.hashCode() : 0);
            result = 31 * result + (this.metadata != null ? this.metadata.hashCode() : 0);
            result = 31 * result + (this.properties != null ? this.properties.hashCode() : 0);
            return result;
        }
    }
}
