package software.amazon.awscdk.cxapi;

/**
 * Query to hosted zone context provider.
 * 
 * EXPERIMENTAL
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.19.0 (build 7c562bc)", date = "2019-10-15T12:18:50.490Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface HostedZoneContextQuery extends software.amazon.jsii.JsiiSerializable {

    /**
     * The domain name e.g. example.com to lookup.
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    java.lang.String getDomainName();

    /**
     * Query account.
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    java.lang.String getAccount();

    /**
     * True if the zone you want to find is a private hosted zone.
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    java.lang.Boolean getPrivateZone();

    /**
     * Query region.
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    java.lang.String getRegion();

    /**
     * The VPC ID to that the private zone must be associated with.
     * 
     * If you provide VPC ID and privateZone is false, this will return no results
     * and raise an error.
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    java.lang.String getVpcId();

    /**
     * @return a {@link Builder} of {@link HostedZoneContextQuery}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link HostedZoneContextQuery}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder {
        private java.lang.String domainName;
        private java.lang.String account;
        private java.lang.Boolean privateZone;
        private java.lang.String region;
        private java.lang.String vpcId;

        /**
         * Sets the value of DomainName
         * @param domainName The domain name e.g. example.com to lookup. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder domainName(java.lang.String domainName) {
            this.domainName = domainName;
            return this;
        }

        /**
         * Sets the value of Account
         * @param account Query account.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder account(java.lang.String account) {
            this.account = account;
            return this;
        }

        /**
         * Sets the value of PrivateZone
         * @param privateZone True if the zone you want to find is a private hosted zone.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder privateZone(java.lang.Boolean privateZone) {
            this.privateZone = privateZone;
            return this;
        }

        /**
         * Sets the value of Region
         * @param region Query region.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder region(java.lang.String region) {
            this.region = region;
            return this;
        }

        /**
         * Sets the value of VpcId
         * @param vpcId The VPC ID to that the private zone must be associated with.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder vpcId(java.lang.String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link HostedZoneContextQuery}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public HostedZoneContextQuery build() {
            return new Jsii$Proxy(domainName, account, privateZone, region, vpcId);
        }
    }

    /**
     * An implementation for {@link HostedZoneContextQuery}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements HostedZoneContextQuery {
        private final java.lang.String domainName;
        private final java.lang.String account;
        private final java.lang.Boolean privateZone;
        private final java.lang.String region;
        private final java.lang.String vpcId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.setObjRef(objRef);
            this.domainName = this.jsiiGet("domainName", java.lang.String.class);
            this.account = this.jsiiGet("account", java.lang.String.class);
            this.privateZone = this.jsiiGet("privateZone", java.lang.Boolean.class);
            this.region = this.jsiiGet("region", java.lang.String.class);
            this.vpcId = this.jsiiGet("vpcId", java.lang.String.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(java.lang.String domainName, java.lang.String account, java.lang.Boolean privateZone, java.lang.String region, java.lang.String vpcId) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.domainName = java.util.Objects.requireNonNull(domainName, "domainName is required");
            this.account = account;
            this.privateZone = privateZone;
            this.region = region;
            this.vpcId = vpcId;
        }

        @Override
        public java.lang.String getDomainName() {
            return this.domainName;
        }

        @Override
        public java.lang.String getAccount() {
            return this.account;
        }

        @Override
        public java.lang.Boolean getPrivateZone() {
            return this.privateZone;
        }

        @Override
        public java.lang.String getRegion() {
            return this.region;
        }

        @Override
        public java.lang.String getVpcId() {
            return this.vpcId;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("domainName", om.valueToTree(this.getDomainName()));
            if (this.getAccount() != null) {
                obj.set("account", om.valueToTree(this.getAccount()));
            }
            if (this.getPrivateZone() != null) {
                obj.set("privateZone", om.valueToTree(this.getPrivateZone()));
            }
            if (this.getRegion() != null) {
                obj.set("region", om.valueToTree(this.getRegion()));
            }
            if (this.getVpcId() != null) {
                obj.set("vpcId", om.valueToTree(this.getVpcId()));
            }
            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            HostedZoneContextQuery.Jsii$Proxy that = (HostedZoneContextQuery.Jsii$Proxy) o;

            if (!domainName.equals(that.domainName)) return false;
            if (this.account != null ? !this.account.equals(that.account) : that.account != null) return false;
            if (this.privateZone != null ? !this.privateZone.equals(that.privateZone) : that.privateZone != null) return false;
            if (this.region != null ? !this.region.equals(that.region) : that.region != null) return false;
            return this.vpcId != null ? this.vpcId.equals(that.vpcId) : that.vpcId == null;
        }

        @Override
        public int hashCode() {
            int result = this.domainName.hashCode();
            result = 31 * result + (this.account != null ? this.account.hashCode() : 0);
            result = 31 * result + (this.privateZone != null ? this.privateZone.hashCode() : 0);
            result = 31 * result + (this.region != null ? this.region.hashCode() : 0);
            result = 31 * result + (this.vpcId != null ? this.vpcId.hashCode() : 0);
            return result;
        }
    }
}
