package software.amazon.awscdk.cxapi;

/**
 * A group of subnets returned by the VPC provider.
 * <p>
 * The included subnets do NOT have to be symmetric!
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.cxapi.*;
 * VpcSubnetGroup vpcSubnetGroup = VpcSubnetGroup.builder()
 *         .name("name")
 *         .subnets(List.of(VpcSubnet.builder()
 *                 .availabilityZone("availabilityZone")
 *                 .routeTableId("routeTableId")
 *                 .subnetId("subnetId")
 *                 // the properties below are optional
 *                 .cidr("cidr")
 *                 .build()))
 *         .type(VpcSubnetGroupType.PUBLIC)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.50.0 (build d1830a4)", date = "2022-01-07T14:33:46.957Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.cxapi.$Module.class, fqn = "@aws-cdk/cx-api.VpcSubnetGroup")
@software.amazon.jsii.Jsii.Proxy(VpcSubnetGroup.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface VpcSubnetGroup extends software.amazon.jsii.JsiiSerializable {

    /**
     * The name of the subnet group, determined by looking at the tags of of the subnets that belong to it.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getName();

    /**
     * The subnets that are part of this group.
     * <p>
     * There is no condition that the subnets have to be symmetric
     * in the group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.cxapi.VpcSubnet> getSubnets();

    /**
     * The type of the subnet group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.cxapi.VpcSubnetGroupType getType();

    /**
     * @return a {@link Builder} of {@link VpcSubnetGroup}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link VpcSubnetGroup}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<VpcSubnetGroup> {
        java.lang.String name;
        java.util.List<software.amazon.awscdk.cxapi.VpcSubnet> subnets;
        software.amazon.awscdk.cxapi.VpcSubnetGroupType type;

        /**
         * Sets the value of {@link VpcSubnetGroup#getName}
         * @param name The name of the subnet group, determined by looking at the tags of of the subnets that belong to it. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link VpcSubnetGroup#getSubnets}
         * @param subnets The subnets that are part of this group. This parameter is required.
         *                There is no condition that the subnets have to be symmetric
         *                in the group.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder subnets(java.util.List<? extends software.amazon.awscdk.cxapi.VpcSubnet> subnets) {
            this.subnets = (java.util.List<software.amazon.awscdk.cxapi.VpcSubnet>)subnets;
            return this;
        }

        /**
         * Sets the value of {@link VpcSubnetGroup#getType}
         * @param type The type of the subnet group. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder type(software.amazon.awscdk.cxapi.VpcSubnetGroupType type) {
            this.type = type;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link VpcSubnetGroup}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public VpcSubnetGroup build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link VpcSubnetGroup}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements VpcSubnetGroup {
        private final java.lang.String name;
        private final java.util.List<software.amazon.awscdk.cxapi.VpcSubnet> subnets;
        private final software.amazon.awscdk.cxapi.VpcSubnetGroupType type;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.subnets = software.amazon.jsii.Kernel.get(this, "subnets", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.cxapi.VpcSubnet.class)));
            this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.cxapi.VpcSubnetGroupType.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
            this.subnets = (java.util.List<software.amazon.awscdk.cxapi.VpcSubnet>)java.util.Objects.requireNonNull(builder.subnets, "subnets is required");
            this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.cxapi.VpcSubnet> getSubnets() {
            return this.subnets;
        }

        @Override
        public final software.amazon.awscdk.cxapi.VpcSubnetGroupType getType() {
            return this.type;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("name", om.valueToTree(this.getName()));
            data.set("subnets", om.valueToTree(this.getSubnets()));
            data.set("type", om.valueToTree(this.getType()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/cx-api.VpcSubnetGroup"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            VpcSubnetGroup.Jsii$Proxy that = (VpcSubnetGroup.Jsii$Proxy) o;

            if (!name.equals(that.name)) return false;
            if (!subnets.equals(that.subnets)) return false;
            return this.type.equals(that.type);
        }

        @Override
        public final int hashCode() {
            int result = this.name.hashCode();
            result = 31 * result + (this.subnets.hashCode());
            result = 31 * result + (this.type.hashCode());
            return result;
        }
    }
}
