package software.amazon.awscdk.cxapi;

/**
 * Properties of a discovered SecurityGroup.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.cxapi.*;
 * SecurityGroupContextResponse securityGroupContextResponse = SecurityGroupContextResponse.builder()
 *         .allowAllOutbound(false)
 *         .securityGroupId("securityGroupId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.52.1 (build 5ccc8f6)", date = "2022-01-28T22:52:15.486Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.cxapi.$Module.class, fqn = "@aws-cdk/cx-api.SecurityGroupContextResponse")
@software.amazon.jsii.Jsii.Proxy(SecurityGroupContextResponse.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface SecurityGroupContextResponse extends software.amazon.jsii.JsiiSerializable {

    /**
     * Whether the security group allows all outbound traffic.
     * <p>
     * This will be true
     * when the security group has all-protocol egress permissions to access both
     * <code>0.0.0.0/0</code> and <code>::/0</code>.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Boolean getAllowAllOutbound();

    /**
     * The security group's id.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getSecurityGroupId();

    /**
     * @return a {@link Builder} of {@link SecurityGroupContextResponse}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link SecurityGroupContextResponse}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<SecurityGroupContextResponse> {
        java.lang.Boolean allowAllOutbound;
        java.lang.String securityGroupId;

        /**
         * Sets the value of {@link SecurityGroupContextResponse#getAllowAllOutbound}
         * @param allowAllOutbound Whether the security group allows all outbound traffic. This parameter is required.
         *                         This will be true
         *                         when the security group has all-protocol egress permissions to access both
         *                         <code>0.0.0.0/0</code> and <code>::/0</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder allowAllOutbound(java.lang.Boolean allowAllOutbound) {
            this.allowAllOutbound = allowAllOutbound;
            return this;
        }

        /**
         * Sets the value of {@link SecurityGroupContextResponse#getSecurityGroupId}
         * @param securityGroupId The security group's id. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder securityGroupId(java.lang.String securityGroupId) {
            this.securityGroupId = securityGroupId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link SecurityGroupContextResponse}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public SecurityGroupContextResponse build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link SecurityGroupContextResponse}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SecurityGroupContextResponse {
        private final java.lang.Boolean allowAllOutbound;
        private final java.lang.String securityGroupId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.allowAllOutbound = software.amazon.jsii.Kernel.get(this, "allowAllOutbound", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.securityGroupId = software.amazon.jsii.Kernel.get(this, "securityGroupId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.allowAllOutbound = java.util.Objects.requireNonNull(builder.allowAllOutbound, "allowAllOutbound is required");
            this.securityGroupId = java.util.Objects.requireNonNull(builder.securityGroupId, "securityGroupId is required");
        }

        @Override
        public final java.lang.Boolean getAllowAllOutbound() {
            return this.allowAllOutbound;
        }

        @Override
        public final java.lang.String getSecurityGroupId() {
            return this.securityGroupId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("allowAllOutbound", om.valueToTree(this.getAllowAllOutbound()));
            data.set("securityGroupId", om.valueToTree(this.getSecurityGroupId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/cx-api.SecurityGroupContextResponse"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            SecurityGroupContextResponse.Jsii$Proxy that = (SecurityGroupContextResponse.Jsii$Proxy) o;

            if (!allowAllOutbound.equals(that.allowAllOutbound)) return false;
            return this.securityGroupId.equals(that.securityGroupId);
        }

        @Override
        public final int hashCode() {
            int result = this.allowAllOutbound.hashCode();
            result = 31 * result + (this.securityGroupId.hashCode());
            return result;
        }
    }
}
