package software.amazon.awscdk.cxapi;

/**
 * Asset manifest is a description of a set of assets which need to be built and published.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.cloudassembly.schema.*;
 * import software.amazon.awscdk.cxapi.*;
 * CloudAssembly cloudAssembly;
 * AssetManifestArtifact assetManifestArtifact = AssetManifestArtifact.Builder.create(cloudAssembly, "name")
 *         .type(ArtifactType.NONE)
 *         // the properties below are optional
 *         .dependencies(List.of("dependencies"))
 *         .displayName("displayName")
 *         .environment("environment")
 *         .metadata(Map.of(
 *                 "metadataKey", List.of(MetadataEntry.builder()
 *                         .type("type")
 *                         // the properties below are optional
 *                         .data("data")
 *                         .trace(List.of("trace"))
 *                         .build())))
 *         .properties(AwsCloudFormationStackProperties.builder()
 *                 .templateFile("templateFile")
 *                 // the properties below are optional
 *                 .assumeRoleArn("assumeRoleArn")
 *                 .assumeRoleExternalId("assumeRoleExternalId")
 *                 .bootstrapStackVersionSsmParameter("bootstrapStackVersionSsmParameter")
 *                 .cloudFormationExecutionRoleArn("cloudFormationExecutionRoleArn")
 *                 .lookupRole(BootstrapRole.builder()
 *                         .arn("arn")
 *                         // the properties below are optional
 *                         .assumeRoleExternalId("assumeRoleExternalId")
 *                         .bootstrapStackVersionSsmParameter("bootstrapStackVersionSsmParameter")
 *                         .requiresBootstrapStackVersion(123)
 *                         .build())
 *                 .parameters(Map.of(
 *                         "parametersKey", "parameters"))
 *                 .requiresBootstrapStackVersion(123)
 *                 .stackName("stackName")
 *                 .stackTemplateAssetObjectUrl("stackTemplateAssetObjectUrl")
 *                 .tags(Map.of(
 *                         "tagsKey", "tags"))
 *                 .terminationProtection(false)
 *                 .validateOnSynth(false)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.54.0 (build b1b977a)", date = "2022-03-01T02:28:55.563Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.cxapi.$Module.class, fqn = "@aws-cdk/cx-api.AssetManifestArtifact")
public class AssetManifestArtifact extends software.amazon.awscdk.cxapi.CloudArtifact {

    protected AssetManifestArtifact(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected AssetManifestArtifact(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param assembly This parameter is required.
     * @param name This parameter is required.
     * @param artifact This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public AssetManifestArtifact(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.cxapi.CloudAssembly assembly, final @org.jetbrains.annotations.NotNull java.lang.String name, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.cloudassembly.schema.ArtifactManifest artifact) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(assembly, "assembly is required"), java.util.Objects.requireNonNull(name, "name is required"), java.util.Objects.requireNonNull(artifact, "artifact is required") });
    }

    /**
     * The file name of the asset manifest.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getFile() {
        return software.amazon.jsii.Kernel.get(this, "file", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Version of bootstrap stack required to deploy this stack.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Number getRequiresBootstrapStackVersion() {
        return software.amazon.jsii.Kernel.get(this, "requiresBootstrapStackVersion", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * Name of SSM parameter with bootstrap stack version.
     * <p>
     * Default: - Discover SSM parameter by reading stack
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getBootstrapStackVersionSsmParameter() {
        return software.amazon.jsii.Kernel.get(this, "bootstrapStackVersionSsmParameter", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }
}
