/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.cxapi;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import software.amazon.awscdk.cxapi.;
import software.amazon.awscdk.cxapi.ArtifactManifest;
import software.amazon.awscdk.cxapi.ArtifactType;
import software.amazon.awscdk.cxapi.CloudArtifact;
import software.amazon.awscdk.cxapi.CloudAssembly;
import software.amazon.awscdk.cxapi.Environment;
import software.amazon.awscdk.cxapi.MetadataEntry;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;

@Jsii(module=.Module.class, fqn="@aws-cdk/cx-api.CloudFormationStackArtifact")
public class CloudFormationStackArtifact
extends CloudArtifact {
    protected CloudFormationStackArtifact(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CloudFormationStackArtifact(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CloudFormationStackArtifact(CloudAssembly assembly, String artifactId, ArtifactManifest artifact) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(assembly, "assembly is required"), Objects.requireNonNull(artifactId, "artifactId is required"), Objects.requireNonNull(artifact, "artifact is required")});
    }

    public List<Object> getAssets() {
        return Collections.unmodifiableList((List)this.jsiiGet("assets", List.class));
    }

    public String getDisplayName() {
        return (String)this.jsiiGet("displayName", String.class);
    }

    public Environment getEnvironment() {
        return (Environment)this.jsiiGet("environment", Environment.class);
    }

    @Deprecated
    public String getName() {
        return (String)this.jsiiGet("name", String.class);
    }

    public String getOriginalName() {
        return (String)this.jsiiGet("originalName", String.class);
    }

    public Map<String, String> getParameters() {
        return Collections.unmodifiableMap((Map)this.jsiiGet("parameters", Map.class));
    }

    public String getStackName() {
        return (String)this.jsiiGet("stackName", String.class);
    }

    public Object getTemplate() {
        return this.jsiiGet("template", Object.class);
    }

    public String getTemplateFile() {
        return (String)this.jsiiGet("templateFile", String.class);
    }

    public static final class Builder {
        private final CloudAssembly assembly;
        private final String artifactId;
        private final ArtifactManifest.Builder artifact;

        public static Builder create(CloudAssembly assembly, String artifactId) {
            return new Builder(assembly, artifactId);
        }

        private Builder(CloudAssembly assembly, String artifactId) {
            this.assembly = assembly;
            this.artifactId = artifactId;
            this.artifact = new ArtifactManifest.Builder();
        }

        public Builder type(ArtifactType type) {
            this.artifact.type(type);
            return this;
        }

        public Builder dependencies(List<String> dependencies) {
            this.artifact.dependencies(dependencies);
            return this;
        }

        public Builder environment(String environment) {
            this.artifact.environment(environment);
            return this;
        }

        public Builder metadata(Map<String, List<MetadataEntry>> metadata) {
            this.artifact.metadata(metadata);
            return this;
        }

        public Builder properties(Map<String, Object> properties) {
            this.artifact.properties(properties);
            return this;
        }

        public CloudFormationStackArtifact build() {
            return new CloudFormationStackArtifact(this.assembly, this.artifactId, this.artifact.build());
        }
    }
}

