package software.amazon.awscdk.cxapi;

/**
 * Query input for looking up a VPC.
 * <p>
 * EXPERIMENTAL
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.22.0 (build 14afdde)", date = "2020-02-26T08:38:30.226Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.cxapi.$Module.class, fqn = "@aws-cdk/cx-api.VpcContextQuery")
@software.amazon.jsii.Jsii.Proxy(VpcContextQuery.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface VpcContextQuery extends software.amazon.jsii.JsiiSerializable {

    /**
     * Filters to apply to the VPC.
     * <p>
     * Filter parameters are the same as passed to DescribeVpcs.
     * <p>
     * EXPERIMENTAL
     * <p>
     * @see https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeVpcs.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    java.util.Map<java.lang.String, java.lang.String> getFilter();

    /**
     * Query account.
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default java.lang.String getAccount() {
        return null;
    }

    /**
     * Query region.
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default java.lang.String getRegion() {
        return null;
    }

    /**
     * Whether to populate the subnetGroups field of the {@link VpcContextResponse}, which contains potentially asymmetric subnet groups.
     * <p>
     * Default: false
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default java.lang.Boolean getReturnAsymmetricSubnets() {
        return null;
    }

    /**
     * Optional tag for subnet group name.
     * <p>
     * If not provided, we'll look at the aws-cdk:subnet-name tag.
     * If the subnet does not have the specified tag,
     * we'll use its type as the name.
     * <p>
     * Default: 'aws-cdk:subnet-name'
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default java.lang.String getSubnetGroupNameTag() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link VpcContextQuery}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link VpcContextQuery}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder {
        private java.util.Map<java.lang.String, java.lang.String> filter;
        private java.lang.String account;
        private java.lang.String region;
        private java.lang.Boolean returnAsymmetricSubnets;
        private java.lang.String subnetGroupNameTag;

        /**
         * Sets the value of {@link VpcContextQuery#getFilter}
         * @param filter Filters to apply to the VPC. This parameter is required.
         *               Filter parameters are the same as passed to DescribeVpcs.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder filter(java.util.Map<java.lang.String, java.lang.String> filter) {
            this.filter = filter;
            return this;
        }

        /**
         * Sets the value of {@link VpcContextQuery#getAccount}
         * @param account Query account.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder account(java.lang.String account) {
            this.account = account;
            return this;
        }

        /**
         * Sets the value of {@link VpcContextQuery#getRegion}
         * @param region Query region.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder region(java.lang.String region) {
            this.region = region;
            return this;
        }

        /**
         * Sets the value of {@link VpcContextQuery#getReturnAsymmetricSubnets}
         * @param returnAsymmetricSubnets Whether to populate the subnetGroups field of the {@link VpcContextResponse}, which contains potentially asymmetric subnet groups.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder returnAsymmetricSubnets(java.lang.Boolean returnAsymmetricSubnets) {
            this.returnAsymmetricSubnets = returnAsymmetricSubnets;
            return this;
        }

        /**
         * Sets the value of {@link VpcContextQuery#getSubnetGroupNameTag}
         * @param subnetGroupNameTag Optional tag for subnet group name.
         *                           If not provided, we'll look at the aws-cdk:subnet-name tag.
         *                           If the subnet does not have the specified tag,
         *                           we'll use its type as the name.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder subnetGroupNameTag(java.lang.String subnetGroupNameTag) {
            this.subnetGroupNameTag = subnetGroupNameTag;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link VpcContextQuery}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public VpcContextQuery build() {
            return new Jsii$Proxy(filter, account, region, returnAsymmetricSubnets, subnetGroupNameTag);
        }
    }

    /**
     * An implementation for {@link VpcContextQuery}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements VpcContextQuery {
        private final java.util.Map<java.lang.String, java.lang.String> filter;
        private final java.lang.String account;
        private final java.lang.String region;
        private final java.lang.Boolean returnAsymmetricSubnets;
        private final java.lang.String subnetGroupNameTag;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.filter = this.jsiiGet("filter", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.account = this.jsiiGet("account", java.lang.String.class);
            this.region = this.jsiiGet("region", java.lang.String.class);
            this.returnAsymmetricSubnets = this.jsiiGet("returnAsymmetricSubnets", java.lang.Boolean.class);
            this.subnetGroupNameTag = this.jsiiGet("subnetGroupNameTag", java.lang.String.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final java.util.Map<java.lang.String, java.lang.String> filter, final java.lang.String account, final java.lang.String region, final java.lang.Boolean returnAsymmetricSubnets, final java.lang.String subnetGroupNameTag) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.filter = java.util.Objects.requireNonNull(filter, "filter is required");
            this.account = account;
            this.region = region;
            this.returnAsymmetricSubnets = returnAsymmetricSubnets;
            this.subnetGroupNameTag = subnetGroupNameTag;
        }

        @Override
        public java.util.Map<java.lang.String, java.lang.String> getFilter() {
            return this.filter;
        }

        @Override
        public java.lang.String getAccount() {
            return this.account;
        }

        @Override
        public java.lang.String getRegion() {
            return this.region;
        }

        @Override
        public java.lang.Boolean getReturnAsymmetricSubnets() {
            return this.returnAsymmetricSubnets;
        }

        @Override
        public java.lang.String getSubnetGroupNameTag() {
            return this.subnetGroupNameTag;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("filter", om.valueToTree(this.getFilter()));
            if (this.getAccount() != null) {
                data.set("account", om.valueToTree(this.getAccount()));
            }
            if (this.getRegion() != null) {
                data.set("region", om.valueToTree(this.getRegion()));
            }
            if (this.getReturnAsymmetricSubnets() != null) {
                data.set("returnAsymmetricSubnets", om.valueToTree(this.getReturnAsymmetricSubnets()));
            }
            if (this.getSubnetGroupNameTag() != null) {
                data.set("subnetGroupNameTag", om.valueToTree(this.getSubnetGroupNameTag()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/cx-api.VpcContextQuery"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            VpcContextQuery.Jsii$Proxy that = (VpcContextQuery.Jsii$Proxy) o;

            if (!filter.equals(that.filter)) return false;
            if (this.account != null ? !this.account.equals(that.account) : that.account != null) return false;
            if (this.region != null ? !this.region.equals(that.region) : that.region != null) return false;
            if (this.returnAsymmetricSubnets != null ? !this.returnAsymmetricSubnets.equals(that.returnAsymmetricSubnets) : that.returnAsymmetricSubnets != null) return false;
            return this.subnetGroupNameTag != null ? this.subnetGroupNameTag.equals(that.subnetGroupNameTag) : that.subnetGroupNameTag == null;
        }

        @Override
        public int hashCode() {
            int result = this.filter.hashCode();
            result = 31 * result + (this.account != null ? this.account.hashCode() : 0);
            result = 31 * result + (this.region != null ? this.region.hashCode() : 0);
            result = 31 * result + (this.returnAsymmetricSubnets != null ? this.returnAsymmetricSubnets.hashCode() : 0);
            result = 31 * result + (this.subnetGroupNameTag != null ? this.subnetGroupNameTag.hashCode() : 0);
            return result;
        }
    }
}
