package software.amazon.awscdk.cxapi;

/**
 * A group of subnets returned by the VPC provider.
 * <p>
 * The included subnets do NOT have to be symmetric!
 * <p>
 * EXPERIMENTAL
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.4.1 (build 0b09d7b)", date = "2020-04-28T11:03:57.214Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.cxapi.$Module.class, fqn = "@aws-cdk/cx-api.VpcSubnetGroup")
@software.amazon.jsii.Jsii.Proxy(VpcSubnetGroup.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface VpcSubnetGroup extends software.amazon.jsii.JsiiSerializable {

    /**
     * The name of the subnet group, determined by looking at the tags of of the subnets that belong to it.
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.lang.String getName();

    /**
     * The subnets that are part of this group.
     * <p>
     * There is no condition that the subnets have to be symmetric
     * in the group.
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.cxapi.VpcSubnet> getSubnets();

    /**
     * The type of the subnet group.
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.cxapi.VpcSubnetGroupType getType();

    /**
     * @return a {@link Builder} of {@link VpcSubnetGroup}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link VpcSubnetGroup}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder {
        private java.lang.String name;
        private java.util.List<software.amazon.awscdk.cxapi.VpcSubnet> subnets;
        private software.amazon.awscdk.cxapi.VpcSubnetGroupType type;

        /**
         * Sets the value of {@link VpcSubnetGroup#getName}
         * @param name The name of the subnet group, determined by looking at the tags of of the subnets that belong to it. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link VpcSubnetGroup#getSubnets}
         * @param subnets The subnets that are part of this group. This parameter is required.
         *                There is no condition that the subnets have to be symmetric
         *                in the group.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder subnets(java.util.List<software.amazon.awscdk.cxapi.VpcSubnet> subnets) {
            this.subnets = subnets;
            return this;
        }

        /**
         * Sets the value of {@link VpcSubnetGroup#getType}
         * @param type The type of the subnet group. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder type(software.amazon.awscdk.cxapi.VpcSubnetGroupType type) {
            this.type = type;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link VpcSubnetGroup}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public VpcSubnetGroup build() {
            return new Jsii$Proxy(name, subnets, type);
        }
    }

    /**
     * An implementation for {@link VpcSubnetGroup}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements VpcSubnetGroup {
        private final java.lang.String name;
        private final java.util.List<software.amazon.awscdk.cxapi.VpcSubnet> subnets;
        private final software.amazon.awscdk.cxapi.VpcSubnetGroupType type;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.name = this.jsiiGet("name", java.lang.String.class);
            this.subnets = this.jsiiGet("subnets", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.cxapi.VpcSubnet.class)));
            this.type = this.jsiiGet("type", software.amazon.awscdk.cxapi.VpcSubnetGroupType.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final java.lang.String name, final java.util.List<software.amazon.awscdk.cxapi.VpcSubnet> subnets, final software.amazon.awscdk.cxapi.VpcSubnetGroupType type) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.name = java.util.Objects.requireNonNull(name, "name is required");
            this.subnets = java.util.Objects.requireNonNull(subnets, "subnets is required");
            this.type = java.util.Objects.requireNonNull(type, "type is required");
        }

        @Override
        public java.lang.String getName() {
            return this.name;
        }

        @Override
        public java.util.List<software.amazon.awscdk.cxapi.VpcSubnet> getSubnets() {
            return this.subnets;
        }

        @Override
        public software.amazon.awscdk.cxapi.VpcSubnetGroupType getType() {
            return this.type;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("name", om.valueToTree(this.getName()));
            data.set("subnets", om.valueToTree(this.getSubnets()));
            data.set("type", om.valueToTree(this.getType()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/cx-api.VpcSubnetGroup"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            VpcSubnetGroup.Jsii$Proxy that = (VpcSubnetGroup.Jsii$Proxy) o;

            if (!name.equals(that.name)) return false;
            if (!subnets.equals(that.subnets)) return false;
            return this.type.equals(that.type);
        }

        @Override
        public int hashCode() {
            int result = this.name.hashCode();
            result = 31 * result + (this.subnets.hashCode());
            result = 31 * result + (this.type.hashCode());
            return result;
        }
    }
}
