/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.cxapi;

import java.util.List;
import java.util.Map;
import software.amazon.awscdk.cxapi.ArtifactManifest;
import software.amazon.awscdk.cxapi.AssemblyManifest;
import software.amazon.awscdk.cxapi.MissingContext;
import software.amazon.awscdk.cxapi.RuntimeInfo;
import software.amazon.jsii.JsiiSerializable;

public interface AssemblyManifest
extends JsiiSerializable {
    public String getVersion();

    public Map<String, ArtifactManifest> getArtifacts();

    public List<MissingContext> getMissing();

    public RuntimeInfo getRuntime();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String version;
        private Map<String, ArtifactManifest> artifacts;
        private List<MissingContext> missing;
        private RuntimeInfo runtime;

        public Builder version(String version) {
            this.version = version;
            return this;
        }

        public Builder artifacts(Map<String, ArtifactManifest> artifacts) {
            this.artifacts = artifacts;
            return this;
        }

        public Builder missing(List<MissingContext> missing) {
            this.missing = missing;
            return this;
        }

        public Builder runtime(RuntimeInfo runtime) {
            this.runtime = runtime;
            return this;
        }

        public AssemblyManifest build() {
            return new Jsii.Proxy(this.version, this.artifacts, this.missing, this.runtime, null);
        }
    }
}

