package software.amazon.awscdk.cxapi;

/**
 * Can be used to build a cloud assembly.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.28.0 (build 1801f4f)", date = "2021-04-13T16:59:11.659Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.cxapi.$Module.class, fqn = "@aws-cdk/cx-api.CloudAssemblyBuilder")
public class CloudAssemblyBuilder extends software.amazon.jsii.JsiiObject {

    protected CloudAssemblyBuilder(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CloudAssemblyBuilder(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * Initializes a cloud assembly builder.
     * <p>
     * @param outdir The output directory, uses temporary directory if undefined.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CloudAssemblyBuilder(final @org.jetbrains.annotations.Nullable java.lang.String outdir, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.cxapi.CloudAssemblyBuilderProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { outdir, props });
    }

    /**
     * Initializes a cloud assembly builder.
     * <p>
     * @param outdir The output directory, uses temporary directory if undefined.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CloudAssemblyBuilder(final @org.jetbrains.annotations.Nullable java.lang.String outdir) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { outdir });
    }

    /**
     * Initializes a cloud assembly builder.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CloudAssemblyBuilder() {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this);
    }

    /**
     * Adds an artifact into the cloud assembly.
     * <p>
     * @param id The ID of the artifact. This parameter is required.
     * @param manifest The artifact manifest. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addArtifact(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.cloudassembly.schema.ArtifactManifest manifest) {
        software.amazon.jsii.Kernel.call(this, "addArtifact", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(manifest, "manifest is required") });
    }

    /**
     * Reports that some context is missing in order for this cloud assembly to be fully synthesized.
     * <p>
     * @param missing Missing context information. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addMissing(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.cloudassembly.schema.MissingContext missing) {
        software.amazon.jsii.Kernel.call(this, "addMissing", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(missing, "missing is required") });
    }

    /**
     * Finalizes the cloud assembly into the output directory returns a `CloudAssembly` object that can be used to inspect the assembly.
     * <p>
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.cxapi.CloudAssembly buildAssembly(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.cxapi.AssemblyBuildOptions options) {
        return software.amazon.jsii.Kernel.call(this, "buildAssembly", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.cxapi.CloudAssembly.class), new Object[] { options });
    }

    /**
     * Finalizes the cloud assembly into the output directory returns a `CloudAssembly` object that can be used to inspect the assembly.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.cxapi.CloudAssembly buildAssembly() {
        return software.amazon.jsii.Kernel.call(this, "buildAssembly", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.cxapi.CloudAssembly.class));
    }

    /**
     * Creates a nested cloud assembly.
     * <p>
     * @param artifactId This parameter is required.
     * @param displayName This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.cxapi.CloudAssemblyBuilder createNestedAssembly(final @org.jetbrains.annotations.NotNull java.lang.String artifactId, final @org.jetbrains.annotations.NotNull java.lang.String displayName) {
        return software.amazon.jsii.Kernel.call(this, "createNestedAssembly", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.cxapi.CloudAssemblyBuilder.class), new Object[] { java.util.Objects.requireNonNull(artifactId, "artifactId is required"), java.util.Objects.requireNonNull(displayName, "displayName is required") });
    }

    /**
     * The directory where assets of this Cloud Assembly should be stored.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAssetOutdir() {
        return software.amazon.jsii.Kernel.get(this, "assetOutdir", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The root directory of the resulting cloud assembly.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getOutdir() {
        return software.amazon.jsii.Kernel.get(this, "outdir", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.cxapi.CloudAssemblyBuilder}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.cxapi.CloudAssemblyBuilder> {
        /**
         * @return a new instance of {@link Builder}.
         * @param outdir The output directory, uses temporary directory if undefined.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final java.lang.String outdir) {
            return new Builder(outdir);
        }
        /**
         * @return a new instance of {@link Builder}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create() {
            return new Builder(null);
        }

        private final java.lang.String outdir;
        private software.amazon.awscdk.cxapi.CloudAssemblyBuilderProps.Builder props;

        private Builder(final java.lang.String outdir) {
            this.outdir = outdir;
        }

        /**
         * Use the given asset output directory.
         * <p>
         * Default: - Same as the manifest outdir
         * <p>
         * @return {@code this}
         * @param assetOutdir Use the given asset output directory. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder assetOutdir(final java.lang.String assetOutdir) {
            this.props().assetOutdir(assetOutdir);
            return this;
        }

        /**
         * If this builder is for a nested assembly, the parent assembly builder.
         * <p>
         * Default: - This is a root assembly
         * <p>
         * @return {@code this}
         * @param parentBuilder If this builder is for a nested assembly, the parent assembly builder. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder parentBuilder(final software.amazon.awscdk.cxapi.CloudAssemblyBuilder parentBuilder) {
            this.props().parentBuilder(parentBuilder);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.cxapi.CloudAssemblyBuilder}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.cxapi.CloudAssemblyBuilder build() {
            return new software.amazon.awscdk.cxapi.CloudAssemblyBuilder(
                this.outdir,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.cxapi.CloudAssemblyBuilderProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.cxapi.CloudAssemblyBuilderProps.Builder();
            }
            return this.props;
        }
    }
}
