package software.amazon.awscdk.cxapi;

/**
 * Properties of a discovered load balancer.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.cxapi.*;
 * LoadBalancerContextResponse loadBalancerContextResponse = LoadBalancerContextResponse.builder()
 *         .ipAddressType(LoadBalancerIpAddressType.IPV4)
 *         .loadBalancerArn("loadBalancerArn")
 *         .loadBalancerCanonicalHostedZoneId("loadBalancerCanonicalHostedZoneId")
 *         .loadBalancerDnsName("loadBalancerDnsName")
 *         .securityGroupIds(List.of("securityGroupIds"))
 *         .vpcId("vpcId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.89.0 (build 2f74b3e)", date = "2023-10-06T19:22:11.246Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.cxapi.$Module.class, fqn = "@aws-cdk/cx-api.LoadBalancerContextResponse")
@software.amazon.jsii.Jsii.Proxy(LoadBalancerContextResponse.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface LoadBalancerContextResponse extends software.amazon.jsii.JsiiSerializable {

    /**
     * Type of IP address.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.cxapi.LoadBalancerIpAddressType getIpAddressType();

    /**
     * The ARN of the load balancer.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getLoadBalancerArn();

    /**
     * The hosted zone ID of the load balancer's name.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getLoadBalancerCanonicalHostedZoneId();

    /**
     * Load balancer's DNS name.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getLoadBalancerDnsName();

    /**
     * Load balancer's security groups.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getSecurityGroupIds();

    /**
     * Load balancer's VPC.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getVpcId();

    /**
     * @return a {@link Builder} of {@link LoadBalancerContextResponse}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link LoadBalancerContextResponse}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<LoadBalancerContextResponse> {
        software.amazon.awscdk.cxapi.LoadBalancerIpAddressType ipAddressType;
        java.lang.String loadBalancerArn;
        java.lang.String loadBalancerCanonicalHostedZoneId;
        java.lang.String loadBalancerDnsName;
        java.util.List<java.lang.String> securityGroupIds;
        java.lang.String vpcId;

        /**
         * Sets the value of {@link LoadBalancerContextResponse#getIpAddressType}
         * @param ipAddressType Type of IP address. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ipAddressType(software.amazon.awscdk.cxapi.LoadBalancerIpAddressType ipAddressType) {
            this.ipAddressType = ipAddressType;
            return this;
        }

        /**
         * Sets the value of {@link LoadBalancerContextResponse#getLoadBalancerArn}
         * @param loadBalancerArn The ARN of the load balancer. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder loadBalancerArn(java.lang.String loadBalancerArn) {
            this.loadBalancerArn = loadBalancerArn;
            return this;
        }

        /**
         * Sets the value of {@link LoadBalancerContextResponse#getLoadBalancerCanonicalHostedZoneId}
         * @param loadBalancerCanonicalHostedZoneId The hosted zone ID of the load balancer's name. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder loadBalancerCanonicalHostedZoneId(java.lang.String loadBalancerCanonicalHostedZoneId) {
            this.loadBalancerCanonicalHostedZoneId = loadBalancerCanonicalHostedZoneId;
            return this;
        }

        /**
         * Sets the value of {@link LoadBalancerContextResponse#getLoadBalancerDnsName}
         * @param loadBalancerDnsName Load balancer's DNS name. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder loadBalancerDnsName(java.lang.String loadBalancerDnsName) {
            this.loadBalancerDnsName = loadBalancerDnsName;
            return this;
        }

        /**
         * Sets the value of {@link LoadBalancerContextResponse#getSecurityGroupIds}
         * @param securityGroupIds Load balancer's security groups. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder securityGroupIds(java.util.List<java.lang.String> securityGroupIds) {
            this.securityGroupIds = securityGroupIds;
            return this;
        }

        /**
         * Sets the value of {@link LoadBalancerContextResponse#getVpcId}
         * @param vpcId Load balancer's VPC. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcId(java.lang.String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link LoadBalancerContextResponse}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public LoadBalancerContextResponse build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link LoadBalancerContextResponse}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LoadBalancerContextResponse {
        private final software.amazon.awscdk.cxapi.LoadBalancerIpAddressType ipAddressType;
        private final java.lang.String loadBalancerArn;
        private final java.lang.String loadBalancerCanonicalHostedZoneId;
        private final java.lang.String loadBalancerDnsName;
        private final java.util.List<java.lang.String> securityGroupIds;
        private final java.lang.String vpcId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.ipAddressType = software.amazon.jsii.Kernel.get(this, "ipAddressType", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.cxapi.LoadBalancerIpAddressType.class));
            this.loadBalancerArn = software.amazon.jsii.Kernel.get(this, "loadBalancerArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.loadBalancerCanonicalHostedZoneId = software.amazon.jsii.Kernel.get(this, "loadBalancerCanonicalHostedZoneId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.loadBalancerDnsName = software.amazon.jsii.Kernel.get(this, "loadBalancerDnsName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.securityGroupIds = software.amazon.jsii.Kernel.get(this, "securityGroupIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.vpcId = software.amazon.jsii.Kernel.get(this, "vpcId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.ipAddressType = java.util.Objects.requireNonNull(builder.ipAddressType, "ipAddressType is required");
            this.loadBalancerArn = java.util.Objects.requireNonNull(builder.loadBalancerArn, "loadBalancerArn is required");
            this.loadBalancerCanonicalHostedZoneId = java.util.Objects.requireNonNull(builder.loadBalancerCanonicalHostedZoneId, "loadBalancerCanonicalHostedZoneId is required");
            this.loadBalancerDnsName = java.util.Objects.requireNonNull(builder.loadBalancerDnsName, "loadBalancerDnsName is required");
            this.securityGroupIds = java.util.Objects.requireNonNull(builder.securityGroupIds, "securityGroupIds is required");
            this.vpcId = java.util.Objects.requireNonNull(builder.vpcId, "vpcId is required");
        }

        @Override
        public final software.amazon.awscdk.cxapi.LoadBalancerIpAddressType getIpAddressType() {
            return this.ipAddressType;
        }

        @Override
        public final java.lang.String getLoadBalancerArn() {
            return this.loadBalancerArn;
        }

        @Override
        public final java.lang.String getLoadBalancerCanonicalHostedZoneId() {
            return this.loadBalancerCanonicalHostedZoneId;
        }

        @Override
        public final java.lang.String getLoadBalancerDnsName() {
            return this.loadBalancerDnsName;
        }

        @Override
        public final java.util.List<java.lang.String> getSecurityGroupIds() {
            return this.securityGroupIds;
        }

        @Override
        public final java.lang.String getVpcId() {
            return this.vpcId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("ipAddressType", om.valueToTree(this.getIpAddressType()));
            data.set("loadBalancerArn", om.valueToTree(this.getLoadBalancerArn()));
            data.set("loadBalancerCanonicalHostedZoneId", om.valueToTree(this.getLoadBalancerCanonicalHostedZoneId()));
            data.set("loadBalancerDnsName", om.valueToTree(this.getLoadBalancerDnsName()));
            data.set("securityGroupIds", om.valueToTree(this.getSecurityGroupIds()));
            data.set("vpcId", om.valueToTree(this.getVpcId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/cx-api.LoadBalancerContextResponse"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            LoadBalancerContextResponse.Jsii$Proxy that = (LoadBalancerContextResponse.Jsii$Proxy) o;

            if (!ipAddressType.equals(that.ipAddressType)) return false;
            if (!loadBalancerArn.equals(that.loadBalancerArn)) return false;
            if (!loadBalancerCanonicalHostedZoneId.equals(that.loadBalancerCanonicalHostedZoneId)) return false;
            if (!loadBalancerDnsName.equals(that.loadBalancerDnsName)) return false;
            if (!securityGroupIds.equals(that.securityGroupIds)) return false;
            return this.vpcId.equals(that.vpcId);
        }

        @Override
        public final int hashCode() {
            int result = this.ipAddressType.hashCode();
            result = 31 * result + (this.loadBalancerArn.hashCode());
            result = 31 * result + (this.loadBalancerCanonicalHostedZoneId.hashCode());
            result = 31 * result + (this.loadBalancerDnsName.hashCode());
            result = 31 * result + (this.securityGroupIds.hashCode());
            result = 31 * result + (this.vpcId.hashCode());
            return result;
        }
    }
}
