package software.amazon.awscdk.cxapi;

/**
 * A subnet representation that the VPC provider uses.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.cxapi.*;
 * VpcSubnet vpcSubnet = VpcSubnet.builder()
 *         .availabilityZone("availabilityZone")
 *         .routeTableId("routeTableId")
 *         .subnetId("subnetId")
 *         // the properties below are optional
 *         .cidr("cidr")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.89.0 (build 2f74b3e)", date = "2023-10-06T19:22:11.250Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.cxapi.$Module.class, fqn = "@aws-cdk/cx-api.VpcSubnet")
@software.amazon.jsii.Jsii.Proxy(VpcSubnet.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface VpcSubnet extends software.amazon.jsii.JsiiSerializable {

    /**
     * The code of the availability zone this subnet is in (for example, 'us-west-2a').
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getAvailabilityZone();

    /**
     * The identifier of the route table for this subnet.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getRouteTableId();

    /**
     * The identifier of the subnet.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getSubnetId();

    /**
     * CIDR range of the subnet.
     * <p>
     * Default: - CIDR information not available
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getCidr() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link VpcSubnet}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link VpcSubnet}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<VpcSubnet> {
        java.lang.String availabilityZone;
        java.lang.String routeTableId;
        java.lang.String subnetId;
        java.lang.String cidr;

        /**
         * Sets the value of {@link VpcSubnet#getAvailabilityZone}
         * @param availabilityZone The code of the availability zone this subnet is in (for example, 'us-west-2a'). This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder availabilityZone(java.lang.String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        /**
         * Sets the value of {@link VpcSubnet#getRouteTableId}
         * @param routeTableId The identifier of the route table for this subnet. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder routeTableId(java.lang.String routeTableId) {
            this.routeTableId = routeTableId;
            return this;
        }

        /**
         * Sets the value of {@link VpcSubnet#getSubnetId}
         * @param subnetId The identifier of the subnet. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subnetId(java.lang.String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        /**
         * Sets the value of {@link VpcSubnet#getCidr}
         * @param cidr CIDR range of the subnet.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cidr(java.lang.String cidr) {
            this.cidr = cidr;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link VpcSubnet}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public VpcSubnet build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link VpcSubnet}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements VpcSubnet {
        private final java.lang.String availabilityZone;
        private final java.lang.String routeTableId;
        private final java.lang.String subnetId;
        private final java.lang.String cidr;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.availabilityZone = software.amazon.jsii.Kernel.get(this, "availabilityZone", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.routeTableId = software.amazon.jsii.Kernel.get(this, "routeTableId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.subnetId = software.amazon.jsii.Kernel.get(this, "subnetId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.cidr = software.amazon.jsii.Kernel.get(this, "cidr", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.availabilityZone = java.util.Objects.requireNonNull(builder.availabilityZone, "availabilityZone is required");
            this.routeTableId = java.util.Objects.requireNonNull(builder.routeTableId, "routeTableId is required");
            this.subnetId = java.util.Objects.requireNonNull(builder.subnetId, "subnetId is required");
            this.cidr = builder.cidr;
        }

        @Override
        public final java.lang.String getAvailabilityZone() {
            return this.availabilityZone;
        }

        @Override
        public final java.lang.String getRouteTableId() {
            return this.routeTableId;
        }

        @Override
        public final java.lang.String getSubnetId() {
            return this.subnetId;
        }

        @Override
        public final java.lang.String getCidr() {
            return this.cidr;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("availabilityZone", om.valueToTree(this.getAvailabilityZone()));
            data.set("routeTableId", om.valueToTree(this.getRouteTableId()));
            data.set("subnetId", om.valueToTree(this.getSubnetId()));
            if (this.getCidr() != null) {
                data.set("cidr", om.valueToTree(this.getCidr()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/cx-api.VpcSubnet"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            VpcSubnet.Jsii$Proxy that = (VpcSubnet.Jsii$Proxy) o;

            if (!availabilityZone.equals(that.availabilityZone)) return false;
            if (!routeTableId.equals(that.routeTableId)) return false;
            if (!subnetId.equals(that.subnetId)) return false;
            return this.cidr != null ? this.cidr.equals(that.cidr) : that.cidr == null;
        }

        @Override
        public final int hashCode() {
            int result = this.availabilityZone.hashCode();
            result = 31 * result + (this.routeTableId.hashCode());
            result = 31 * result + (this.subnetId.hashCode());
            result = 31 * result + (this.cidr != null ? this.cidr.hashCode() : 0);
            return result;
        }
    }
}
