package software.amazon.awscdk.cxapi;

/**
 * Represents a deployable cloud application.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.cxapi.*;
 * CloudAssembly cloudAssembly = CloudAssembly.Builder.create("directory")
 *         .skipEnumCheck(false)
 *         .skipVersionCheck(false)
 *         .topoSort(false)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.91.0 (build 1b1f239)", date = "2023-11-21T18:10:27.278Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.cxapi.$Module.class, fqn = "@aws-cdk/cx-api.CloudAssembly")
public class CloudAssembly extends software.amazon.jsii.JsiiObject {

    protected CloudAssembly(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CloudAssembly(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * Reads a cloud assembly from the specified directory.
     * <p>
     * @param directory The root directory of the assembly. This parameter is required.
     * @param loadOptions
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CloudAssembly(final @org.jetbrains.annotations.NotNull java.lang.String directory, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.cloudassembly.schema.LoadManifestOptions loadOptions) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(directory, "directory is required"), loadOptions });
    }

    /**
     * Reads a cloud assembly from the specified directory.
     * <p>
     * @param directory The root directory of the assembly. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CloudAssembly(final @org.jetbrains.annotations.NotNull java.lang.String directory) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(directory, "directory is required") });
    }

    /**
     * Returns a nested assembly.
     * <p>
     * @param artifactId The artifact ID of the nested assembly. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.cxapi.CloudAssembly getNestedAssembly(final @org.jetbrains.annotations.NotNull java.lang.String artifactId) {
        return software.amazon.jsii.Kernel.call(this, "getNestedAssembly", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.cxapi.CloudAssembly.class), new Object[] { java.util.Objects.requireNonNull(artifactId, "artifactId is required") });
    }

    /**
     * Returns a nested assembly artifact.
     * <p>
     * @param artifactId The artifact ID of the nested assembly. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.cxapi.NestedCloudAssemblyArtifact getNestedAssemblyArtifact(final @org.jetbrains.annotations.NotNull java.lang.String artifactId) {
        return software.amazon.jsii.Kernel.call(this, "getNestedAssemblyArtifact", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.cxapi.NestedCloudAssemblyArtifact.class), new Object[] { java.util.Objects.requireNonNull(artifactId, "artifactId is required") });
    }

    /**
     * (deprecated) Returns a CloudFormation stack artifact by name from this assembly.
     * <p>
     * @deprecated renamed to <code>getStackByName</code> (or <code>getStackArtifact(id)</code>)
     * @param stackName This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.cxapi.CloudFormationStackArtifact getStack(final @org.jetbrains.annotations.NotNull java.lang.String stackName) {
        return software.amazon.jsii.Kernel.call(this, "getStack", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.cxapi.CloudFormationStackArtifact.class), new Object[] { java.util.Objects.requireNonNull(stackName, "stackName is required") });
    }

    /**
     * Returns a CloudFormation stack artifact from this assembly.
     * <p>
     * @return a <code>CloudFormationStackArtifact</code> object.
     * @param artifactId the artifact id of the stack (can be obtained through <code>stack.artifactId</code>). This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.cxapi.CloudFormationStackArtifact getStackArtifact(final @org.jetbrains.annotations.NotNull java.lang.String artifactId) {
        return software.amazon.jsii.Kernel.call(this, "getStackArtifact", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.cxapi.CloudFormationStackArtifact.class), new Object[] { java.util.Objects.requireNonNull(artifactId, "artifactId is required") });
    }

    /**
     * Returns a CloudFormation stack artifact from this assembly.
     * <p>
     * Will only search the current assembly.
     * <p>
     * @return a <code>CloudFormationStackArtifact</code> object.
     * @param stackName the name of the CloudFormation stack. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.cxapi.CloudFormationStackArtifact getStackByName(final @org.jetbrains.annotations.NotNull java.lang.String stackName) {
        return software.amazon.jsii.Kernel.call(this, "getStackByName", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.cxapi.CloudFormationStackArtifact.class), new Object[] { java.util.Objects.requireNonNull(stackName, "stackName is required") });
    }

    /**
     * Returns the tree metadata artifact from this assembly.
     * <p>
     * @return a <code>TreeCloudArtifact</code> object if there is one defined in the manifest, <code>undefined</code> otherwise.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.cxapi.TreeCloudArtifact tree() {
        return software.amazon.jsii.Kernel.call(this, "tree", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.cxapi.TreeCloudArtifact.class));
    }

    /**
     * Attempts to find an artifact with a specific identity.
     * <p>
     * @return A <code>CloudArtifact</code> object or <code>undefined</code> if the artifact does not exist in this assembly.
     * @param id The artifact ID. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.cxapi.CloudArtifact tryGetArtifact(final @org.jetbrains.annotations.NotNull java.lang.String id) {
        return software.amazon.jsii.Kernel.call(this, "tryGetArtifact", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.cxapi.CloudArtifact.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * All artifacts included in this assembly.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.cxapi.CloudArtifact> getArtifacts() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "artifacts", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.cxapi.CloudArtifact.class))));
    }

    /**
     * The root directory of the cloud assembly.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getDirectory() {
        return software.amazon.jsii.Kernel.get(this, "directory", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The raw assembly manifest.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.cloudassembly.schema.AssemblyManifest getManifest() {
        return software.amazon.jsii.Kernel.get(this, "manifest", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.cloudassembly.schema.AssemblyManifest.class));
    }

    /**
     * The nested assembly artifacts in this assembly.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.cxapi.NestedCloudAssemblyArtifact> getNestedAssemblies() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "nestedAssemblies", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.cxapi.NestedCloudAssemblyArtifact.class))));
    }

    /**
     * Runtime information such as module versions used to synthesize this assembly.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.cloudassembly.schema.RuntimeInfo getRuntime() {
        return software.amazon.jsii.Kernel.get(this, "runtime", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.cloudassembly.schema.RuntimeInfo.class));
    }

    /**
     * @return all the CloudFormation stack artifacts that are included in this assembly.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.cxapi.CloudFormationStackArtifact> getStacks() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "stacks", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.cxapi.CloudFormationStackArtifact.class))));
    }

    /**
     * Returns all the stacks, including the ones in nested assemblies.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.cxapi.CloudFormationStackArtifact> getStacksRecursively() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "stacksRecursively", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.cxapi.CloudFormationStackArtifact.class))));
    }

    /**
     * The schema version of the assembly manifest.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getVersion() {
        return software.amazon.jsii.Kernel.get(this, "version", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }
}
