package software.amazon.awscdk.cxapi;

/**
 * Represents an artifact within a cloud assembly.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.cloudassembly.schema.*;
 * import software.amazon.awscdk.cxapi.*;
 * CloudAssembly cloudAssembly;
 * CloudArtifact cloudArtifact = CloudArtifact.fromManifest(cloudAssembly, "MyCloudArtifact", ArtifactManifest.builder()
 *         .type(ArtifactType.NONE)
 *         // the properties below are optional
 *         .dependencies(List.of("dependencies"))
 *         .displayName("displayName")
 *         .environment("environment")
 *         .metadata(Map.of(
 *                 "metadataKey", List.of(MetadataEntry.builder()
 *                         .type("type")
 *                         // the properties below are optional
 *                         .data("data")
 *                         .trace(List.of("trace"))
 *                         .build())))
 *         .properties(AwsCloudFormationStackProperties.builder()
 *                 .templateFile("templateFile")
 *                 // the properties below are optional
 *                 .assumeRoleArn("assumeRoleArn")
 *                 .assumeRoleExternalId("assumeRoleExternalId")
 *                 .bootstrapStackVersionSsmParameter("bootstrapStackVersionSsmParameter")
 *                 .cloudFormationExecutionRoleArn("cloudFormationExecutionRoleArn")
 *                 .lookupRole(BootstrapRole.builder()
 *                         .arn("arn")
 *                         // the properties below are optional
 *                         .assumeRoleExternalId("assumeRoleExternalId")
 *                         .bootstrapStackVersionSsmParameter("bootstrapStackVersionSsmParameter")
 *                         .requiresBootstrapStackVersion(123)
 *                         .build())
 *                 .parameters(Map.of(
 *                         "parametersKey", "parameters"))
 *                 .requiresBootstrapStackVersion(123)
 *                 .stackName("stackName")
 *                 .stackTemplateAssetObjectUrl("stackTemplateAssetObjectUrl")
 *                 .tags(Map.of(
 *                         "tagsKey", "tags"))
 *                 .terminationProtection(false)
 *                 .validateOnSynth(false)
 *                 .build())
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.92.0 (build db7f27d)", date = "2023-12-01T19:06:41.057Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.cxapi.$Module.class, fqn = "@aws-cdk/cx-api.CloudArtifact")
public class CloudArtifact extends software.amazon.jsii.JsiiObject {

    protected CloudArtifact(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CloudArtifact(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param assembly This parameter is required.
     * @param id This parameter is required.
     * @param manifest This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected CloudArtifact(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.cxapi.CloudAssembly assembly, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.cloudassembly.schema.ArtifactManifest manifest) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(assembly, "assembly is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(manifest, "manifest is required") });
    }

    /**
     * Returns a subclass of <code>CloudArtifact</code> based on the artifact type defined in the artifact manifest.
     * <p>
     * @return the <code>CloudArtifact</code> that matches the artifact type or <code>undefined</code> if it's an artifact type that is unrecognized by this module.
     * @param assembly The cloud assembly from which to load the artifact. This parameter is required.
     * @param id The artifact ID. This parameter is required.
     * @param artifact The artifact manifest. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.Nullable software.amazon.awscdk.cxapi.CloudArtifact fromManifest(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.cxapi.CloudAssembly assembly, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.cloudassembly.schema.ArtifactManifest artifact) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.cxapi.CloudArtifact.class, "fromManifest", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.cxapi.CloudArtifact.class), new Object[] { java.util.Objects.requireNonNull(assembly, "assembly is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(artifact, "artifact is required") });
    }

    /**
     * @return all the metadata entries of a specific type in this artifact.
     * @param type This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.cxapi.MetadataEntryResult> findMetadataByType(final @org.jetbrains.annotations.NotNull java.lang.String type) {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.call(this, "findMetadataByType", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.cxapi.MetadataEntryResult.class)), new Object[] { java.util.Objects.requireNonNull(type, "type is required") }));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.cxapi.CloudAssembly getAssembly() {
        return software.amazon.jsii.Kernel.get(this, "assembly", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.cxapi.CloudAssembly.class));
    }

    /**
     * Returns all the artifacts that this artifact depends on.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.cxapi.CloudArtifact> getDependencies() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "dependencies", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.cxapi.CloudArtifact.class))));
    }

    /**
     * An identifier that shows where this artifact is located in the tree of nested assemblies, based on their manifests.
     * <p>
     * Defaults to the normal
     * id. Should only be used in user interfaces.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getHierarchicalId() {
        return software.amazon.jsii.Kernel.get(this, "hierarchicalId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getId() {
        return software.amazon.jsii.Kernel.get(this, "id", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The artifact's manifest.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.cloudassembly.schema.ArtifactManifest getManifest() {
        return software.amazon.jsii.Kernel.get(this, "manifest", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.cloudassembly.schema.ArtifactManifest.class));
    }

    /**
     * The set of messages extracted from the artifact's metadata.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.cxapi.SynthesisMessage> getMessages() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "messages", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.cxapi.SynthesisMessage.class))));
    }
}
