package software.amazon.awscdk.cxapi;

/**
 * Asset manifest is a description of a set of assets which need to be built and published.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.cloudassembly.schema.*;
 * import software.amazon.awscdk.cxapi.*;
 * CloudAssembly cloudAssembly;
 * NestedCloudAssemblyArtifact nestedCloudAssemblyArtifact = NestedCloudAssemblyArtifact.Builder.create(cloudAssembly, "name")
 *         .type(ArtifactType.NONE)
 *         // the properties below are optional
 *         .dependencies(List.of("dependencies"))
 *         .displayName("displayName")
 *         .environment("environment")
 *         .metadata(Map.of(
 *                 "metadataKey", List.of(MetadataEntry.builder()
 *                         .type("type")
 *                         // the properties below are optional
 *                         .data("data")
 *                         .trace(List.of("trace"))
 *                         .build())))
 *         .properties(AwsCloudFormationStackProperties.builder()
 *                 .templateFile("templateFile")
 *                 // the properties below are optional
 *                 .assumeRoleArn("assumeRoleArn")
 *                 .assumeRoleExternalId("assumeRoleExternalId")
 *                 .bootstrapStackVersionSsmParameter("bootstrapStackVersionSsmParameter")
 *                 .cloudFormationExecutionRoleArn("cloudFormationExecutionRoleArn")
 *                 .lookupRole(BootstrapRole.builder()
 *                         .arn("arn")
 *                         // the properties below are optional
 *                         .assumeRoleExternalId("assumeRoleExternalId")
 *                         .bootstrapStackVersionSsmParameter("bootstrapStackVersionSsmParameter")
 *                         .requiresBootstrapStackVersion(123)
 *                         .build())
 *                 .parameters(Map.of(
 *                         "parametersKey", "parameters"))
 *                 .requiresBootstrapStackVersion(123)
 *                 .stackName("stackName")
 *                 .stackTemplateAssetObjectUrl("stackTemplateAssetObjectUrl")
 *                 .tags(Map.of(
 *                         "tagsKey", "tags"))
 *                 .terminationProtection(false)
 *                 .validateOnSynth(false)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.94.0 (build b380f01)", date = "2024-01-13T02:49:34.498Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.cxapi.$Module.class, fqn = "@aws-cdk/cx-api.NestedCloudAssemblyArtifact")
public class NestedCloudAssemblyArtifact extends software.amazon.awscdk.cxapi.CloudArtifact {

    protected NestedCloudAssemblyArtifact(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected NestedCloudAssemblyArtifact(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param assembly This parameter is required.
     * @param name This parameter is required.
     * @param artifact This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public NestedCloudAssemblyArtifact(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.cxapi.CloudAssembly assembly, final @org.jetbrains.annotations.NotNull java.lang.String name, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.cloudassembly.schema.ArtifactManifest artifact) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(assembly, "assembly is required"), java.util.Objects.requireNonNull(name, "name is required"), java.util.Objects.requireNonNull(artifact, "artifact is required") });
    }

    /**
     * Checks if <code>art</code> is an instance of this class.
     * <p>
     * Use this method instead of <code>instanceof</code> to properly detect <code>NestedCloudAssemblyArtifact</code>
     * instances, even when the construct library is symlinked.
     * <p>
     * Explanation: in JavaScript, multiple copies of the <code>cx-api</code> library on
     * disk are seen as independent, completely different libraries. As a
     * consequence, the class <code>NestedCloudAssemblyArtifact</code> in each copy of the <code>cx-api</code> library
     * is seen as a different class, and an instance of one class will not test as
     * <code>instanceof</code> the other class. <code>npm install</code> will not create installations
     * like this, but users may manually symlink construct libraries together or
     * use a monorepo tool: in those cases, multiple copies of the <code>cx-api</code>
     * library can be accidentally installed, and <code>instanceof</code> will behave
     * unpredictably. It is safest to avoid using <code>instanceof</code>, and using
     * this type-testing method instead.
     * <p>
     * @param art This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.Boolean isNestedCloudAssemblyArtifact(final @org.jetbrains.annotations.NotNull java.lang.Object art) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.cxapi.NestedCloudAssemblyArtifact.class, "isNestedCloudAssemblyArtifact", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class), new Object[] { art });
    }

    /**
     * The relative directory name of the asset manifest.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getDirectoryName() {
        return software.amazon.jsii.Kernel.get(this, "directoryName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Display name.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getDisplayName() {
        return software.amazon.jsii.Kernel.get(this, "displayName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Full path to the nested assembly directory.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getFullPath() {
        return software.amazon.jsii.Kernel.get(this, "fullPath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The nested Assembly.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.cxapi.CloudAssembly getNestedAssembly() {
        return software.amazon.jsii.Kernel.get(this, "nestedAssembly", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.cxapi.CloudAssembly.class));
    }
}
