/**
 * <h1>Cloud Executable API</h1>
 * <p>
 * This module is part of the <a href="https://github.com/aws/aws-cdk">AWS Cloud Development Kit</a> project.
 * <p>
 * <h2>V2 Feature Flags</h2>
 * <p>
 * <ul>
 * <li><code>&#64;aws-cdk/aws-s3:createDefaultLoggingPolicy</code></li>
 * </ul>
 * <p>
 * Enable this feature flag to create an S3 bucket policy by default in cases where
 * an AWS service would automatically create the Policy if one does not exist.
 * <p>
 * For example, in order to send VPC flow logs to an S3 bucket, there is a specific Bucket Policy
 * that needs to be attached to the bucket. If you create the bucket without a policy and then add the
 * bucket as the flow log destination, the service will automatically create the bucket policy with the
 * necessary permissions. If you were to then try and add your own bucket policy CloudFormation will throw
 * and error indicating that a bucket policy already exists.
 * <p>
 * In cases where we know what the required policy is we can go ahead and create the policy so we can
 * remain in control of it.
 * <p>
 * https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/AWS-logs-and-resource-policy.html#AWS-logs-infrastructure-S3
 * <p>
 * <em>cdk.json</em>
 * <p>
 * <blockquote><pre>
 * {
 *   "context": {
 *     "&#64;aws-cdk/aws-s3:createDefaultLoggingPolicy": true
 *   }
 * }
 * </pre></blockquote>
 * <p>
 * <ul>
 * <li><code>&#64;aws-cdk/aws-sns-subscriptions:restrictSqsDescryption</code></li>
 * </ul>
 * <p>
 * Enable this feature flag to restrict the decryption of a SQS queue, which is subscribed to a SNS topic, to
 * only the topic which it is subscribed to and not the whole SNS service of an account.
 * <p>
 * Previously the decryption was only restricted to the SNS service principal. To make the SQS subscription more
 * secure, it is a good practice to restrict the decryption further and only allow the connected SNS topic to decryption
 * the subscribed queue.
 * <p>
 * <em>cdk.json</em>
 * <p>
 * <blockquote><pre>
 * {
 *   "context": {
 *     "&#64;aws-cdk/aws-sns-subscriptions:restrictSqsDescryption": true
 *   }
 * }
 * </pre></blockquote>
 * <p>
 * <ul>
 * <li>&#64;aws-cdk/aws-apigateway:disableCloudWatchRole</li>
 * </ul>
 * <p>
 * Enable this feature flag to change the default behavior for aws-apigateway.RestApi and aws-apigateway.SpecRestApi
 * to <em>not</em> create a CloudWatch role and Account. There is only a single ApiGateway account per AWS
 * environment which means that each time you create a RestApi in your account the ApiGateway account
 * is overwritten. If at some point the newest RestApi is deleted, the ApiGateway Account and CloudWatch
 * role will also be deleted, breaking any existing ApiGateways that were depending on them.
 * <p>
 * When this flag is enabled you should either create the ApiGateway account and CloudWatch role
 * separately <em>or</em> only enable the cloudWatchRole on a single RestApi.
 * <p>
 * <em>cdk.json</em>
 * <p>
 * <blockquote><pre>
 * {
 *   "context": {
 *     "&#64;aws-cdk/aws-apigateway:disableCloudWatchRole": true
 *   }
 * }
 * </pre></blockquote>
 * <p>
 * <ul>
 * <li><code>&#64;aws-cdk/core:enablePartitionLiterals</code></li>
 * </ul>
 * <p>
 * Enable this feature flag to have <code>Stack.partition</code> return a literal string for a stack's partition
 * when the stack has a known region configured.  If the region is undefined, or set to an unknown value, the
 * <code>Stack.partition</code> will be the CloudFormation intrinsic value <code>AWS::Partition</code>.  Without this feature flag,
 * <code>Stack.partition</code> always returns the CloudFormation intrinsic value <code>AWS::Partition</code>.
 * <p>
 * This feature will often simplify ARN strings in CDK generated templates, for example:
 * <p>
 * <blockquote><pre>
 *  Principal:
 *    AWS:
 *      Fn::Join:
 *        - ""
 *        - - "arn:"
 *          - Ref: AWS::Partition
 *          - :iam::123456789876:root
 * </pre></blockquote>
 * <p>
 * becomes:
 * <p>
 * <blockquote><pre>
 *  Principal:
 *    AWS: "arn:aws:iam::123456789876:root"
 * </pre></blockquote>
 * <p>
 * <ul>
 * <li><code>&#64;aws-cdk/aws-ecs:disableExplicitDeploymentControllerForCircuitBreaker</code></li>
 * </ul>
 * <p>
 * Enable this feature flag to avoid setting the "ECS" deployment controller when adding a circuit breaker to an
 * ECS Service, as this will trigger a full replacement which fails to deploy when using set service names.
 * This does not change any behaviour as the default deployment controller when it is not defined is ECS.
 * <p>
 * <em>cdk.json</em>
 * <p>
 * <blockquote><pre>
 * {
 *   "context": {
 *     "&#64;aws-cdk/aws-ecs:disableExplicitDeploymentControllerForCircuitBreaker": true
 *   }
 * }
 * </pre></blockquote>
 * <p>
 * <ul>
 * <li><code>&#64;aws-cdk/aws-s3:serverAccessLogsUseBucketPolicy</code></li>
 * </ul>
 * <p>
 * Enable this feature flag to use S3 Bucket Policy for granting permission fo Server Access Logging
 * rather than using the canned <code>LogDeliveryWrite</code> ACL. ACLs do not work when Object Ownership is
 * enabled on the bucket.
 * <p>
 * This flag uses a Bucket Policy statement to allow Server Access Log delivery, following best
 * practices for S3.
 * <p>
 * https://docs.aws.amazon.com/AmazonS3/latest/userguide/enable-server-access-logging.html
 * <p>
 * <blockquote><pre>
 * {
 *   "context": {
 *     "&#64;aws-cdk/aws-s3:serverAccessLogsUseBucketPolicy": true
 *   }
 * }
 * </pre></blockquote>
 * <p>
 * <ul>
 * <li><code>&#64;aws-cdk/aws-rds:databaseProxyUniqueResourceName</code></li>
 * </ul>
 * <p>
 * Enable this feature flag to use unique resource names for each <code>DatabaseProxy</code>.
 * <p>
 * Previously, the default behavior for <code>DatabaseProxy</code> was to use <code>id</code> of the constructor for <code>dbProxyName</code>.
 * In this case, users couldn't deploy <code>DatabaseProxy</code>s that have the same <code>id</code> in the same region.
 * <p>
 * This is a feature flag as the old behavior was technically incorrect, but users may have come to depend on it.
 * <p>
 * <blockquote><pre>
 * {
 *   "context": {
 *     "&#64;aws-cdk/aws-rds:databaseProxyUniqueResourceName": true
 *   }
 * }
 * </pre></blockquote>
 * <p>
 * <ul>
 * <li><code>&#64;aws-cdk/aws-redshift:columnId</code></li>
 * </ul>
 * <p>
 * Enable this feature flag to allow the CDK to track changes in Redshift columns through their <code>id</code> attribute. This is a breaking change, as the <code>name</code> attribute was currently being used to track changes to Redshift columns.
 * <p>
 * Enabling this feature flag comes at a risk for existing Redshift columns, as the <code>name</code> attribute of a redshift column was currently being used. Therefore, to change a Redshift columns' <code>name</code> will essentially create a new column and delete the old one. This will cause data loss. If you choose to enable this flag, ensure that upon intial deployment (the first deployment after setting this feature flag), the <code>name</code> attribute of every column is not changed. After the intial deployment, you can freely change the <code>name</code> attribute of a column.
 * <p>
 * <em>cdk.json</em>
 * <p>
 * <blockquote><pre>
 * {
 *   "context": {
 *     "&#64;aws-cdk/aws-redshift:columnId": true
 *   }
 * }
 * </pre></blockquote>
 * <p>
 * <ul>
 * <li><code>&#64;aws-cdk/aws-stepfunctions-tasks:enableEmrServicePolicyV2</code></li>
 * </ul>
 * <p>
 * Enable this feature flag to use the <code>AmazonEMRServicePolicy_v2</code> managed policies for the EMR service role.
 * <p>
 * This is a feature flag as the old behavior will be deprecated, but some resources may require manual
 * intervention since they might not have the appropriate tags propagated automatically.
 * <p>
 * https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-managed-iam-policies.html
 * <p>
 * <em>cdk.json</em>
 * <p>
 * <blockquote><pre>
 * {
 *   "context": {
 *     "&#64;aws-cdk/aws-stepfunctions-tasks:enableEmrServicePolicyV2": true
 *   }
 * }
 * </pre></blockquote>
 * <p>
 * <ul>
 * <li><code>&#64;aws-cdk/core:includePrefixInUniqueNameGeneration</code></li>
 * </ul>
 * <p>
 * Enable this feature flag to include the stack's prefixes to the name generation process.
 * <p>
 * Not doing so can cause the name of stack to exceed 128 characters:
 * <p>
 * <ul>
 * <li>The name generation ensures it doesn't exceed 128 characters</li>
 * <li>Without this feature flag, the prefix is prepended to the generated name, which result can exceed 128 characters</li>
 * </ul>
 * <p>
 * This is a feature flag as it changes the name generated for stacks. Any CDK application deployed prior this fix will
 * most likely be generated with a new name, causing the stack to be recreated with the new name, and then deleting the old one.
 * For applications running on production environments this can be unmanageable.
 * <p>
 * <em>cdk.json</em>
 * <p>
 * <blockquote><pre>
 * {
 *   "context": {
 *     "&#64;aws-cdk/core:includePrefixInUniqueNameGeneration": true
 *   }
 * }
 * </pre></blockquote>
 * <p>
 * <ul>
 * <li><code>&#64;aws-cdk/aws-lambda-nodejs:useLatestRuntimeVersion</code></li>
 * </ul>
 * <p>
 * Enable this feature flag to automatically use the latest available NodeJS version in the aws-lambda-nodejse.Function construct.
 * <p>
 * This allows creation of new functions using a version that will automatically stay up to date without breaking bundling of existing functions that externalize packages included in their environemnt such as <code>aws-sdk</code>.
 * <p>
 * Functions defined previously will continue to function correctly as long as they pass an explicit runtime version, or do not exclude packages during bundling.
 * <p>
 * <em>cdk.json</em>
 * <p>
 * <blockquote><pre>
 * {
 *   "context": {
 *     "&#64;aws-cdk/aws-lambda-nodejs:useLatestRuntimeVersion": true
 *   }
 * }
 * </pre></blockquote>
 * <p>
 * <ul>
 * <li><code>&#64;aws-cdk/aws-codepipeline-actions:useNewDefaultBranchForCodeCommitSource</code></li>
 * </ul>
 * <p>
 * Enable this feature flag to update the default branch for CodeCommit source actions to <code>main</code>.
 * <p>
 * Previously, the default branch for CodeCommit source actions was set to <code>master</code>.
 * However, this convention is no longer supported, and repositories created after March 2021 now have <code>main</code> as
 * their default branch.
 * <p>
 * <em>cdk.json</em>
 * <p>
 * <blockquote><pre>
 * {
 *   "context": {
 *     "&#64;aws-cdk/aws-codepipeline-actions:useNewDefaultBranchForCodeCommitSource": true
 *   }
 * }
 * </pre></blockquote>
 * <p>
 * <ul>
 * <li><code>&#64;aws-cdk/aws-cloudwatch-actions:changeLambdaPermissionLogicalIdForLambdaAction</code></li>
 * </ul>
 * <p>
 * Enable this feature flag to change the logical ID of the <code>LambdaPermission</code> for the <code>LambdaAction</code> to include an alarm ID.
 * <p>
 * Previously, only one alarm with the <code>LambdaAction</code> could be created per Lambda.
 * This flag allows multiple alarms with the <code>LambdaAction</code> for the same Lambda to be created.
 * <p>
 * <em>cdk.json</em>
 * <p>
 * <blockquote><pre>
 * {
 *   "context": {
 *     "&#64;aws-cdk/aws-cloudwatch-actions:changeLambdaPermissionLogicalIdForLambdaAction": true
 *   }
 * }
 * </pre></blockquote>
 * <p>
 * <ul>
 * <li><code>&#64;aws-cdk/aws-codepipeline:crossAccountKeysDefaultValueToFalse</code></li>
 * </ul>
 * <p>
 * Enables Pipeline to set the default value for <code>crossAccountKeys</code> to false.
 * <p>
 * When this feature flag is enabled, and the <code>crossAccountKeys</code> property is not provided in a <code>Pipeline</code>
 * construct, the construct automatically defaults the value of this property to false.
 * <p>
 * <em>cdk.json</em>
 * <p>
 * <blockquote><pre>
 * {
 *   "context": {
 *     "&#64;aws-cdk/aws-codepipeline:crossAccountKeysDefaultValueToFalse": true
 *   }
 * }
 * </pre></blockquote>
 * <p>
 * <ul>
 * <li><code>&#64;aws-cdk/aws-codepipeline:defaultPipelineTypeToV2</code></li>
 * </ul>
 * <p>
 * Enables Pipeline to set the default pipeline type to V2.
 * <p>
 * When this feature flag is enabled, and the <code>pipelineType</code> property is not provided in a <code>Pipeline</code>
 * construct, the construct automatically defaults the value of this property to <code>PipelineType.V2</code>.
 * <p>
 * <em>cdk.json</em>
 * <p>
 * <blockquote><pre>
 * {
 *   "context": {
 *     "&#64;aws-cdk/aws-codepipeline:defaultPipelineTypeToV2": true
 *   }
 * }
 * </pre></blockquote>
 * <p>
 * <ul>
 * <li><code>&#64;aws-cdk/aws-kms:reduceCrossAccountRegionPolicyScope</code></li>
 * </ul>
 * <p>
 * Reduce resource scope of the IAM Policy created from KMS key grant to granting key only.
 * <p>
 * When this feature flag is enabled and calling KMS key grant method, the created IAM policy will reduce the resource scope from
 * '*' to this specific granting KMS key.
 * <p>
 * <em>cdk.json</em>
 * <p>
 * <blockquote><pre>
 * {
 *   "context": {
 *     "&#64;aws-cdk/aws-kms:reduceCrossAccountRegionPolicyScope": true
 *   }
 * }
 * </pre></blockquote>
 * <p>
 * <ul>
 * <li><code>&#64;aws-cdk/aws-eks:nodegroupNameAttribute</code></li>
 * </ul>
 * <p>
 * When enabled, nodegroupName attribute of the provisioned EKS NodeGroup will not have the cluster name prefix.
 * <p>
 * When this feature flag is enabled, the nodegroupName attribute will be exactly the name of the nodegroup
 * without any prefix.
 * <p>
 * <em>cdk.json</em>
 * <p>
 * <blockquote><pre>
 * {
 *   "context": {
 *     "&#64;aws-cdk/aws-eks:nodegroupNameAttribute": true
 *   }
 * }
 * </pre></blockquote>
 * <p>
 * <ul>
 * <li><code>&#64;aws-cdk/aws-ec2:ebsDefaultGp3Volume</code></li>
 * </ul>
 * <p>
 * When enabled, the default volume type of the EBS volume will be GP3.
 * <p>
 * When this featuer flag is enabled, the default volume type of the EBS volume will be <code>EbsDeviceVolumeType.GENERAL_PURPOSE_SSD_GP3</code>
 * <p>
 * <em>cdk.json</em>
 * <p>
 * <blockquote><pre>
 * {
 *   "context": {
 *     "&#64;aws-cdk/aws-ec2:ebsDefaultGp3Volume": true
 *   }
 * }
 * </pre></blockquote>
 */
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
package software.amazon.awscdk.cxapi;
