package software.amazon.awscdk.cxapi;

/**
 * Placeholders which can be used manifests.
 * <p>
 * These can occur both in the Asset Manifest as well as the general
 * Cloud Assembly manifest.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.cxapi.*;
 * EnvironmentPlaceholders environmentPlaceholders = new EnvironmentPlaceholders();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.99.0 (build 8f757e4)", date = "2024-06-20T19:49:51.102Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.cxapi.$Module.class, fqn = "@aws-cdk/cx-api.EnvironmentPlaceholders")
public class EnvironmentPlaceholders extends software.amazon.jsii.JsiiObject {

    protected EnvironmentPlaceholders(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected EnvironmentPlaceholders(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CURRENT_ACCOUNT = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.cxapi.EnvironmentPlaceholders.class, "CURRENT_ACCOUNT", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        CURRENT_PARTITION = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.cxapi.EnvironmentPlaceholders.class, "CURRENT_PARTITION", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        CURRENT_REGION = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.cxapi.EnvironmentPlaceholders.class, "CURRENT_REGION", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public EnvironmentPlaceholders() {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this);
    }

    /**
     * Replace the environment placeholders in all strings found in a complex object.
     * <p>
     * Duplicated between cdk-assets and aws-cdk CLI because we don't have a good single place to put it
     * (they're nominally independent tools).
     * <p>
     * @param object This parameter is required.
     * @param values This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.Object replace(final @org.jetbrains.annotations.NotNull java.lang.Object object, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.cxapi.EnvironmentPlaceholderValues values) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.cxapi.EnvironmentPlaceholders.class, "replace", software.amazon.jsii.NativeType.forClass(java.lang.Object.class), new Object[] { object, java.util.Objects.requireNonNull(values, "values is required") });
    }

    /**
     * Like 'replace', but asynchronous.
     * <p>
     * @param object This parameter is required.
     * @param provider This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.Object replaceAsync(final @org.jetbrains.annotations.NotNull java.lang.Object object, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.cxapi.IEnvironmentPlaceholderProvider provider) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.cxapi.EnvironmentPlaceholders.class, "replaceAsync", software.amazon.jsii.NativeType.forClass(java.lang.Object.class), new Object[] { object, java.util.Objects.requireNonNull(provider, "provider is required") });
    }

    /**
     * Insert this into the destination fields to be replaced with the current account.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CURRENT_ACCOUNT;

    /**
     * Insert this into the destination fields to be replaced with the current partition.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CURRENT_PARTITION;

    /**
     * Insert this into the destination fields to be replaced with the current region.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CURRENT_REGION;
}
