package software.amazon.awscdk.cxapi;

/**
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.cloudassembly.schema.*;
 * import software.amazon.awscdk.cxapi.*;
 * CloudAssembly cloudAssembly;
 * CloudFormationStackArtifact cloudFormationStackArtifact = CloudFormationStackArtifact.Builder.create(cloudAssembly, "artifactId")
 *         .type(ArtifactType.NONE)
 *         // the properties below are optional
 *         .dependencies(List.of("dependencies"))
 *         .displayName("displayName")
 *         .environment("environment")
 *         .metadata(Map.of(
 *                 "metadataKey", List.of(MetadataEntry.builder()
 *                         .type("type")
 *                         // the properties below are optional
 *                         .data("data")
 *                         .trace(List.of("trace"))
 *                         .build())))
 *         .properties(AwsCloudFormationStackProperties.builder()
 *                 .templateFile("templateFile")
 *                 // the properties below are optional
 *                 .assumeRoleArn("assumeRoleArn")
 *                 .assumeRoleExternalId("assumeRoleExternalId")
 *                 .bootstrapStackVersionSsmParameter("bootstrapStackVersionSsmParameter")
 *                 .cloudFormationExecutionRoleArn("cloudFormationExecutionRoleArn")
 *                 .lookupRole(BootstrapRole.builder()
 *                         .arn("arn")
 *                         // the properties below are optional
 *                         .assumeRoleExternalId("assumeRoleExternalId")
 *                         .bootstrapStackVersionSsmParameter("bootstrapStackVersionSsmParameter")
 *                         .requiresBootstrapStackVersion(123)
 *                         .build())
 *                 .parameters(Map.of(
 *                         "parametersKey", "parameters"))
 *                 .requiresBootstrapStackVersion(123)
 *                 .stackName("stackName")
 *                 .stackTemplateAssetObjectUrl("stackTemplateAssetObjectUrl")
 *                 .tags(Map.of(
 *                         "tagsKey", "tags"))
 *                 .terminationProtection(false)
 *                 .validateOnSynth(false)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.99.0 (build 8f757e4)", date = "2024-06-24T17:14:20.127Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.cxapi.$Module.class, fqn = "@aws-cdk/cx-api.CloudFormationStackArtifact")
public class CloudFormationStackArtifact extends software.amazon.awscdk.cxapi.CloudArtifact {

    protected CloudFormationStackArtifact(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CloudFormationStackArtifact(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param assembly This parameter is required.
     * @param artifactId This parameter is required.
     * @param artifact This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CloudFormationStackArtifact(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.cxapi.CloudAssembly assembly, final @org.jetbrains.annotations.NotNull java.lang.String artifactId, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.cloudassembly.schema.ArtifactManifest artifact) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(assembly, "assembly is required"), java.util.Objects.requireNonNull(artifactId, "artifactId is required"), java.util.Objects.requireNonNull(artifact, "artifact is required") });
    }

    /**
     * Checks if <code>art</code> is an instance of this class.
     * <p>
     * Use this method instead of <code>instanceof</code> to properly detect <code>CloudFormationStackArtifact</code>
     * instances, even when the construct library is symlinked.
     * <p>
     * Explanation: in JavaScript, multiple copies of the <code>cx-api</code> library on
     * disk are seen as independent, completely different libraries. As a
     * consequence, the class <code>CloudFormationStackArtifact</code> in each copy of the <code>cx-api</code> library
     * is seen as a different class, and an instance of one class will not test as
     * <code>instanceof</code> the other class. <code>npm install</code> will not create installations
     * like this, but users may manually symlink construct libraries together or
     * use a monorepo tool: in those cases, multiple copies of the <code>cx-api</code>
     * library can be accidentally installed, and <code>instanceof</code> will behave
     * unpredictably. It is safest to avoid using <code>instanceof</code>, and using
     * this type-testing method instead.
     * <p>
     * @param art This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.Boolean isCloudFormationStackArtifact(final @org.jetbrains.annotations.NotNull java.lang.Object art) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.cxapi.CloudFormationStackArtifact.class, "isCloudFormationStackArtifact", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class), new Object[] { art });
    }

    /**
     * Any assets associated with this stack.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<java.lang.Object> getAssets() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "assets", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * A string that represents this stack.
     * <p>
     * Should only be used in user
     * interfaces. If the stackName has not been set explicitly, or has been set
     * to artifactId, it will return the hierarchicalId of the stack. Otherwise,
     * it will return something like "<hierarchicalId> (<stackName>)"
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getDisplayName() {
        return software.amazon.jsii.Kernel.get(this, "displayName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The environment into which to deploy this artifact.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.cxapi.Environment getEnvironment() {
        return software.amazon.jsii.Kernel.get(this, "environment", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.cxapi.Environment.class));
    }

    /**
     * (deprecated) The physical name of this stack.
     * <p>
     * @deprecated renamed to <code>stackName</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public @org.jetbrains.annotations.NotNull java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The original name as defined in the CDK app.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getOriginalName() {
        return software.amazon.jsii.Kernel.get(this, "originalName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * CloudFormation parameters to pass to the stack.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.String> getParameters() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "parameters", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))));
    }

    /**
     * The physical name of this stack.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getStackName() {
        return software.amazon.jsii.Kernel.get(this, "stackName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * CloudFormation tags to pass to the stack.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.String> getTags() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))));
    }

    /**
     * The CloudFormation template for this stack.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getTemplate() {
        return software.amazon.jsii.Kernel.get(this, "template", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The file name of the template.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getTemplateFile() {
        return software.amazon.jsii.Kernel.get(this, "templateFile", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Full path to the template file.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getTemplateFullPath() {
        return software.amazon.jsii.Kernel.get(this, "templateFullPath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The role that needs to be assumed to deploy the stack.
     * <p>
     * Default: - No role is assumed (current credentials are used)
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getAssumeRoleArn() {
        return software.amazon.jsii.Kernel.get(this, "assumeRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * External ID to use when assuming role for cloudformation deployments.
     * <p>
     * Default: - No external ID
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getAssumeRoleExternalId() {
        return software.amazon.jsii.Kernel.get(this, "assumeRoleExternalId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Name of SSM parameter with bootstrap stack version.
     * <p>
     * Default: - Discover SSM parameter by reading stack
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getBootstrapStackVersionSsmParameter() {
        return software.amazon.jsii.Kernel.get(this, "bootstrapStackVersionSsmParameter", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The role that is passed to CloudFormation to execute the change set.
     * <p>
     * Default: - No role is passed (currently assumed role/credentials are used)
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getCloudFormationExecutionRoleArn() {
        return software.amazon.jsii.Kernel.get(this, "cloudFormationExecutionRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The role to use to look up values from the target AWS account.
     * <p>
     * Default: - No role is assumed (current credentials are used)
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.cloudassembly.schema.BootstrapRole getLookupRole() {
        return software.amazon.jsii.Kernel.get(this, "lookupRole", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.cloudassembly.schema.BootstrapRole.class));
    }

    /**
     * Version of bootstrap stack required to deploy this stack.
     * <p>
     * Default: - No bootstrap stack required
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getRequiresBootstrapStackVersion() {
        return software.amazon.jsii.Kernel.get(this, "requiresBootstrapStackVersion", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * If the stack template has already been included in the asset manifest, its asset URL.
     * <p>
     * Default: - Not uploaded yet, upload just before deploying
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getStackTemplateAssetObjectUrl() {
        return software.amazon.jsii.Kernel.get(this, "stackTemplateAssetObjectUrl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Whether termination protection is enabled for this stack.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Boolean getTerminationProtection() {
        return software.amazon.jsii.Kernel.get(this, "terminationProtection", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
    }

    /**
     * Whether this stack should be validated by the CLI after synthesis.
     * <p>
     * Default: - false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Boolean getValidateOnSynth() {
        return software.amazon.jsii.Kernel.get(this, "validateOnSynth", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
    }
}
