/**
 * <h1>Cloud Executable API</h1>
 * <p>
 * <!--BEGIN STABILITY BANNER-->---
 * <p>
 * <img alt="cdk-constructs: Stable" src="https://img.shields.io/badge/cdk--constructs-stable-success.svg?style=for-the-badge">
 * <p>
 * <hr>
 * <p>
 * <!--END STABILITY BANNER-->
 * <p>
 * This module is part of the <a href="https://github.com/aws/aws-cdk">AWS Cloud Development Kit</a> project.
 * <p>
 * <h2>V2 Feature Flags</h2>
 * <p>
 * <ul>
 * <li><code>&#64;aws-cdk/aws-s3:createDefaultLoggingPolicy</code></li>
 * </ul>
 * <p>
 * Enable this feature flag to create an S3 bucket policy by default in cases where
 * an AWS service would automatically create the Policy if one does not exist.
 * <p>
 * For example, in order to send VPC flow logs to an S3 bucket, there is a specific Bucket Policy
 * that needs to be attached to the bucket. If you create the bucket without a policy and then add the
 * bucket as the flow log destination, the service will automatically create the bucket policy with the
 * necessary permissions. If you were to then try and add your own bucket policy CloudFormation will throw
 * and error indicating that a bucket policy already exists.
 * <p>
 * In cases where we know what the required policy is we can go ahead and create the policy so we can
 * remain in control of it.
 * <p>
 * https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/AWS-logs-and-resource-policy.html#AWS-logs-infrastructure-S3
 * <p>
 * <em>cdk.json</em>
 * <p>
 * <blockquote><pre>
 * {
 *   "context": {
 *     "&#64;aws-cdk/aws-s3:createDefaultLoggingPolicy": true
 *   }
 * }
 * </pre></blockquote>
 * <p>
 * <ul>
 * <li><code>&#64;aws-cdk/aws-sns-subscriptions:restrictSqsDescryption</code></li>
 * </ul>
 * <p>
 * Enable this feature flag to restrict the decryption of a SQS queue, which is subscribed to a SNS topic, to
 * only the topic which it is subscribed to and not the whole SNS service of an account.
 * <p>
 * Previously the decryption was only restricted to the SNS service principal. To make the SQS subscription more
 * secure, it is a good practice to restrict the decryption further and only allow the connected SNS topic to decryption
 * the subscribed queue.
 * <p>
 * <em>cdk.json</em>
 * <p>
 * <blockquote><pre>
 * {
 *   "context": {
 *     "&#64;aws-cdk/aws-sns-subscriptions:restrictSqsDescryption": true
 *   }
 * }
 * </pre></blockquote>
 */
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
package software.amazon.awscdk.cxapi;
