/**
 * <h1>AWS Lambda Layer with kubectl (and helm)</h1>
 * <p>
 * <!--BEGIN STABILITY BANNER-->---
 * <p>
 * <img alt="End-of-Support" src="https://img.shields.io/badge/End--of--Support-critical.svg?style=for-the-badge">
 * <p>
 * <blockquote>
 * <p>
 * AWS CDK v1 has reached End-of-Support on 2023-06-01.
 * This package is no longer being updated, and users should migrate to AWS CDK v2.
 * <p>
 * For more information on how to migrate, see the <a href="https://docs.aws.amazon.com/cdk/v2/guide/migrating-v2.html"><em>Migrating to AWS CDK v2</em> guide</a>.
 * <p>
 * </blockquote>
 * <p>
 * <hr>
 * <p>
 * <!--END STABILITY BANNER-->
 * <p>
 * This module exports a single class called <code>KubectlLayer</code> which is a <code>lambda.Layer</code> that bundles the <a href="https://kubernetes.io/docs/reference/kubectl/kubectl/"><code>kubectl</code></a> and the <a href="https://helm.sh/"><code>helm</code></a> command line.
 * <p>
 * <blockquote>
 * <p>
 * <ul>
 * <li>Helm Version: 3.5.4</li>
 * <li>Kubectl Version: 1.20.0</li>
 * </ul>
 * <p>
 * </blockquote>
 * <p>
 * Usage:
 * <p>
 * <blockquote><pre>
 * // KubectlLayer bundles the 'kubectl' and 'helm' command lines
 * import software.amazon.awscdk.lambdalayer.kubectl.KubectlLayer;
 * 
 * Function fn;
 * 
 * fn.addLayers(new KubectlLayer(this, "KubectlLayer"));
 * </pre></blockquote>
 * <p>
 * <code>kubectl</code> will be installed under <code>/opt/kubectl/kubectl</code>, and <code>helm</code> will be installed under <code>/opt/helm/helm</code>.
 *
 * Deprecated: AWS CDK v1 has reached End-of-Support on 2023-06-01.
This package is no longer being updated, and users should migrate to AWS CDK v2.

For more information on how to migrate, see https://docs.aws.amazon.com/cdk/v2/guide/migrating-v2.html
 */
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@Deprecated
package software.amazon.awscdk.lambdalayer.kubectl;
