package software.amazon.awscdk.regioninfo;

/**
 * Information pertaining to an AWS region.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.10.5 (build 46bc9b0)", date = "2019-05-24T10:11:48.437Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.regioninfo.$Module.class, fqn = "@aws-cdk/region-info.RegionInfo")
public class RegionInfo extends software.amazon.jsii.JsiiObject {
    protected RegionInfo(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
        super(mode);
    }

    /**
     * Obtain region info for a given region name.
     * 
     * @param name the name of the region (e.g: us-east-1).
     */
    public static software.amazon.awscdk.regioninfo.RegionInfo get(final java.lang.String name) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.regioninfo.RegionInfo.class, "get", software.amazon.awscdk.regioninfo.RegionInfo.class, new Object[] { java.util.Objects.requireNonNull(name, "name is required") });
    }

    /**
     * The name of the service principal for a given service in this region.
     * 
     * @param service the service name (e.g: s3.amazonaws.com).
     */
    @javax.annotation.Nullable
    public java.lang.String servicePrincipal(final java.lang.String service) {
        return this.jsiiCall("servicePrincipal", java.lang.String.class, new Object[] { java.util.Objects.requireNonNull(service, "service is required") });
    }

    /**
     * Whether the `AWS::CDK::Metadata` CloudFormation Resource is available in this region or not.
     */
    public java.lang.Boolean getCdkMetadataResourceAvailable() {
        return this.jsiiGet("cdkMetadataResourceAvailable", java.lang.Boolean.class);
    }

    public java.lang.String getName() {
        return this.jsiiGet("name", java.lang.String.class);
    }

    /**
     * The domain name suffix (e.g: amazonaws.com) for this region.
     */
    @javax.annotation.Nullable
    public java.lang.String getDomainSuffix() {
        return this.jsiiGet("domainSuffix", java.lang.String.class);
    }

    /**
     * The name of the ARN partition for this region (e.g: aws).
     */
    @javax.annotation.Nullable
    public java.lang.String getPartition() {
        return this.jsiiGet("partition", java.lang.String.class);
    }

    /**
     * The endpoint used by S3 static website hosting in this region (e.g: s3-static-website-us-east-1.amazonaws.com).
     */
    @javax.annotation.Nullable
    public java.lang.String getS3StaticWebsiteEndpoint() {
        return this.jsiiGet("s3StaticWebsiteEndpoint", java.lang.String.class);
    }
}
