package software.amazon.awscdk.regioninfo;

/**
 * A database of regional information.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.11.0 (build 3d6415e)", date = "2019-05-30T15:00:21.169Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.regioninfo.$Module.class, fqn = "@aws-cdk/region-info.Fact")
public class Fact extends software.amazon.jsii.JsiiObject {
    protected Fact(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
        super(mode);
    }

    /**
     * Retrieves a fact from this Fact database.
     * 
     * @return the fact value if it is known, and `undefined` otherwise.
     * @param region the name of the region (e.g: `us-east-1`).
     * @param name the name of the fact being looked up (see the `FactName` class for details).
     */
    @javax.annotation.Nullable
    public static java.lang.String find(final java.lang.String region, final java.lang.String name) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.regioninfo.Fact.class, "find", java.lang.String.class, new Object[] { java.util.Objects.requireNonNull(region, "region is required"), java.util.Objects.requireNonNull(name, "name is required") });
    }

    /**
     * Registers a new fact in this Fact database.
     * 
     * @param fact the new fact to be registered.
     * @param allowReplacing whether new facts can replace existing facts or not.
     */
    public static void register(final software.amazon.awscdk.regioninfo.IFact fact, @javax.annotation.Nullable final java.lang.Boolean allowReplacing) {
        software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.regioninfo.Fact.class, "register", Void.class, new Object[] { java.util.Objects.requireNonNull(fact, "fact is required"), allowReplacing });
    }

    /**
     * Registers a new fact in this Fact database.
     * 
     * @param fact the new fact to be registered.
     */
    public static void register(final software.amazon.awscdk.regioninfo.IFact fact) {
        software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.regioninfo.Fact.class, "register", Void.class, new Object[] { java.util.Objects.requireNonNull(fact, "fact is required") });
    }

    /**
     * Removes a fact from the database.
     * 
     * @param region the region for which the fact is to be removed.
     * @param name the name of the fact to remove.
     * @param value the value that should be removed (removal will fail if the value is specified, but does not match the current stored value).
     */
    public static void unregister(final java.lang.String region, final java.lang.String name, @javax.annotation.Nullable final java.lang.String value) {
        software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.regioninfo.Fact.class, "unregister", Void.class, new Object[] { java.util.Objects.requireNonNull(region, "region is required"), java.util.Objects.requireNonNull(name, "name is required"), value });
    }

    /**
     * Removes a fact from the database.
     * 
     * @param region the region for which the fact is to be removed.
     * @param name the name of the fact to remove.
     */
    public static void unregister(final java.lang.String region, final java.lang.String name) {
        software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.regioninfo.Fact.class, "unregister", Void.class, new Object[] { java.util.Objects.requireNonNull(region, "region is required"), java.util.Objects.requireNonNull(name, "name is required") });
    }
}
