/**
 * <h1>AWS Region-Specific Information Directory</h1>
 * <!-- raw HTML omitted -->
 * <hr />
 * <p><img src="https://img.shields.io/badge/stability-Experimental-important.svg?style=for-the-badge" alt="Stability: Experimental" /></p>
 * <blockquote>
 * <p><strong>This is a <em>developer preview</em> (public beta) module. Releases might lack important features and might have
 * future breaking changes.</strong></p>
 * <p>This API is still under active development and subject to non-backward
 * compatible changes or removal in any future version. Use of the API is not recommended in production
 * environments. Experimental APIs are not subject to the Semantic Versioning model.</p>
 * </blockquote>
 * <hr />
 * <!-- raw HTML omitted -->
 * <h2>Usage</h2>
 * <p>Some information used in CDK Applications differs from one AWS region to
 * another, such as service principals used in IAM policies, S3 static website
 * endpoints, ...</p>
 * <h3>The <code>RegionInfo</code> class</h3>
 * <p>The library offers a simple interface to obtain region specific information in
 * the form of the <code>RegionInfo</code> class. This is the preferred way to interact with
 * the regional information database:</p>
 * <pre><code class="language-ts">import { RegionInfo } from '@aws-cdk/region-info';
 * 
 * // Get the information for &quot;eu-west-1&quot;:
 * const region = RegionInfo.get('eu-west-1');
 * 
 * // Access attributes:
 * region.s3StaticWebsiteEndpoint; // s3-website-eu-west-1.amazonaws.com
 * region.servicePrincipal('logs.amazonaws.com'); // logs.eu-west-1.amazonaws.com
 * </code></pre>
 * <p>The <code>RegionInfo</code> layer is built on top of the Low-Level API, which is described
 * below and can be used to register additional data, including user-defined facts
 * that are not available through the <code>RegionInfo</code> interface.</p>
 * <h3>Low-Level API</h3>
 * <p>This library offers a primitive database of such information so that CDK
 * constructs can easily access regional information. The <code>FactName</code> class provides
 * a list of known fact names, which can then be used with the <code>RegionInfo</code> to
 * retrieve a particular value:</p>
 * <pre><code class="language-ts">import regionInfo = require('@aws-cdk/region-info');
 * 
 * const codeDeployPrincipal = regionInfo.Fact.find('us-east-1', regionInfo.FactName.servicePrincipal('codedeploy.amazonaws.com'));
 * // =&gt; codedeploy.us-east-1.amazonaws.com
 * 
 * const staticWebsite = regionInfo.Fact.find('ap-northeast-1', regionInfo.FactName.S3_STATIC_WEBSITE_ENDPOINT);
 * // =&gt; s3-website-ap-northeast-1.amazonaws.com
 * </code></pre>
 * <h2>Supplying new or missing information</h2>
 * <p>As new regions are released, it might happen that a particular fact you need is
 * missing from the library. In such cases, the <code>Fact.register</code> method can be used
 * to inject FactName into the database:</p>
 * <pre><code class="language-ts">regionInfo.Fact.register({
 *   region: 'bermuda-triangle-1',
 *   name: regionInfo.FactName.servicePrincipal('s3.amazonaws.com'),
 *   value: 's3-website.bermuda-triangle-1.nowhere.com',
 * });
 * </code></pre>
 * <h2>Overriding incorrect information</h2>
 * <p>In the event information provided by the library is incorrect, it can be
 * overridden using the same <code>Fact.register</code> method demonstrated above, simply
 * adding an extra boolean argument:</p>
 * <pre><code class="language-ts">regionInfo.Fact.register({
 *   region: 'us-east-1',
 *   name: regionInfo.FactName.servicePrincipal('service.amazonaws.com'),
 *   value: 'the-correct-principal.amazonaws.com',
 * }, true /* Allow overriding information *{@literal /});
 * </code></pre>
 * <p>If you happen to have stumbled upon incorrect data built into this library, it
 * is always a good idea to report your findings in a <a href="https://github.com/aws/aws-cdk/issues">GitHub issue</a>, so we can fix
 * it for everyone else!</p>
 * <hr />
 * <p>This module is part of the <a href="https://github.com/aws/aws-cdk">AWS Cloud Development Kit</a> project.</p>
 * 
 */
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
package software.amazon.awscdk.regioninfo;
