/**
 * <h1>AWS Region-Specific Information Directory</h1>
 * <p>
 * <!--BEGIN STABILITY BANNER-->---
 * <p>
 * <img alt="End-of-Support" src="https://img.shields.io/badge/End--of--Support-critical.svg?style=for-the-badge">
 * <p>
 * <blockquote>
 * <p>
 * AWS CDK v1 has reached End-of-Support on 2023-06-01.
 * This package is no longer being updated, and users should migrate to AWS CDK v2.
 * <p>
 * For more information on how to migrate, see the <a href="https://docs.aws.amazon.com/cdk/v2/guide/migrating-v2.html"><em>Migrating to AWS CDK v2</em> guide</a>.
 * <p>
 * </blockquote>
 * <p>
 * <hr>
 * <p>
 * <!--END STABILITY BANNER-->
 * <p>
 * <h2>Usage</h2>
 * <p>
 * Some information used in CDK Applications differs from one AWS region to
 * another, such as service principals used in IAM policies, S3 static website
 * endpoints, ...
 * <p>
 * <h3>The <code>RegionInfo</code> class</h3>
 * <p>
 * The library offers a simple interface to obtain region specific information in
 * the form of the <code>RegionInfo</code> class. This is the preferred way to interact with
 * the regional information database:
 * <p>
 * <blockquote><pre>
 * // Get the information for "eu-west-1":
 * RegionInfo region = RegionInfo.get("eu-west-1");
 * 
 * // Access attributes:
 * region.getS3StaticWebsiteEndpoint(); // s3-website-eu-west-1.amazonaws.com
 * region.servicePrincipal("logs.amazonaws.com");
 * </pre></blockquote>
 * <p>
 * The <code>RegionInfo</code> layer is built on top of the Low-Level API, which is described
 * below and can be used to register additional data, including user-defined facts
 * that are not available through the <code>RegionInfo</code> interface.
 * <p>
 * <h3>Low-Level API</h3>
 * <p>
 * This library offers a primitive database of such information so that CDK
 * constructs can easily access regional information. The <code>FactName</code> class provides
 * a list of known fact names, which can then be used with the <code>RegionInfo</code> to
 * retrieve a particular value:
 * <p>
 * <blockquote><pre>
 * String codeDeployPrincipal = Fact.find("us-east-1", FactName.servicePrincipal("codedeploy.amazonaws.com"));
 * // =&gt; codedeploy.us-east-1.amazonaws.com
 * 
 * String staticWebsite = Fact.find("ap-northeast-1", FactName.S3_STATIC_WEBSITE_ENDPOINT);
 * </pre></blockquote>
 * <p>
 * <h2>Supplying new or missing information</h2>
 * <p>
 * As new regions are released, it might happen that a particular fact you need is
 * missing from the library. In such cases, the <code>Fact.register</code> method can be used
 * to inject FactName into the database:
 * <p>
 * <blockquote><pre>
 * public class MyFact implements IFact {
 *     public final Object region;
 *     public final Object name;
 *     public final Object value;
 * }
 * 
 * Fact.register(new MyFact());
 * </pre></blockquote>
 * <p>
 * <h2>Overriding incorrect information</h2>
 * <p>
 * In the event information provided by the library is incorrect, it can be
 * overridden using the same <code>Fact.register</code> method demonstrated above, simply
 * adding an extra boolean argument:
 * <p>
 * <blockquote><pre>
 * public class MyFact implements IFact {
 *     public final Object region;
 *     public final Object name;
 *     public final Object value;
 * }
 * 
 * Fact.register(new MyFact(), true);
 * </pre></blockquote>
 * <p>
 * If you happen to have stumbled upon incorrect data built into this library, it
 * is always a good idea to report your findings in a <a href="https://github.com/aws/aws-cdk/issues">GitHub issue</a>, so we can fix
 * it for everyone else!
 * <p>
 * <hr>
 * <p>
 * This module is part of the <a href="https://github.com/aws/aws-cdk">AWS Cloud Development Kit</a> project.
 *
 * Deprecated: AWS CDK v1 has reached End-of-Support on 2023-06-01.
This package is no longer being updated, and users should migrate to AWS CDK v2.

For more information on how to migrate, see https://docs.aws.amazon.com/cdk/v2/guide/migrating-v2.html
 */
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@Deprecated
package software.amazon.awscdk.regioninfo;
