package software.amazon.awscdk.regioninfo;

/**
 * A database of regional information.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.30.0 (build adae23f)", date = "2021-07-07T09:59:39.545Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.regioninfo.$Module.class, fqn = "@aws-cdk/region-info.Fact")
public class Fact extends software.amazon.jsii.JsiiObject {

    protected Fact(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Fact(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * Retrieves a fact from this Fact database.
     * <p>
     * @return the fact value if it is known, and `undefined` otherwise.
     * @param region the name of the region (e.g: `us-east-1`). This parameter is required.
     * @param name the name of the fact being looked up (see the `FactName` class for details). This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.Nullable java.lang.String find(final @org.jetbrains.annotations.NotNull java.lang.String region, final @org.jetbrains.annotations.NotNull java.lang.String name) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.regioninfo.Fact.class, "find", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { java.util.Objects.requireNonNull(region, "region is required"), java.util.Objects.requireNonNull(name, "name is required") });
    }

    /**
     * Registers a new fact in this Fact database.
     * <p>
     * @param fact the new fact to be registered. This parameter is required.
     * @param allowReplacing whether new facts can replace existing facts or not.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static void register(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.regioninfo.IFact fact, final @org.jetbrains.annotations.Nullable java.lang.Boolean allowReplacing) {
        software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.regioninfo.Fact.class, "register", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(fact, "fact is required"), allowReplacing });
    }

    /**
     * Registers a new fact in this Fact database.
     * <p>
     * @param fact the new fact to be registered. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static void register(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.regioninfo.IFact fact) {
        software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.regioninfo.Fact.class, "register", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(fact, "fact is required") });
    }

    /**
     * Retrieve a fact from the Fact database.
     * <p>
     * (retrieval will fail if the specified region or
     * fact name does not exist.)
     * <p>
     * @param region the name of the region (e.g: `us-east-1`). This parameter is required.
     * @param name the name of the fact being looked up (see the `FactName` class for details). This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String requireFact(final @org.jetbrains.annotations.NotNull java.lang.String region, final @org.jetbrains.annotations.NotNull java.lang.String name) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.regioninfo.Fact.class, "requireFact", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { java.util.Objects.requireNonNull(region, "region is required"), java.util.Objects.requireNonNull(name, "name is required") });
    }

    /**
     * Removes a fact from the database.
     * <p>
     * @param region the region for which the fact is to be removed. This parameter is required.
     * @param name the name of the fact to remove. This parameter is required.
     * @param value the value that should be removed (removal will fail if the value is specified, but does not match the current stored value).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static void unregister(final @org.jetbrains.annotations.NotNull java.lang.String region, final @org.jetbrains.annotations.NotNull java.lang.String name, final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.regioninfo.Fact.class, "unregister", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(region, "region is required"), java.util.Objects.requireNonNull(name, "name is required"), value });
    }

    /**
     * Removes a fact from the database.
     * <p>
     * @param region the region for which the fact is to be removed. This parameter is required.
     * @param name the name of the fact to remove. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static void unregister(final @org.jetbrains.annotations.NotNull java.lang.String region, final @org.jetbrains.annotations.NotNull java.lang.String name) {
        software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.regioninfo.Fact.class, "unregister", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(region, "region is required"), java.util.Objects.requireNonNull(name, "name is required") });
    }

    /**
     * @return the list of names of AWS regions for which there is at least one registered fact. This
     * may not be an exhaustive list of all available AWS regions.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getRegions() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.regioninfo.Fact.class, "regions", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))));
    }
}
