package software.amazon.awscdk.regioninfo;

/**
 * Information pertaining to an AWS region.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.regioninfo.RegionInfo;
 * // Get the information for "eu-west-1":
 * RegionInfo region = RegionInfo.get("eu-west-1");
 * // Access attributes:
 * region.getS3StaticWebsiteEndpoint(); // s3-website-eu-west-1.amazonaws.com
 * region.servicePrincipal("logs.amazonaws.com");
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.52.1 (build 5ccc8f6)", date = "2022-01-26T10:30:06.092Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.regioninfo.$Module.class, fqn = "@aws-cdk/region-info.RegionInfo")
public class RegionInfo extends software.amazon.jsii.JsiiObject {

    protected RegionInfo(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected RegionInfo(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * Obtain region info for a given region name.
     * <p>
     * @param name the name of the region (e.g: us-east-1). This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.regioninfo.RegionInfo get(final @org.jetbrains.annotations.NotNull java.lang.String name) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.regioninfo.RegionInfo.class, "get", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.regioninfo.RegionInfo.class), new Object[] { java.util.Objects.requireNonNull(name, "name is required") });
    }

    /**
     * Retrieves a collection of all fact values for all regions, limited to some partitions.
     * <p>
     * @return a mapping with AWS region codes as the keys,
     * and the fact in the given region as the value for that key
     * @param factName the name of the fact to retrieve values for. This parameter is required.
     * @param partitions list of partitions to retrieve facts for. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.String> limitedRegionMap(final @org.jetbrains.annotations.NotNull java.lang.String factName, final @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> partitions) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.regioninfo.RegionInfo.class, "limitedRegionMap", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)), new Object[] { java.util.Objects.requireNonNull(factName, "factName is required"), java.util.Objects.requireNonNull(partitions, "partitions is required") }));
    }

    /**
     * Retrieves a collection of all fact values for all regions that fact is defined in.
     * <p>
     * @return a mapping with AWS region codes as the keys,
     * and the fact in the given region as the value for that key
     * @param factName the name of the fact to retrieve values for. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.String> regionMap(final @org.jetbrains.annotations.NotNull java.lang.String factName) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.regioninfo.RegionInfo.class, "regionMap", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)), new Object[] { java.util.Objects.requireNonNull(factName, "factName is required") }));
    }

    /**
     * The ARN of the CloudWatch Lambda Insights extension, for the given version.
     * <p>
     * @param insightsVersion the version (e.g. 1.0.98.0). This parameter is required.
     * @param architecture the Lambda Function architecture (e.g. 'x86_64' or 'arm64').
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String cloudwatchLambdaInsightsArn(final @org.jetbrains.annotations.NotNull java.lang.String insightsVersion, final @org.jetbrains.annotations.Nullable java.lang.String architecture) {
        return software.amazon.jsii.Kernel.call(this, "cloudwatchLambdaInsightsArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { java.util.Objects.requireNonNull(insightsVersion, "insightsVersion is required"), architecture });
    }

    /**
     * The ARN of the CloudWatch Lambda Insights extension, for the given version.
     * <p>
     * @param insightsVersion the version (e.g. 1.0.98.0). This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String cloudwatchLambdaInsightsArn(final @org.jetbrains.annotations.NotNull java.lang.String insightsVersion) {
        return software.amazon.jsii.Kernel.call(this, "cloudwatchLambdaInsightsArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { java.util.Objects.requireNonNull(insightsVersion, "insightsVersion is required") });
    }

    /**
     * The name of the service principal for a given service in this region.
     * <p>
     * @param service the service name (e.g: s3.amazonaws.com). This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String servicePrincipal(final @org.jetbrains.annotations.NotNull java.lang.String service) {
        return software.amazon.jsii.Kernel.call(this, "servicePrincipal", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { java.util.Objects.requireNonNull(service, "service is required") });
    }

    /**
     * @return the list of names of AWS regions for which there is at least one registered fact. This
     * may not be an exaustive list of all available AWS regions.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.regioninfo.RegionInfo> getRegions() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.regioninfo.RegionInfo.class, "regions", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.regioninfo.RegionInfo.class))));
    }

    /**
     * Whether the `AWS::CDK::Metadata` CloudFormation Resource is available in this region or not.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Boolean getCdkMetadataResourceAvailable() {
        return software.amazon.jsii.Kernel.get(this, "cdkMetadataResourceAvailable", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ID of the AWS account that owns the public ECR repository that contains the AWS App Mesh Envoy Proxy images in a given region.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getAppMeshRepositoryAccount() {
        return software.amazon.jsii.Kernel.get(this, "appMeshRepositoryAccount", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ID of the AWS account that owns the public ECR repository containing the AWS Deep Learning Containers images in this region.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDlcRepositoryAccount() {
        return software.amazon.jsii.Kernel.get(this, "dlcRepositoryAccount", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The domain name suffix (e.g: amazonaws.com) for this region.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDomainSuffix() {
        return software.amazon.jsii.Kernel.get(this, "domainSuffix", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The hosted zone ID used by Route 53 to alias a EBS environment endpoint in this region (e.g: Z2O1EMRO9K5GLX).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getEbsEnvEndpointHostedZoneId() {
        return software.amazon.jsii.Kernel.get(this, "ebsEnvEndpointHostedZoneId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The account ID for ELBv2 in this region.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getElbv2Account() {
        return software.amazon.jsii.Kernel.get(this, "elbv2Account", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The CIDR block used by Kinesis Data Firehose servers.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getFirehoseCidrBlock() {
        return software.amazon.jsii.Kernel.get(this, "firehoseCidrBlock", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the ARN partition for this region (e.g: aws).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getPartition() {
        return software.amazon.jsii.Kernel.get(this, "partition", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The endpoint used by S3 static website hosting in this region (e.g: s3-static-website-us-east-1.amazonaws.com).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getS3StaticWebsiteEndpoint() {
        return software.amazon.jsii.Kernel.get(this, "s3StaticWebsiteEndpoint", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The hosted zone ID used by Route 53 to alias a S3 static website in this region (e.g: Z2O1EMRO9K5GLX).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getS3StaticWebsiteHostedZoneId() {
        return software.amazon.jsii.Kernel.get(this, "s3StaticWebsiteHostedZoneId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The prefix for VPC Endpoint Service names, cn.com.amazonaws.vpce for China regions, com.amazonaws.vpce otherwise.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getVpcEndpointServiceNamePrefix() {
        return software.amazon.jsii.Kernel.get(this, "vpcEndpointServiceNamePrefix", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }
}
