package software.amazon.awscdk.services.certificatemanager;

/**
 * A certificate managed by Amazon Certificate Manager
 * 
 * IMPORTANT: if you are creating a certificate as part of your stack, the stack
 * will not complete creating until you read and follow the instructions in the
 * email that you will receive.
 * 
 * ACM will send validation emails to the following addresses:
 * 
 *   admin@domain.com
 *   administrator@domain.com
 *   hostmaster@domain.com
 *   postmaster@domain.com
 *   webmaster@domain.com
 * 
 * For every domain that you register.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.7.15 (build e429c41)", date = "2019-03-05T00:09:20.728Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.certificatemanager.$Module.class, fqn = "@aws-cdk/aws-certificatemanager.Certificate")
public class Certificate extends software.amazon.awscdk.Construct implements software.amazon.awscdk.services.certificatemanager.ICertificate {
    protected Certificate(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
        super(mode);
    }
    public Certificate(final software.amazon.awscdk.Construct scope, final java.lang.String id, final software.amazon.awscdk.services.certificatemanager.CertificateProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, java.util.stream.Stream.concat(java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(scope, "scope is required")), java.util.stream.Stream.of(java.util.Objects.requireNonNull(id, "id is required"))), java.util.stream.Stream.of(java.util.Objects.requireNonNull(props, "props is required"))).toArray());
    }

    /**
     * Import a certificate
     */
    public static software.amazon.awscdk.services.certificatemanager.ICertificate import_(final software.amazon.awscdk.Construct scope, final java.lang.String id, final software.amazon.awscdk.services.certificatemanager.CertificateImportProps props) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.certificatemanager.Certificate.class, "import", software.amazon.awscdk.services.certificatemanager.ICertificate.class, java.util.stream.Stream.concat(java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(scope, "scope is required")), java.util.stream.Stream.of(java.util.Objects.requireNonNull(id, "id is required"))), java.util.stream.Stream.of(java.util.Objects.requireNonNull(props, "props is required"))).toArray());
    }

    /**
     * Export this certificate from the stack
     */
    @Override
    public software.amazon.awscdk.services.certificatemanager.CertificateImportProps export() {
        return this.jsiiCall("export", software.amazon.awscdk.services.certificatemanager.CertificateImportProps.class);
    }

    /**
     * The certificate's ARN
     */
    @Override
    public java.lang.String getCertificateArn() {
        return this.jsiiGet("certificateArn", java.lang.String.class);
    }
}
